/**
******************************************************************************
* File Name          : time_utilities.h
* Description        :    
* Source	     : https://ru.wikipedia.org/wiki/UNIX-%D0%B2%D1%80%D0%B5%D0%BC%D1%8F                     
*                      
******************************************************************************
*/

#ifndef __TIME_UTILITIES_H
#define __TIME_UTILITIES_H

#ifdef __cplusplus
extern "C" {
#endif 

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
  
#define SEC_IN_MIN (60U)
  /* Exported types -----------------------------------------------------------*/  
#pragma pack(1)
typedef struct
  {       /* date and time components */
    uint8_t	        sec;
    uint8_t	        min;
    uint8_t	        hour;
    uint8_t	        day;
    uint8_t	        mon;
    uint16_t	        year;
  }time_struct_t;
#pragma pack()

  /* Exported macro ------------------------------------------------------------*/
#define EGTS_UNIX_TIME_OFFSET           (1262304000UL)
  
  /* Exported functions ------------------------------------------------------ */   
  /* 
  convert scalar time to time structure 
  */
  void conv_unixtime_to_time(time_struct_t *time, uint32_t unix_time);
  /* 
  convert time structure to scalar time 
  */
  uint32_t conv_time_to_unixtime(const time_struct_t *time);
  /* 
  return egts time
  */
  uint32_t conv_unixtime_to_egtstime(uint32_t unix_time);
  /* 
  return true if time_now > time_alarm
  */
  bool timeAfter(uint32_t time_now, uint32_t time_alarm);
  
#ifdef __cplusplus
}
#endif 

#endif /* __TIME_UTILITIES_H */
