/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __GPS_UART_H
#define __GPS_UART_H

#ifdef __cplusplus
extern "C" {
#endif 
  
/* Includes ----------------------------------------------------------------*/
#include "string.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h" 
#include "cbuff/cbuff.h"  
  
/* Private define ----------------------------------------------------------*/
#define GPS_RX_CBUFF_SIZE                  (2048)
#define GPS_UART                           USART3
#define GPS_UART_IRQn                      USART3_IRQn
#define GPS_UART_IRQHandler                USART3_IRQHandler   
#define GPS_UART_IRQn_PRIO                 12 //highest-1 priority with use FreeRTOS API
#define GPS_DEF_UART_BAUD_RATE             ((uint32_t)(9600))

#define GPS_UART_TX_PIN                    GPIO_Pin_8
#define GPS_UART_TX_PORT                   GPIOD

#define GPS_UART_RX_PIN                    GPIO_Pin_9
#define GPS_UART_RX_PORT                   GPIOD

#define __GPS_UART_REMAP()                 {GPIO_PinAFConfig(GPS_UART_TX_PORT, GPIO_PinSource8, GPIO_AF_USART3); GPIO_PinAFConfig(GPS_UART_RX_PORT, GPIO_PinSource9, GPIO_AF_USART3);}    

#define __GPS_UART_CLOCK_ENABLE()          (RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART3, ENABLE))
#define __GPS_UART_CLOCK_DISABLE()         (RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART3, DISABLE))

#define __GPS_AFIO_CLOCK_ENABLE()          //
#define __GPS_AFIO_CLOCK_DISABLE()         //
  
//#define GPS_RX_SYNC_STRING                    "$GNRMC"
//#define GPS_RX_SYNC_STRING_LEN                (sizeof(GPS_RX_SYNC_STRING)-1)
  
typedef struct
{
  uint8_t rx_mem[GPS_RX_CBUFF_SIZE];
    
  uint8_t rx_full_flag;
  uint8_t rx_ore_flag;
  cbuff_t rx_cbuff;
  uint16_t max_filled_size;
  SemaphoreHandle_t rx_sem;
  
  SemaphoreHandle_t tx_sem;
  uint8_t* tx_data;
  uint8_t* tx_data_end;
  
  const char* rx_sync_string;
  uint8_t rx_sync_string_len;
  
  uint8_t is_init;
  //uint32_t baud_rate;
}gps_uart_driver_t;
  
  
/* Exported functions ----------------------------------------------------- */   
void gps_uart_init(uint32_t baud_rate, const char* rx_sync_string);
void gps_uart_deinit(void);

void gps_uart_write(uint8_t *src, uint16_t len);
int16_t gps_uart_read(uint8_t *dst, uint16_t len);
uint8_t gps_uart_wait_sync(uint32_t time_mS);
int16_t gps_uart_avl_len(void);
void gps_uart_flush_rx(void);

/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __GPS_UART_H */