/**
******************************************************************************
* File Name          : leds_driver.c
* Description        : Leds 
*                      
*                      
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "leds_driver.h"

/* Defines -------------------------------------------------------------------*/

/* Global variables-----------------------------------------------------------*/
#if (!defined(BOOTLOADER))
static volatile struct leds_struct
{
  uint8_t brightness;
  uint8_t r;
  uint8_t g;
  uint8_t b;
}leds_state={20, 0, 0, 0};
#endif //(!defined(BOOTLOADER))

/* Public functions ----------------------------------------------------------*/
#if defined(BOOTLOADER)
void LedR_On(void){DA_LedR_On();}
void LedR_Off(void){DA_LedR_Off();}
void LedR_Toggle(void){DA_LedR_Toggle();}
void LedG_On(void){DA_LedG_On();}
void LedG_Off(void){DA_LedG_Off();}
void LedG_Toggle(void){DA_LedG_Toggle();}
void LedB_On(void){DA_LedB_On();}
void LedB_Off(void){DA_LedB_Off();}
void LedB_Toggle(void){DA_LedB_Toggle();}
void LedCAN_On(void){DA_LedCAN_On();}
void LedCAN_Off(void){DA_LedCAN_Off();}
void LedCAN_Toggle(void){DA_LedCAN_Toggle();}
#else
void LedR_On(void){leds_state.r=1;}
void LedR_Off(void){leds_state.r=0;}
void LedR_Toggle(void){leds_state.r=!leds_state.r;}
void LedG_On(void){leds_state.g=1;}
void LedG_Off(void){leds_state.g=0;}
void LedG_Toggle(void){leds_state.g=!leds_state.g;}
void LedB_On(void){leds_state.b=1;}
void LedB_Off(void){leds_state.b=0;}
void LedB_Toggle(void){leds_state.b=!leds_state.b;}
void LedCAN_On(void){DA_LedCAN_On();}
void LedCAN_Off(void){DA_LedCAN_Off();}
void LedCAN_Toggle(void){DA_LedCAN_Toggle();}

void Leds_SetBrightness(uint8_t brightness)
{
  if(brightness<=100) leds_state.brightness=brightness;
}
#endif //defined(BOOTLOADER)

void Leds_Init(void)
{
 GPIO_InitTypeDef GPIO_InitStructure;
#if (!defined(BOOTLOADER))
  TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
  TIM_OCInitTypeDef  TIM_OCInitStructure;
  NVIC_InitTypeDef NVIC_InitStructure;
#endif //(!defined(BOOTLOADER))
  
 /* Configure Leds pin as push-pull */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
   
  GPIO_InitStructure.GPIO_Pin = LedG_Pin;
  GPIO_Init(LedG_Port, &GPIO_InitStructure);
  LedG_Off();
  
  GPIO_InitStructure.GPIO_Pin = LedB_Pin;
  GPIO_Init(LedB_Port, &GPIO_InitStructure);
  LedB_Off();
    
  GPIO_InitStructure.GPIO_Pin = LedR_Pin;
  GPIO_Init(LedR_Port, &GPIO_InitStructure);
  LedR_Off();
    
  GPIO_InitStructure.GPIO_Pin = LedCAN_Pin;
  GPIO_Init(LedCAN_Port, &GPIO_InitStructure);
  LedCAN_Off();
  
  DA_LedB_Off();
  DA_LedR_Off();
  DA_LedG_Off();
  DA_LedCAN_Off();
  
  #if (!defined(BOOTLOADER))
   __LEDS_TIMx_CLOCK_ENABLE();
  
  TIM_DeInit(LEDS_TIMx);
  
  /* Time base configuration */
  TIM_TimeBaseStructure.TIM_Period = 100;
  //if(is_sleep_mode)
  //  TIM_TimeBaseStructure.TIM_Prescaler = (LEDS_TIMx_RCC_CLOCK_IN_SLEEP*LEDS_ON_GROUP_CNT)/(100*LEDS_UPDATE_RATE_HZ*TOTAL_LEDS_NUM)-1;  
  // else 
    TIM_TimeBaseStructure.TIM_Prescaler = (LEDS_TIMx_RCC_CLOCK)/(100*LEDS_UPDATE_RATE_HZ)-1;  
  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
  TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
  TIM_TimeBaseInit(LEDS_TIMx, &TIM_TimeBaseStructure);
  
  TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_Timing;
  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Disable;
  TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_High;  
  TIM_OCInitStructure.TIM_Pulse = leds_state.brightness; 
  TIM_OC1Init(LEDS_TIMx, &TIM_OCInitStructure);
  
  /* Enable the TIM gloabal Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = LEDS_TIMx_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = LEDS_TIMx_IRQn_PRIO;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;/* Not used as 4 bits are used for the pre-emption priority. */
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  LEDS_TIMx->SR = ~TIM_IT_Update;
  LEDS_TIMx->SR = ~TIM_IT_CC1;
  LEDS_TIMx->CNT = 0;
  
  LEDS_TIMx->DIER |= TIM_IT_Update;
  LEDS_TIMx->DIER |= TIM_IT_CC1;

  LEDS_TIMx->CR1 |= TIM_CR1_CEN;
#endif //(!defined(BOOTLOADER))
}
   
void Leds_DeInit(void)
{
#if defined(BOOTLOADER)
  GPIO_InitTypeDef GPIO_InitStructure;

  /* Configure Leds pins as analog */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;

  GPIO_InitStructure.GPIO_Pin = LedG_Pin;
  GPIO_Init(LedG_Port, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LedB_Pin;
  GPIO_Init(LedB_Port, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LedR_Pin;
  GPIO_Init(LedR_Port, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LedCAN_Pin;
  GPIO_Init(LedCAN_Port, &GPIO_InitStructure);
#else
  LEDS_TIMx->DIER &= ~TIM_IT_Update;
  LEDS_TIMx->DIER &= ~TIM_IT_CC1;
  
  TIM_DeInit(LEDS_TIMx);
  __LEDS_TIMx_CLOCK_DISABLE();
  
  DA_LedB_Off();
  DA_LedR_Off();
  DA_LedG_Off();
#endif //defined(BOOTLOADER)
}

#ifdef __cplusplus
extern "C" {
#endif 
  #if (!defined(BOOTLOADER))
  #pragma optimize=speed
  void LEDS_TIMx_IRQHandler(void)
  {
    if((LEDS_TIMx->SR & TIM_IT_Update))// && (LEDS_TIMx->DIER & TIM_IT_Update))
    {
      LEDS_TIMx->SR = ~TIM_IT_Update;
      
      uint8_t curr_brightness=LEDS_TIMx->CCR1;
      if(leds_state.brightness!=curr_brightness)
      {
        if(leds_state.brightness>100) leds_state.brightness=100;
        LEDS_TIMx->CCR1=leds_state.brightness;
      }
            
      if(leds_state.b)  {DA_LedB_On();}
      else              {DA_LedB_Off();}
      if(leds_state.r)  {DA_LedR_On();}
      else              {DA_LedR_Off();}
      if(leds_state.g)  {DA_LedG_On();}
      else              {DA_LedG_Off();}
    }
    
    if((LEDS_TIMx->SR & TIM_IT_CC1))// && (LEDS_TIMx->DIER & TIM_IT_CC1))
    {
      LEDS_TIMx->SR = ~TIM_IT_CC1;
      
      DA_LedB_Off();
      DA_LedR_Off();
      DA_LedG_Off();
    }
  }
#endif //(!defined(BOOTLOADER))
#ifdef __cplusplus
}
#endif 