/**
******************************************************************************
* File Name          :
* Description        :
*                      
*                      
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include "mfi_driver.h"

#define SLOW_TIMER_TICK_US      (10000)
#define MAX_PERIOD_VAL          (__UINT32_T_MAX__)
#define MAX_MEASURE_PERIOD_S    (10)

//static EMfi_type prev_input_type[MFI_INPUT_CNT]={DIG_IN, DIG_IN};

static volatile struct mfi_adc_it_struct
{
  uint32_t avg_value[MFI_INPUT_CNT];
  uint8_t  avg_counter;
  uint8_t input_idx;
  uint8_t is_conv_ready;
}mfi_adc_it;


static volatile struct mfi_exti_tim_it_struct
{
  uint32_t prev_tim_val[MFI_INPUT_CNT];
  uint32_t slow_tim_reg;
}mfi_exti_tim_it;


static volatile struct mfi_raw_vals_struct
{
  uint32_t signal_edge_counter[MFI_INPUT_CNT];
  uint32_t signal_edge_counter_prev[MFI_INPUT_CNT];
  uint32_t signal_period[MFI_INPUT_CNT];
  uint32_t signal_adc_vals[MFI_INPUT_CNT];
}mfi_raw_vals;

typedef struct
{
  GPIO_TypeDef*   dig_in_port;
  uint16_t        dig_in_pin;
  uint32_t        dig_in_exti_line;     
  uint8_t         dig_in_exti_port_source;      
  uint8_t         dig_in_exti_pin_source;
  uint32_t        dig_in_rcc;
  
  GPIO_TypeDef*   pull_port;
  uint16_t        pull_pin;
  uint32_t        pull_rcc;
  
  GPIO_TypeDef*   an_in_port;
  uint16_t        an_in_pin;
  uint8_t         an_in_adc_chanel; 
}mfi_pins_definition_t;

static const mfi_pins_definition_t mfi[] =
{
  {MFI1_DIG_PORT, MFI1_DIG_PIN, MFI1_DIG_EXTI_LINE, MFI1_DIG_EXTI_PORT_SOURCE, MFI1_DIG_EXTI_PIN_SOURCE, MFI1_DIG_RCC, MFI1_PULL_PORT, MFI1_PULL_PIN, MFI1_PULL_RCC, MFI1_AN_PORT, MFI1_AN_PIN, MFI1_AN_ADC_CHANEL},
  {MFI2_DIG_PORT, MFI2_DIG_PIN, MFI2_DIG_EXTI_LINE, MFI2_DIG_EXTI_PORT_SOURCE, MFI2_DIG_EXTI_PIN_SOURCE, MFI2_DIG_RCC, MFI2_PULL_PORT, MFI2_PULL_PIN, MFI2_PULL_RCC, MFI2_AN_PORT, MFI2_AN_PIN, MFI2_AN_ADC_CHANEL},
  {MFI3_DIG_PORT, MFI3_DIG_PIN, MFI3_DIG_EXTI_LINE, MFI3_DIG_EXTI_PORT_SOURCE, MFI3_DIG_EXTI_PIN_SOURCE, MFI3_DIG_RCC, MFI3_PULL_PORT, MFI3_PULL_PIN, MFI3_PULL_RCC, MFI3_AN_PORT, MFI3_AN_PIN, MFI3_AN_ADC_CHANEL},
  {MFI4_DIG_PORT, MFI4_DIG_PIN, MFI4_DIG_EXTI_LINE, MFI4_DIG_EXTI_PORT_SOURCE, MFI4_DIG_EXTI_PIN_SOURCE, MFI4_DIG_RCC, MFI4_PULL_PORT, MFI4_PULL_PIN, MFI4_PULL_RCC, MFI4_AN_PORT, MFI4_AN_PIN, MFI4_AN_ADC_CHANEL},
  {MFI5_DIG_PORT, MFI5_DIG_PIN, MFI5_DIG_EXTI_LINE, MFI5_DIG_EXTI_PORT_SOURCE, MFI5_DIG_EXTI_PIN_SOURCE, MFI5_DIG_RCC, MFI5_PULL_PORT, MFI5_PULL_PIN, MFI5_PULL_RCC, MFI5_AN_PORT, MFI5_AN_PIN, MFI5_AN_ADC_CHANEL}
};

static_assert(!(sizeof(mfi)/sizeof(mfi_pins_definition_t)!=MFI_INPUT_CNT), "wrong definition mfi count");

void mfi_gpio_init(void)
{
  if(sizeof(mfi)/sizeof(mfi_pins_definition_t)!=MFI_INPUT_CNT) for(;;);
  
  GPIO_InitTypeDef GPIO_InitStructure;

  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    GPIO_InitStructure.GPIO_Pin = mfi[i].an_in_pin;
    GPIO_Init(mfi[i].an_in_port, &GPIO_InitStructure);
  }
  
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    GPIO_InitStructure.GPIO_Pin = mfi[i].pull_pin;
    GPIO_Init(mfi[i].pull_port, &GPIO_InitStructure);
    __MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);
  }
  
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    GPIO_InitStructure.GPIO_Pin = mfi[i].dig_in_pin;
    GPIO_Init(mfi[i].dig_in_port, &GPIO_InitStructure);
  }
}

uint32_t mfi_get_dig_ins_rcc(void)
{
  uint32_t rcc=0;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    rcc|=mfi[i].dig_in_rcc;
  }
  return rcc;
}

void mfi_init(void)
{
  if(sizeof(mfi)/sizeof(mfi_pins_definition_t)!=MFI_INPUT_CNT) for(;;);
  
  TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStructure;
  ADC_InitTypeDef ADC_InitStructure;
  EXTI_InitTypeDef EXTI_InitStructure;
  NVIC_InitTypeDef NVIC_InitStructure;
    
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  { 
    mfi_raw_vals.signal_adc_vals[i]=0;
    mfi_raw_vals.signal_period[i]=0;
    System.Grab(portMAX_DELAY);
    mfi_raw_vals.signal_edge_counter[i]=System.signal_state.pulse_input[i];
    System.Release();
    mfi_raw_vals.signal_edge_counter_prev[i]=mfi_raw_vals.signal_edge_counter[i];
  }
  
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {  
    mfi_exti_tim_it.prev_tim_val[i]=0;
  }
  mfi_exti_tim_it.slow_tim_reg=0;
    
  //   
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {  
    TMfi_settings settings;
    
    System.Grab(portMAX_DELAY);
    memcpy(&settings, &System.sensor_settings.mfi[i], sizeof(settings));
    System.Release();
    
    if(settings.input_type==DIG_IN || settings.input_type==FREQ_IN  || settings.input_type==PULSE_IN)
    {
      if(settings.polarity==ACTIVE_0) {__MFIx_PULL_UP(mfi[i].pull_port, mfi[i].pull_pin);}
      else                            {__MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);}
    }
    else //ANALOG_IN
    {
      __MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);
    }
  }
  
  EXTI_InitStructure.EXTI_LineCmd = ENABLE;
  EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
  EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    SYSCFG_EXTILineConfig(mfi[i].dig_in_exti_port_source, mfi[i].dig_in_exti_pin_source);
    EXTI_ClearITPendingBit(mfi[i].dig_in_exti_line);
    EXTI_InitStructure.EXTI_Line = mfi[i].dig_in_exti_line;
    EXTI_Init(&EXTI_InitStructure);
  }  
  
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = MFI_TIM_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannel = MFI_TIM_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  __MFI_TIM_CLOCK_CMD(ENABLE);
  
  TIM_TimeBaseInitStructure.TIM_Prescaler=MFI_TIM_CLOCK_MHZ-1;
  TIM_TimeBaseInitStructure.TIM_CounterMode=TIM_CounterMode_Up;
  TIM_TimeBaseInitStructure.TIM_Period=SLOW_TIMER_TICK_US;
  TIM_TimeBaseInitStructure.TIM_ClockDivision=TIM_CKD_DIV1;
  TIM_TimeBaseInitStructure.TIM_RepetitionCounter=0;
  
  TIM_DeInit(MFI_TIM);
  TIM_TimeBaseInit(MFI_TIM, &TIM_TimeBaseInitStructure);
  
  mfi_exti_tim_it.slow_tim_reg=0;
  MFI_TIM->SR = ~TIM_IT_Update; //clear Update IT flag
  MFI_TIM->DIER |= TIM_IT_Update;//enable Update IT
  MFI_TIM->CR1 |= TIM_CR1_CEN;//start timer
    
  NVIC_InitStructure.NVIC_IRQChannel = MFI_EXTI_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = MFI_EXTI_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    mfi_adc_it.avg_value[i]=0;
  }
  mfi_adc_it.avg_counter=0;
  mfi_adc_it.input_idx=0;
  
  __MFI_ADC_CLOCK_CMD(ENABLE);
  
  NVIC_InitStructure.NVIC_IRQChannel = MFI_ADC_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = MFI_ADC_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
    
  /* MFI_ADC configuration ------------------------------------------------------*/ 
  ADC_InitStructure.ADC_Resolution = ADC_Resolution_12b;
  ADC_InitStructure.ADC_ScanConvMode = DISABLE;
  ADC_InitStructure.ADC_ContinuousConvMode = DISABLE;
  ADC_InitStructure.ADC_ExternalTrigConvEdge = ADC_ExternalTrigConvEdge_None;
  ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_T1_CC1;
  ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
  ADC_InitStructure.ADC_NbrOfConversion = MFI_INPUT_CNT;

  ADC_Init(MFI_ADC, &ADC_InitStructure);
  
  ///* MFI_ADC injected external trigger configuration */
  //ADC_ExternalTrigInjectedConvConfig(MFI_ADC, ADC_ExternalTrigInjecConv_None);
  
  /* Enable MFI_ADC */
  ADC_Cmd(MFI_ADC, ENABLE);
    
  ADC_ClearITPendingBit(MFI_ADC, ADC_IT_EOC);
  ADC_ITConfig(MFI_ADC, ADC_IT_EOC, ENABLE);
  
  mfi_adc_it.is_conv_ready=0;
  ADC_RegularChannelConfig(MFI_ADC, mfi[mfi_adc_it.input_idx].an_in_adc_chanel, 1, ADC_SampleTime_480Cycles);
  ADC_SoftwareStartConv(MFI_ADC);
}

void mfi_deinit(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  EXTI_InitTypeDef EXTI_InitStructure;
  
  NVIC_InitStructure.NVIC_IRQChannel = MFI_EXTI_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = MFI_EXTI_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannelCmd = DISABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  EXTI_InitStructure.EXTI_LineCmd = DISABLE;
  EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
  EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling;
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    SYSCFG_EXTILineConfig(mfi[i].dig_in_exti_port_source, mfi[i].dig_in_exti_pin_source);
    EXTI_ClearITPendingBit(mfi[i].dig_in_exti_line);
    EXTI_InitStructure.EXTI_Line = mfi[i].dig_in_exti_line;
    EXTI_Init(&EXTI_InitStructure);
  }  
  
  MFI_TIM->DIER&=~TIM_IT_Update;//disable Update IT
  MFI_TIM->CR1&=~TIM_CR1_CEN;//stop timer
  __MFI_TIM_CLOCK_CMD(DISABLE);
  
  ADC_ITConfig(MFI_ADC, ADC_IT_EOC, DISABLE);
  __MFI_ADC_CLOCK_CMD(DISABLE);
}

void mfi_handler(void)
{
  uint8_t is_analog_input_present=0;
  
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    TMfi_settings settings;
   
    System.Grab(portMAX_DELAY);
    memcpy(&settings, &System.sensor_settings.mfi[i], sizeof(settings));
    System.Release();
      
    if(settings.input_type==DIG_IN)
    {
      if(settings.polarity==ACTIVE_0) {__MFIx_PULL_UP(mfi[i].pull_port, mfi[i].pull_pin);}
      else                            {__MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);}
      
      uint8_t res;
      res=__GET_MFIx_IN_STATE(mfi[i].dig_in_port, mfi[i].dig_in_pin);
      if(settings.polarity==ACTIVE_0) res=!res;
      
      System.Grab(portMAX_DELAY);
      System.signal_state.digital_input[i]=res;
      System.Release();
    }
    else if(settings.input_type==FREQ_IN)
    {
      if(settings.polarity==ACTIVE_0) {__MFIx_PULL_UP(mfi[i].pull_port, mfi[i].pull_pin);}
      else                            {__MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);}
            
      uint32_t  prev_tim_val=mfi_exti_tim_it.prev_tim_val[i];
      if((prev_tim_val+MAX_MEASURE_PERIOD_S*1000000-mfi_exti_tim_it.slow_tim_reg) & 0x80000000UL)
        mfi_raw_vals.signal_period[i]=MAX_PERIOD_VAL;
      
      uint32_t raw_val=mfi_raw_vals.signal_period[i];
      float freq;
      if(raw_val) freq=(1000000.0f)/((float)raw_val); 
      else        freq=0;
      
      System.Grab(portMAX_DELAY);
      System.signal_state.freq_input[i]=freq;
      System.Release();
    }
    else if(settings.input_type==PULSE_IN)
    {
      //if(prev_input_type[i]!=PULSE_IN) mfi_raw_vals.signal_edge_counter[i]=0;
      
      if(settings.polarity==ACTIVE_0) {__MFIx_PULL_UP(mfi[i].pull_port, mfi[i].pull_pin);}
      else                            {__MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);}
                   
      uint32_t val_1=mfi_raw_vals.signal_edge_counter_prev[i];
      uint32_t val_2=mfi_raw_vals.signal_edge_counter[i];
      mfi_raw_vals.signal_edge_counter_prev[i]=val_2;
      val_2=val_2-val_1;

      System.Grab(portMAX_DELAY);
      System.signal_state.pulse_input[i]+=val_2;
      System.Release();
    }
    else //ANALOG_IN
    {
      is_analog_input_present=1;
      
      __MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);
      
      if(mfi_adc_it.is_conv_ready)
      {      
        uint32_t raw_val=mfi_raw_vals.signal_adc_vals[i];
        float adc_val;
        adc_val=((float)raw_val)*MFI_ADC_K;
        
        System.Grab(portMAX_DELAY);
        System.signal_state.analog_input[i]=adc_val;
        System.Release();
      }      
    }
    //prev_input_type[i]=settings.input_type;
  }
  
  if(is_analog_input_present && mfi_adc_it.is_conv_ready)
  {
    mfi_adc_it.is_conv_ready=0;
    ADC_RegularChannelConfig(MFI_ADC, mfi[mfi_adc_it.input_idx].an_in_adc_chanel, 1, ADC_SampleTime_480Cycles);
    ADC_SoftwareStartConv(MFI_ADC);
  }
}

void mfi_handler_in_sleep(void)
{
  for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
  {
    if(System.sensor_settings.mfi[i].input_type==DIG_IN)
    {
      if(System.sensor_settings.mfi[i].polarity==ACTIVE_0) {__MFIx_PULL_UP(mfi[i].pull_port, mfi[i].pull_pin);}
      else                                                 {__MFIx_PULL_DOWN(mfi[i].pull_port, mfi[i].pull_pin);}
      
      uint8_t res;
      res=__GET_MFIx_IN_STATE(mfi[i].dig_in_port, mfi[i].dig_in_pin);
      if(System.sensor_settings.mfi[i].polarity==ACTIVE_0) res=!res;
      
      System.signal_state.digital_input[i]=res;
    }
    //prev_input_type[i]=System.sensor_settings.mfi[i].input_type;
  }
}

uint32_t get_mfi_adc_rav_val(uint8_t idx)
{
  return mfi_raw_vals.signal_adc_vals[idx];
}

#ifdef __cplusplus
extern "C" {
#endif 
  
#pragma optimize=speed
  void MFI_TIM_IRQHandler(void)
  {
    if(MFI_TIM->SR & TIM_IT_Update)
    {
      MFI_TIM->SR = ~TIM_IT_Update;//clear IT flag
      mfi_exti_tim_it.slow_tim_reg+=SLOW_TIMER_TICK_US;
    }
    else
    {//   
      MFI_TIM->CR1&=~TIM_CR1_CEN;//stop timer
    }  
  }
  
#pragma optimize=speed
  void MFI_EXTI_IRQHandler(void)
  {
    for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
    {
      if(EXTI_GetITStatus(mfi[i].dig_in_exti_line) != RESET)
      { 
        EXTI_ClearITPendingBit(mfi[i].dig_in_exti_line);
        
        uint32_t curr_tim_val=mfi_exti_tim_it.slow_tim_reg;
        uint16_t tim_cnt=MFI_TIM->CNT;
        /*   ,     ,        */
        if(curr_tim_val!=mfi_exti_tim_it.slow_tim_reg)
          curr_tim_val=mfi_exti_tim_it.slow_tim_reg;
        else
          curr_tim_val+=tim_cnt;
        
        if(curr_tim_val>=mfi_exti_tim_it.prev_tim_val[i]) mfi_raw_vals.signal_period[i]=curr_tim_val-mfi_exti_tim_it.prev_tim_val[i];
        else                                              mfi_raw_vals.signal_period[i]=(MAX_PERIOD_VAL-mfi_exti_tim_it.prev_tim_val[i])+curr_tim_val;
        
        mfi_exti_tim_it.prev_tim_val[i]=curr_tim_val;
        
        mfi_raw_vals.signal_edge_counter[i]++;
      }
    }
  }
  
#pragma optimize=speed
  void MFI_ADC_IRQHandler(void)
  {    
    if(ADC_GetITStatus(MFI_ADC, ADC_IT_EOC) != RESET)
    {
      ADC_ClearITPendingBit(MFI_ADC, ADC_IT_EOC);
      
      uint8_t input_idx=mfi_adc_it.input_idx++;
      mfi_adc_it.avg_value[input_idx]+=ADC_GetConversionValue(MFI_ADC);
      if(mfi_adc_it.input_idx>=MFI_INPUT_CNT) 
      {
        mfi_adc_it.avg_counter++;
        if(mfi_adc_it.avg_counter>=MFI_ADC_AVERAGING)
        {
          mfi_adc_it.avg_counter=0;
          for(uint8_t i=0; i<MFI_INPUT_CNT; i++)
          {
            mfi_raw_vals.signal_adc_vals[i]=mfi_adc_it.avg_value[i];
            mfi_adc_it.avg_value[i]=0;
          }
          mfi_adc_it.is_conv_ready=1;
        }
        mfi_adc_it.input_idx=0;
      }
      
      if(!mfi_adc_it.is_conv_ready)
      {
        ADC_RegularChannelConfig(MFI_ADC, mfi[mfi_adc_it.input_idx].an_in_adc_chanel, 1, ADC_SampleTime_480Cycles);
        ADC_SoftwareStartConv(MFI_ADC);
      }
    }
    else
    {
      //for(;;);
    }
  }
  
#ifdef __cplusplus
}
#endif 
