/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __MFI_DRIVER_H
#define __MFI_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif 
  
  /* Includes ----------------------------------------------------------------*/
#include "stm32f2xx.h"
#include "system_config.h"
#include "System/system.h"
#include <stdint.h>
  
  
/* Private define ----------------------------------------------------------*/
#define MFI_INPUT_CNT                           MAX_MF_INPUTS 
    
#define MFI1_AN_PIN                             GPIO_Pin_1
#define MFI1_AN_PORT                            GPIOA
#define MFI1_AN_ADC_CHANEL                      ADC_Channel_1

#define MFI1_DIG_PIN                            GPIO_Pin_5
#define MFI1_DIG_PORT                           GPIOE
#define MFI1_DIG_EXTI_LINE                      EXTI_Line5
#define MFI1_DIG_EXTI_PORT_SOURCE               EXTI_PortSourceGPIOE
#define MFI1_DIG_EXTI_PIN_SOURCE                EXTI_PinSource5
#define MFI1_DIG_RCC                            RCC_AHB1Periph_GPIOE

#define MFI1_PULL_PIN                           GPIO_Pin_6
#define MFI1_PULL_PORT                          GPIOA
#define MFI1_PULL_RCC                           RCC_AHB1Periph_GPIOA

#define MFI2_AN_PIN                             GPIO_Pin_2
#define MFI2_AN_PORT                            GPIOA
#define MFI2_AN_ADC_CHANEL                      ADC_Channel_2

#define MFI2_DIG_PIN                            GPIO_Pin_6
#define MFI2_DIG_PORT                           GPIOE
#define MFI2_DIG_EXTI_LINE                      EXTI_Line6
#define MFI2_DIG_EXTI_PORT_SOURCE               EXTI_PortSourceGPIOE
#define MFI2_DIG_EXTI_PIN_SOURCE                EXTI_PinSource6
#define MFI2_DIG_RCC                            RCC_AHB1Periph_GPIOE

#define MFI2_PULL_PIN                           GPIO_Pin_7
#define MFI2_PULL_PORT                          GPIOA
#define MFI2_PULL_RCC                           RCC_AHB1Periph_GPIOA

#define MFI3_AN_PIN                             GPIO_Pin_3
#define MFI3_AN_PORT                            GPIOA
#define MFI3_AN_ADC_CHANEL                      ADC_Channel_3

#define MFI3_DIG_PIN                            GPIO_Pin_7
#define MFI3_DIG_PORT                           GPIOE
#define MFI3_DIG_EXTI_LINE                      EXTI_Line7
#define MFI3_DIG_EXTI_PORT_SOURCE               EXTI_PortSourceGPIOE
#define MFI3_DIG_EXTI_PIN_SOURCE                EXTI_PinSource7
#define MFI3_DIG_RCC                            RCC_AHB1Periph_GPIOE

#define MFI3_PULL_PIN                           GPIO_Pin_10
#define MFI3_PULL_PORT                          GPIOE
#define MFI3_PULL_RCC                           RCC_AHB1Periph_GPIOE
  
#define MFI4_AN_PIN                             GPIO_Pin_4
#define MFI4_AN_PORT                            GPIOA
#define MFI4_AN_ADC_CHANEL                      ADC_Channel_4

#define MFI4_DIG_PIN                            GPIO_Pin_8
#define MFI4_DIG_PORT                           GPIOE
#define MFI4_DIG_EXTI_LINE                      EXTI_Line8
#define MFI4_DIG_EXTI_PORT_SOURCE               EXTI_PortSourceGPIOE
#define MFI4_DIG_EXTI_PIN_SOURCE                EXTI_PinSource8
#define MFI4_DIG_RCC                            RCC_AHB1Periph_GPIOE

#define MFI4_PULL_PIN                           GPIO_Pin_11
#define MFI4_PULL_PORT                          GPIOE
#define MFI4_PULL_RCC                           RCC_AHB1Periph_GPIOE
  
#define MFI5_AN_PIN                             GPIO_Pin_5
#define MFI5_AN_PORT                            GPIOA
#define MFI5_AN_ADC_CHANEL                      ADC_Channel_5

#define MFI5_DIG_PIN                            GPIO_Pin_9
#define MFI5_DIG_PORT                           GPIOE
#define MFI5_DIG_EXTI_LINE                      EXTI_Line9
#define MFI5_DIG_EXTI_PORT_SOURCE               EXTI_PortSourceGPIOE
#define MFI5_DIG_EXTI_PIN_SOURCE                EXTI_PinSource9
#define MFI5_DIG_RCC                            RCC_AHB1Periph_GPIOE

#define MFI5_PULL_PIN                           GPIO_Pin_12
#define MFI5_PULL_PORT                          GPIOE
#define MFI5_PULL_RCC                           RCC_AHB1Periph_GPIOE  
  
#define MFI_EXTI_IRQn                           EXTI9_5_IRQn
#define MFI_EXTI_IRQHandler                     EXTI9_5_IRQHandler
#define MFI_EXTI_IRQ_PRIORITY                   13//highest-x priority with use FreeRTOS API
  
#define MFI_TIM_CLOCK_MHZ                       60
#define MFI_TIM                                 TIM5
#define MFI_TIM_IRQn                            TIM5_IRQn
#define MFI_TIM_IRQHandler                      TIM5_IRQHandler
#define MFI_TIM_IRQ_PRIORITY                    12//highest-x priority with use FreeRTOS API
   
#define MFI_ADC                                 ADC2
#define MFI_ADC_IRQn                            ADC_IRQn
#define MFI_ADC_IRQHandler                      ADC_IRQHandler  
#define MFI_ADC_IRQ_PRIORITY                    15//lowest priority with use FreeRTOS API   
#define MFI_ADC_AVERAGING                       16 
    
#define MFI_ADC_VREF                            (3.3)
#define MFI_ADC_R1                              (220.0)  
#define MFI_ADC_R2                              (22.0)  
#define MFI_ADC_K                               ((float)((MFI_ADC_VREF*((MFI_ADC_R1+MFI_ADC_R2)/MFI_ADC_R2))/(4095.0*MFI_ADC_AVERAGING)))

  
/* Private macro -------------------------------------------------------------*/   
#define __MFIx_PULL_DOWN(port, pin)            (GPIO_SetBits(port, pin))
#define __MFIx_PULL_UP(port, pin)              (GPIO_ResetBits(port, pin))  
#define __GET_MFIx_IN_STATE(port, pin)         (!!(port->IDR & pin))
  
#define __MFI_ADC_CLOCK_CMD(ENABLE_OR_DISABLE) (RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC2, ENABLE_OR_DISABLE)) 
#define __MFI_TIM_CLOCK_CMD(ENABLE_OR_DISABLE) (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM5, ENABLE_OR_DISABLE))


/* Exported types -----------------------------------------------------------*/

  
  
/* Exported functions ----------------------------------------------------- */   
void mfi_gpio_init(void);
void mfi_init(void);
void mfi_deinit(void);
void mfi_handler(void);
void mfi_handler_in_sleep(void);
uint32_t mfi_get_dig_ins_rcc(void);
uint32_t get_mfi_adc_rav_val(uint8_t idx);
/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __MFI_DRIVER_H */