/**
******************************************************************************
* File Name          : modem_uart.h
* Description        : modem uart for stm32l1xx
*                      
*                      
******************************************************************************
*/
#ifndef __MODEM_UART_H
#define __MODEM_UART_H

#ifdef __cplusplus
extern "C" {
#endif 
  
  /* Includes ----------------------------------------------------------------*/
#include "stm32f2xx.h"
#include "string.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h" 
#include "time_utilities/time_utilities.h"
#include "cbuff/cbuff.h"  
#include "debug_port.h"  
  
  /* Exported types -----------------------------------------------------------*/
  typedef struct
  {
    uint8_t is_init;
    cbuff_t cbuff;
    SemaphoreHandle_t* sync_obj;
    uint8_t full_flag;
    uint8_t ore_flag;
  }modem_uart_rx_t;
  
/* Private define ----------------------------------------------------------*/
#define EN_MODEM_DEBUG                       0

#define STRING_LEN                           (0xffff)
  
#define MODEM_UART_TX_OK                     1 
#define MODEM_UART_TX_TIMEOUT_ERR            0 

#define USE_MODEM_UART_DMA_RX                0
#define USE_MODEM_UART_DMA_TX                0

#define MODEM_RX_MEM_SIZE                    (256)
#define MODEM_RX_BUFF_WM                     (MODEM_RX_MEM_SIZE/4)
      
#define MODEM_UART                           USART2
#define MODEM_UART_IRQn                      USART2_IRQn
#define MODEM_UART_IRQHandler                USART2_IRQHandler   
#define MODEM_UART_IRQn_PRIO                 12 //highest-1 priority with use FreeRTOS API
#define MODEM_UART_BAUD_RATE                 ((uint32_t)(115200))

#define MODEM_UART_BUFF_FILLING_TIME_1_2     ((uint32_t)(((1000*MODEM_RX_MEM_SIZE)/2)/((MODEM_UART_BAUD_RATE/10))))//   
#define MODEM_UART_BUFF_FILLING_TIME_1_4     ((uint32_t)(((1000*MODEM_RX_MEM_SIZE)/4)/((MODEM_UART_BAUD_RATE/10))))//   

#define MODEM_UART_TX_PIN                    GPIO_Pin_5
#define MODEM_UART_TX_PORT                   GPIOD
#define MODEM_UART_TX_PIN_MODE               GPIO_OType_OD

#define MODEM_UART_RX_PIN                    GPIO_Pin_6
#define MODEM_UART_RX_PORT                   GPIOD

#define MODEM_UART_SOFT_RTS_PIN              GPIO_Pin_4
#define MODEM_UART_SOFT_RTS_PORT             GPIOD
#define MODEM_UART_SOFT_RTS_PIN_MODE         GPIO_OType_OD

#define MODEM_UART_CTS_PIN                   GPIO_Pin_3
#define MODEM_UART_CTS_PORT                  GPIOD

   /* Private macro -------------------------------------------------------------*/   
#define __MODEM_UART_REMAP()                 {GPIO_PinAFConfig(MODEM_UART_TX_PORT, GPIO_PinSource5, GPIO_AF_USART2); GPIO_PinAFConfig(MODEM_UART_RX_PORT, GPIO_PinSource6, GPIO_AF_USART2); GPIO_PinAFConfig(MODEM_UART_CTS_PORT, GPIO_PinSource3, GPIO_AF_USART2);}    
#define __MODEM_UART_CLOCK_ENABLE()          (RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2, ENABLE))
#define __MODEM_UART_CLOCK_DISABLE()         (RCC_APB1PeriphClockCmd(RCC_APB1Periph_USART2, DISABLE))
#define __MODEM_UART_SOFT_RTS_PIN_HI()       (GPIO_SetBits(MODEM_UART_SOFT_RTS_PORT, MODEM_UART_SOFT_RTS_PIN))
#define __MODEM_UART_SOFT_RTS_PIN_LOW()      (GPIO_ResetBits(MODEM_UART_SOFT_RTS_PORT, MODEM_UART_SOFT_RTS_PIN))
  


/* Exported functions ----------------------------------------------------- */   
void ModemUartInit(void);
void ModemUartDeInit(void);
int16_t WriteToModemUart(uint8_t *out_data, uint16_t num_of_bytes, TickType_t time_wait);
modem_uart_rx_t* GetModemUartRxStructPtr(void);

/* External variables --------------------------------------------------------*/ 
#if EN_MODEM_DEBUG > 0
extern __IO uint8_t modem_tx_log_out_en;
extern __IO uint8_t modem_rx_log_out_en;
#endif

#ifdef __cplusplus
}
#endif 

#endif /* __MODEM_UART_H */