/**
******************************************************************************
* File Name          : nvic_exti_driver.c
* Description        :  NVIC   EXTI
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "stm32f2xx.h"
#include "nvic_exti_driver.h"

/* Defines -------------------------------------------------------------------*/
//- EXTI NVIC Priority
#define EXTI3_IRQn_PRIO            15

/* Global variables-----------------------------------------------------------*/
/* Public functions ----------------------------------------------------------*/

void LIS_IRQ_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  // Configure LIS_IRQ pin as analog
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN;
  GPIO_InitStructure.GPIO_Pin = LIS_IRQ_Pin;
  GPIO_Init(LIS_IRQ_GPIO_Port, &GPIO_InitStructure);
  
  // Configure the EXTI LINE  for LIS_IRQ
  __LIS_SPI_EXTI_LINE_CONFIG();
  // Configure the EXTI IRQ  for LIS_IRQ   // NVIC must be disabled!!!  
  EXTI_InitTypeDef EXTI_InitStructure;
  EXTI_InitStructure.EXTI_Line = LIS_IRQ_EXTI_LINEx;
  EXTI_InitStructure.EXTI_Mode = EXTI_Mode_Interrupt;
  EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling; // ???? !!!!!!!
  EXTI_InitStructure.EXTI_LineCmd = ENABLE;
  EXTI_Init(&EXTI_InitStructure);
  __LIS_IRQ_EXTI_DISNABLE(); 	// Disable EXTI IRQ! 
  EXTI_ClearITPendingBit(LIS_IRQ_EXTI_LINEx);         //  . Now NVIC may be anabled.
}  

void NVIC_EXTI3_Init(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  // Enable the EXTI interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = EXTI3_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = EXTI3_IRQn_PRIO;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure); 
  NVIC_DisableIRQ(EXTI3_IRQn);
}


//   
void EXTI3_IRQHandler(void)
{
  if(SET==EXTI_GetITStatus(LIS_IRQ_EXTI_LINEx)) 
  {
    EXTI_ClearITPendingBit(LIS_IRQ_EXTI_LINEx);	// Clear Interrupt flag
    LIS_IRQ_Handler();
    //EXTI_ClearITPendingBit(LIS_IRQ_EXTI_LINEx);	// Clear Interrupt flag
  }
}
