/**
******************************************************************************
* File Name          : nvic_exti_driver.h
* Description        :  NVIC   EXTI
*
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __NVIC_EXTI_DRIVER_H
#define __NVIC_EXTI_DRIVER_H
#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
/* Defines -------------------------------------------------------------------*/

//-   LIS_IRQ  AFIO_EXTI 
#define LIS_IRQ_GPIO_Port        GPIOE
#define LIS_IRQ_Pin              GPIO_Pin_3
#define __LIS_SPI_EXTI_LINE_CONFIG()	(SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOE, GPIO_PinSource3))

//- LIS_IRQn EXTI 
#define LIS_IRQ_EXTI_LINEx      EXTI_Line3
#define LIS_NVIC_IRQn		EXTI3_IRQn
#define __LIS_IRQ_NVIC_Init()   (NVIC_EXTI3_Init())
//#define __LIS_IRQ_NVIC_ENABLE()  (NVIC_EnableIRQ(EXTI3_IRQn))

#define __LIS_IRQ_EXTI_ENABLE()		(EXTI->IMR|=EXTI_IMR_MR3)	// SPL - %@$&@!!!
#define __LIS_IRQ_EXTI_DISNABLE()	(EXTI->IMR&=~EXTI_IMR_MR3)

/* Extern functions ----------------------------------------------------------*/
void LIS_IRQ_Handler(void);

/* Public functions ----------------------------------------------------------*/
void LIS_IRQ_Init(void);
void NVIC_EXTI3_Init(void);

#ifdef __cplusplus
 }
#endif
#endif // __NVIC_EXTI_DRIVER_H
