/**
******************************************************************************
* File Name          :
* Description        :
*                      
*                      
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include "outputs_driver.h"
#include <math.h>

#define MAX_OUT_FREQ_HZ    (1500)
#define MIN_OUT_FREQ_HZ    (1)

#if MAX_FREQ_OUTPUTS > MAX_DIGITAL_OUTPUTS
#error     
#endif

#if MAX_FREQ_OUTPUTS > 1
#error           1
#endif

static volatile struct output_tim_it_struct
{
  uint8_t output_idx;
  uint16_t output_freq;
}output_tim_it;

typedef struct
{
  GPIO_TypeDef*   port;
  uint16_t        pin;
  uint32_t        rcc;
}outputs_pins_definition_t;

static const outputs_pins_definition_t outputs[] =
{
  {OUTPUT1_PORT,  OUTPUT1_PIN,  OUTPUT1_RCC},
  {OUTPUT2_PORT,  OUTPUT2_PIN,  OUTPUT2_RCC},
  {OUTPUT3_PORT,  OUTPUT3_PIN,  OUTPUT3_RCC},
  {OUTPUT4_PORT,  OUTPUT4_PIN,  OUTPUT4_RCC},
  {OUTPUT5_PORT,  OUTPUT5_PIN,  OUTPUT5_RCC},
  {OUTPUT6_PORT,  OUTPUT6_PIN,  OUTPUT6_RCC},
  {OUTPUT7_PORT,  OUTPUT7_PIN,  OUTPUT7_RCC},
  {OUTPUT8_PORT,  OUTPUT8_PIN,  OUTPUT8_RCC},
  {OUTPUT9_PORT,  OUTPUT9_PIN,  OUTPUT9_RCC},
  {OUTPUT10_PORT, OUTPUT10_PIN, OUTPUT10_RCC},
};

static_assert(!(sizeof(outputs)/sizeof(outputs_pins_definition_t)!=OUTPUTS_CNT), "wrong definition outputs count");

void outputs_init(void)
{
  if(sizeof(outputs)/sizeof(outputs_pins_definition_t)!=OUTPUTS_CNT) for(;;);
  
  GPIO_InitTypeDef GPIO_InitStructure;
  NVIC_InitTypeDef NVIC_InitStructure;
  
  output_tim_it.output_idx=0xff;
  output_tim_it.output_freq=0xffff;
    
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  for(uint8_t i=0; i<OUTPUTS_CNT; i++)
  {
    if(System.signal_state.digital_output[i]) {__OUTPUTx_ON(outputs[i].port, outputs[i].pin);}
    else                                      {__OUTPUTx_OFF(outputs[i].port, outputs[i].pin);}
    
    GPIO_InitStructure.GPIO_Pin = outputs[i].pin;
    GPIO_Init(outputs[i].port, &GPIO_InitStructure);
    //__OUTPUTx_PULL_UP(outputs[i].port, outputs[i].pin);
  }
    
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = OUTPUTS_TIM_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannel = OUTPUTS_TIM_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  __OUTPUTS_TIM_CLOCK_CMD(ENABLE);
}

void outputs_deinit(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

  OUTPUTS_TIM->DIER&=~TIM_IT_Update;//disable Update IT
  OUTPUTS_TIM->CR1&=~TIM_CR1_CEN;//stop timer
  __OUTPUTS_TIM_CLOCK_CMD(DISABLE);
  
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  for(uint8_t i=0; i<OUTPUTS_CNT; i++)
  {
    GPIO_InitStructure.GPIO_Pin = outputs[i].pin;
    GPIO_Init(outputs[i].port, &GPIO_InitStructure);
  }
}

void outputs_handler(void)
{
  TFreq_output_settings freq_out_settings;
  uint16_t freq_output;
  
  if(MAX_FREQ_OUTPUTS > 0)
  {
    System.Grab(portMAX_DELAY);
    memcpy(&freq_out_settings, &System.sensor_settings.freq_out[0], sizeof(freq_out_settings));
    freq_output=System.signal_state.freq_output[0];
    System.Release();
  }
  else
  {
    freq_out_settings.dout_num=0;
  }
  
  if(freq_out_settings.dout_num>0 && freq_out_settings.dout_num<=OUTPUTS_CNT)
  {
    if(freq_output!=output_tim_it.output_freq || freq_out_settings.dout_num-1!=output_tim_it.output_idx)
    {
      OUTPUTS_TIM->CR1&=~TIM_CR1_CEN;//stop timer
      if(freq_output>0 && freq_output>=MIN_OUT_FREQ_HZ)
      {
        uint8_t div;
        
        if(freq_output<16)       div=8;
        else                     div=1;
        
        TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStructure;
        TIM_TimeBaseInitStructure.TIM_Prescaler=div*OUTPUTS_TIM_CLOCK_MHZ-1;
        TIM_TimeBaseInitStructure.TIM_CounterMode=TIM_CounterMode_Up;
        TIM_TimeBaseInitStructure.TIM_ClockDivision=TIM_CKD_DIV1;
        TIM_TimeBaseInitStructure.TIM_RepetitionCounter=0;
        
        if(freq_output>MAX_OUT_FREQ_HZ) freq_output=MAX_OUT_FREQ_HZ;
        TIM_TimeBaseInitStructure.TIM_Period=(uint16_t)roundf((1000000.0f/2.0f)/((float)div*(float)freq_output));
        
        TIM_DeInit(OUTPUTS_TIM);
        TIM_TimeBaseInit(OUTPUTS_TIM, &TIM_TimeBaseInitStructure);
        
        OUTPUTS_TIM->SR = ~TIM_IT_Update; //clear Update IT flag
        OUTPUTS_TIM->DIER |= TIM_IT_Update;//enable Update IT
        OUTPUTS_TIM->CR1 |= TIM_CR1_CEN;//start timer
        
        output_tim_it.output_freq=freq_output;
        output_tim_it.output_idx=freq_out_settings.dout_num-1;
      }
      else
      {
        output_tim_it.output_freq=0xffff;
      }
    }
  }
  else
  {
    OUTPUTS_TIM->CR1&=~TIM_CR1_CEN;//stop timer
    output_tim_it.output_idx=0xff;
    output_tim_it.output_freq=0xffff;
  }
  
  for(uint8_t i=0; i<OUTPUTS_CNT; i++)
  {
    if(freq_out_settings.dout_num!=i+1)
    {
      if(System.signal_state.digital_output[i]) {__OUTPUTx_ON(outputs[i].port, outputs[i].pin);}
      else                                      {__OUTPUTx_OFF(outputs[i].port, outputs[i].pin);}
    }
  }
}

//          (  outputs_handler) 
void outputs_state_force_apply(void)
{
  for(uint8_t i=0; i<OUTPUTS_CNT; i++)
  {
#if MAX_FREQ_OUTPUTS > 0   
    if(System.sensor_settings.freq_out[0].dout_num!=i+1)
#else
    if(true)
#endif
    {
      if(System.signal_state.digital_output[i]) {__OUTPUTx_ON(outputs[i].port, outputs[i].pin);}
      else                                      {__OUTPUTx_OFF(outputs[i].port, outputs[i].pin);}
    }
  }
}

#ifdef __cplusplus
extern "C" {
#endif 
  
#pragma optimize=speed
  void OUTPUTS_TIM_IRQHandler(void)
  {
    if(OUTPUTS_TIM->SR & TIM_IT_Update)
    {
      OUTPUTS_TIM->SR = ~TIM_IT_Update;//clear IT flag

      if(output_tim_it.output_idx<OUTPUTS_CNT)
      {
        if(__GET_OUTPUTx_OUT_STATE(outputs[output_tim_it.output_idx].port, outputs[output_tim_it.output_idx].pin))  {__OUTPUTx_OFF(outputs[output_tim_it.output_idx].port, outputs[output_tim_it.output_idx].pin);}
        else                                                                                                        {__OUTPUTx_ON(outputs[output_tim_it.output_idx].port, outputs[output_tim_it.output_idx].pin);}
      }
    }
    else
    {//   
      OUTPUTS_TIM->CR1&=~TIM_CR1_CEN;//stop timer
    }  
  }
  
#ifdef __cplusplus
}
#endif 
