/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __OUTPUTS_DRIVER_H
#define __OUTPUTS_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif 
  
  /* Includes ----------------------------------------------------------------*/
#include "stm32f2xx.h"
#include "system_config.h"
#include "System/system.h"
#include <stdint.h>
  
  
/* Private define ----------------------------------------------------------*/
#define OUTPUTS_CNT                             MAX_DIGITAL_OUTPUTS 
    
#define OUTPUT1_PIN                             GPIO_Pin_13
#define OUTPUT1_PORT                            GPIOE
#define OUTPUT1_RCC                             RCC_AHB1Periph_GPIOE
  
#define OUTPUT2_PIN                             GPIO_Pin_14
#define OUTPUT2_PORT                            GPIOE
#define OUTPUT2_RCC                             RCC_AHB1Periph_GPIOE
  
#define OUTPUT3_PIN                             GPIO_Pin_15
#define OUTPUT3_PORT                            GPIOE
#define OUTPUT3_RCC                             RCC_AHB1Periph_GPIOE
  
#define OUTPUT4_PIN                             GPIO_Pin_8
#define OUTPUT4_PORT                            GPIOB
#define OUTPUT4_RCC                             RCC_AHB1Periph_GPIOB
  
#define OUTPUT5_PIN                             GPIO_Pin_11
#define OUTPUT5_PORT                            GPIOD
#define OUTPUT5_RCC                             RCC_AHB1Periph_GPIOD
  
#define OUTPUT6_PIN                             GPIO_Pin_10
#define OUTPUT6_PORT                            GPIOD
#define OUTPUT6_RCC                             RCC_AHB1Periph_GPIOD
  
#define OUTPUT7_PIN                             GPIO_Pin_12
#define OUTPUT7_PORT                            GPIOD
#define OUTPUT7_RCC                             RCC_AHB1Periph_GPIOD
  
#define OUTPUT8_PIN                             GPIO_Pin_6
#define OUTPUT8_PORT                            GPIOC
#define OUTPUT8_RCC                             RCC_AHB1Periph_GPIOC
  
#define OUTPUT9_PIN                             GPIO_Pin_7
#define OUTPUT9_PORT                            GPIOC
#define OUTPUT9_RCC                             RCC_AHB1Periph_GPIOC
  
#define OUTPUT10_PIN                            GPIO_Pin_9
#define OUTPUT10_PORT                           GPIOB
#define OUTPUT10_RCC                            RCC_AHB1Periph_GPIOB

#define OUTPUTS_TIM_CLOCK_MHZ                   60
#define OUTPUTS_TIM                             TIM7
#define OUTPUTS_TIM_IRQn                        TIM7_IRQn
#define OUTPUTS_TIM_IRQHandler                  TIM7_IRQHandler
#define OUTPUTS_TIM_IRQ_PRIORITY                14//lowest+1 priority with use FreeRTOS API  

  
/* Private macro -------------------------------------------------------------*/   
#define __OUTPUTx_OFF(port, pin)                (port->BSRRH=pin)
#define __OUTPUTx_ON(port, pin)                 (port->BSRRL=pin)  
#define __GET_OUTPUTx_OUT_STATE(port, pin)      (!!(port->ODR & pin))
  
#define __OUTPUTS_TIM_CLOCK_CMD(ENABLE_OR_DISABLE) (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM7, ENABLE_OR_DISABLE))


/* Exported types -----------------------------------------------------------*/

  
  
/* Exported functions ----------------------------------------------------- */   
void outputs_init(void);
void outputs_deinit(void);
void outputs_handler(void);
void outputs_state_force_apply(void);

/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __OUTPUTS_DRIVER_H */