/**
******************************************************************************
* File Name          : rs485_driver.h
* Description        : RS485 driver   
*                       ST32F10x
*                      
******************************************************************************
*/
#ifndef __RS485_DRIVER_H
#define __RS485_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif 
  
/* Includes ----------------------------------------------------------------*/
#include <stdbool.h>
#include "stm32f2xx.h"
  
/* Exported types -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/

//-   RS485_RE/DE reciever/driver enable
#define RS485_RE_GPIO_Port	GPIOA
#define RS485_RE_Pin           	GPIO_Pin_8
#define RS485_DE_GPIO_Port	GPIOC
#define RS485_DE_Pin       	GPIO_Pin_9
//-  RS485_RE/DE
#define RS485_DE_Out()		{GPIO_SetBits(RS485_DE_GPIO_Port, RS485_DE_Pin);    GPIO_SetBits(RS485_RE_GPIO_Port, RS485_RE_Pin);}
#define RS485_DE_In()		{GPIO_ResetBits(RS485_DE_GPIO_Port, RS485_DE_Pin);  GPIO_ResetBits(RS485_RE_GPIO_Port, RS485_RE_Pin);}
#define RS485_DE_Z()		{GPIO_SetBits(RS485_RE_GPIO_Port, RS485_RE_Pin);    GPIO_ResetBits(RS485_DE_GPIO_Port, RS485_DE_Pin);}

//- RS485 USART
#define RS485_USART                  	USART1
#define RS485_USART_PORT         	GPIOA
#define RS485_USART_TX_PIN            	GPIO_Pin_9
#define RS485_USART_RX_PIN            	GPIO_Pin_10
#define __RS485_USART_PIN_REMAP()	{GPIO_PinAFConfig(RS485_USART_PORT, GPIO_PinSource9, GPIO_AF_USART1); GPIO_PinAFConfig(RS485_USART_PORT, GPIO_PinSource10, GPIO_AF_USART1);}

//- USART APB CLOCK
#define __RS485_USART_CLOCK_ENABLE()     (RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, ENABLE))
#define __RS485_USART_CLOCK_DISABLE()    (RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, DISABLE))

//- NVIC
#define RS485_USART_IRQn                      USART1_IRQn
#define RS485_USART_IRQHandler                USART1_IRQHandler   
#define RS485_USART_IRQn_PRIO                 12 //highest-1 priority with use FreeRTOS API

//- USART DEFAULT BAUDRATE PRESCALER 
#define RS485_USART_BAUD_DEFAULT  	((uint32_t)(115200))  

/* Private macro -------------------------------------------------------------*/   

/* Exported functions --------------------------------------------------------*/   
void RS485_Init(void);
void RS485_DeInit(void);
void RS485_SetParam(int baudrate, int timeout, char *param_string); 
uint16_t RS485_TxRx(uint8_t *sbuf, uint16_t slen, uint8_t *rbuf, uint16_t rlen);

/* External variables --------------------------------------------------------*/ 

extern void RS485_Grab(void);
extern bool RS485_Trying_Grab(void);
extern void RS485_Release(void);

#ifdef __cplusplus
}
#endif 

#endif /* ___RS485_DRIVER_H */
