/**
******************************************************************************
* File Name          : freertos_hooks.c
* Description        : 
*                        
*                      
*                             
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include "FreeRTOSConfig.h"
#include "FreeRTOS.h"
#include "task.h"
#include "stdint.h"

/* Extern variables ---------------------------------------------------------*/
extern void Soft_timers_handler(void);
/* Private functions ---------------------------------------------------------*/
#if ( configUSE_TICK_HOOK == 1 )
extern void usbd_cdc_SOF_timer_callback(void);
extern void can_timers_tick_callback(void);
#if defined(INTERNAL_NRF_PRESENT)
extern void nrf_timers_callback(void);
#endif //INTERNAL_NRF_PRESENT

void vApplicationTickHook(void)
{
  Soft_timers_handler();
  usbd_cdc_SOF_timer_callback();
  can_timers_tick_callback();
#if defined(INTERNAL_NRF_PRESENT)
  nrf_timers_callback();
#endif //INTERNAL_NRF_PRESENT
}
#else
#error
#endif /* configUSE_TICK_HOOK */

#if ( configUSE_IDLE_HOOK == 1 )
void vApplicationIdleHook(void)
{
  
}
#endif /* configUSE_IDLE_HOOK */

#if ( configCHECK_FOR_STACK_OVERFLOW > 0 )
#include "debug_port.h"
void vApplicationStackOverflowHook( TaskHandle_t xTask, char *pcTaskName )
{
  volatile char *name;
  volatile TaskHandle_t pxT;
  volatile uint32_t timeout_tx;
    
  name = pcTaskName;
  pxT  = xTask;
  timeout_tx=0;
  for(;;)
  {
    if(!timeout_tx)
    {
#if (!defined(USE_USB_DEBUG_PORT))
      printf("StackOverflow:\nTaskName: %s, Handle: %p\n", name, pxT);
#endif
      timeout_tx=15000000;
    }
    else timeout_tx--;
  }
}
#endif /* configCHECK_FOR_STACK_OVERFLOW */