/**
  ******************************************************************************
  * File Name          : MX25L6435E_config.h
  * Description        :        
  *                      Macronix MX25L6435E
  *     
  ******************************************************************************
*/

#ifndef    MX25L6435E_CONFIG_H
#define    MX25L6435E_CONFIG_H

//       FreeRTOS
#if (!defined(BOOTLOADER))  
#include "FreeRTOS.h"
#include "task.h"
#else
#include "time_utilities/time_utilities.h"
#include "stdio.h"
extern volatile uint32_t SysTickReg;
#endif

//      
#if (!defined(BOOTLOADER))  
#define MX25L64_DELAY_MS(X) vTaskDelay(X)  
#else
#define MX25L64_DELAY_MS(X) {uint32_t end_wait_time=SysTickReg-1+X; while(!timeAfter(SysTickReg, end_wait_time));}
#endif
  
#endif    /* end of MX25L6435E_CONFIG_H  */

