/**
******************************************************************************
* File Name          : serv_protocol_handler_conf.h
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __SERV_PROTOCOL_HANDLER_CONF_H
#define __SERV_PROTOCOL_HANDLER_CONF_H

#include "system_config.h"

#ifdef __cplusplus
extern "C" {
#endif 

extern void LOG(const char* string, ...);  

#define ODEBUG_L           0//off debug
#define LDEBUG_L           1//low level (err only)
#define MDEBUG_L           2//medium level
#define HDEBUG_L           3//high level

#define SERV_TIME_BACK_S                                2

//           
#define MIN_SESSION_LIVE_BEFORE_END_SESSION_S           10 
  //    ( )       
#define BBOX_MESS_COUNT_TH_FOR_END_SESSION              32        

//#define USE_EGTS_PROTOCOL_LIB
#define EGTS_DEBUG_LEVEL                                LDEBUG_L  
#define EGTS_BBOX_WAIT_ACK_TIMEOUT_MS                   20000
#define EGTS_MAX_SEND_ATT_MESS_IN_NORMAL_MODE           3
#define EGTS_MAX_SEND_ATT_MESS_IN_EMERG_MODE            6
//#define EGTS_USE_NAV_SYSTEM_SUBRECORD_PING  
#define EGTS_USE_EMTY_TRANSPORT_PACKET_PING

//#define USE_WIALON_PROTOCOL_LIB  
#define WIALON_DEBUG_LEVEL                              LDEBUG_L  
#define WIALON_BBOX_WAIT_ACK_TIMEOUT_MS                 20000
#define WIALON_MAX_SEND_ATT_MESS_IN_NORMAL_MODE         3
#define WIALON_MAX_SEND_ATT_MESS_IN_EMERG_MODE          6
#define WIALON_MAX_PHOTO_NAME_LEN                       8
#define WIALON_WAIT_PHOTO_ACK_TIMEOUT_MS                20000
#define WIALON_UPLOAD_BBOX_CHUNK_SIZE_THRESHOLD         (1024*2)

//#define USE_NDTP_PROTOCOL_LIB  
#define NDTP_DEBUG_LEVEL                                LDEBUG_L  
#define NDTP_BBOX_WAIT_ACK_TIMEOUT_MS                   20000
#define NDTP_MAX_SEND_ATT_MESS_IN_NORMAL_MODE           3
#define NDTP_MAX_SEND_ATT_MESS_IN_EMERG_MODE            6
#define NDTP_MVD_SERVER_FEATURE                         1 

#define USE_WIALON_BIN_PROTOCOL_LIB  
#define WIALON_BIN_DEBUG_LEVEL                          LDEBUG_L  
#define WIALON_BIN_BBOX_WAIT_ACK_TIMEOUT_MS             20000
#define WIALON_BIN_MAX_SEND_ATT_MESS_IN_NORMAL_MODE     3
#define WIALON_BIN_MAX_SEND_ATT_MESS_IN_EMERG_MODE      6 
#define USE_SERVER_NOTIFY_IN_WCOMBINE

#define USE_VEGA_PROTOCOL_LIB  
#define VEGA_DEBUG_LEVEL                                LDEBUG_L  
#define VEGA_BBOX_WAIT_ACK_TIMEOUT_MS                   20000
#define VEGA_MAX_SEND_ATT_MESS_IN_NORMAL_MODE           3
#define VEGA_MAX_SEND_ATT_MESS_IN_EMERG_MODE            6 
//#define VEGA_USE_NONCE_AUTH 
#define USE_SERVER_NOTIFY_IN_VEGA

//#define USE_NAVIS_PROTOCOL_LIB
#define NAVIS_DEBUG_LEVEL                               LDEBUG_L  
#define NAVIS_BBOX_WAIT_ACK_TIMEOUT_MS                  20000
#define NAVIS_MAX_SEND_ATT_MESS_IN_NORMAL_MODE          3
#define NAVIS_MAX_SEND_ATT_MESS_IN_EMERG_MODE           6 

#define CONN_DEBUG_LEVEL                                LDEBUG_L
  
#define WAIT_CONNECTING_TIMEOUT_MS                      8000  
#define WAIT_PING_ACK_TIMEOUT_MS                        10000  

#define MAX_NOTIFIES_COUNT_FOR_EACH_SERVER              16
#define MAX_NOTIFY_LEN                                  63
#define NOTIFY_LOCK_EN

#ifdef __cplusplus
}
#endif 

#endif /*__SERV_PROTOCOL_HANDLER_CONF_H*/
