#ifndef __SERVER_MAN_CONFIG_H
#define __SERVER_MAN_CONFIG_H

#include "system_config.h"

#define   USE_SIMCOM_MODEM_LIB
//#define DISABLE_CONFIGURATOR_TASK
//#define GSM_USB_FORWARDING

#if (defined(GSM_USB_FORWARDING) && !defined(DISABLE_CONFIGURATOR_TASK))  
#error GSM_USB_FORWARDING err
#endif 

#define MODEM_REBOOT_TIMEOUT_S                        (12*60*60)
#define MAX_CONN_FAIL_COUNT_FOR_SIM_CHANGE_OR_REBOOT  10
#define NO_RX_DATA_SIM_CHANGE_OR_REBOOT_TIMEOUT_S     (5*60) //0 -  
#define USE_APN_CHANGE_WITHOUT_REBOOT                 //   APN   

#define AGPS_UPADTE_TIMEOUT_S                         (60*60*24*1) //   AGPS

#define SERVER_TCP_CNT                                MAX_SERVERS_COUNT // tcp-   
#define SERVER_MAX_ADDR_LEN                           (GSM_MAX_SERVER_ADDR_LEN+1)

#define SERVER_TCP_1_CONN_ID                          (SERVER_TCP_CNT-4)
#define SERVER_TCP_2_CONN_ID                          (SERVER_TCP_CNT-3)
#define SERVER_TCP_3_CONN_ID                          (SERVER_TCP_CNT-2)
#define SERVER_TCP_4_CONN_ID                          (SERVER_TCP_CNT-1)
#define SERVER_LAST_TCP_CONN_ID                       (SERVER_TCP_4_CONN_ID)
#define SERVER_USB_CONN_ID                            4
#define SERVER_BT_CONN_ID                             5
#define SERVER_LAST_COMMON_CONN_ID                    (SERVER_BT_CONN_ID)

#define MAX_SEND_AT_ATTEMPT                           4 //  AT ,   K
#define WDT_AND_RSSI_TIMEOUT_MS                       5000
    
#define SIMCOM_STATUS_PIN                             GPIO_Pin_12
#define SIMCOM_STATUS_PORT                            GPIOC
#define __GET_SIMCOM_STATUS_PIN_STATE()               (GPIO_ReadInputDataBit(SIMCOM_STATUS_PORT, SIMCOM_STATUS_PIN))

#define MODEM_POWER_EN_PIN                            GPIO_Pin_0
#define MODEM_POWER_EN_PORT                           GPIOE
#define MODEM_POWER_EN_PIN_MODE                       GPIO_OType_PP
#define __MODEM_POWER_EN()                            (GPIO_SetBits(MODEM_POWER_EN_PORT, MODEM_POWER_EN_PIN))
#define __MODEM_POWER_DIS()                           (GPIO_ResetBits(MODEM_POWER_EN_PORT, MODEM_POWER_EN_PIN))

#define SIMCOM_PWRKEY_PIN                             GPIO_Pin_7
#define SIMCOM_PWRKEY_PORT                            GPIOB
#define SIMCOM_PWRKEY_PIN_MODE                        GPIO_OType_PP
#define __SIMCOM_PWRKEY_PIN_HI()                      (GPIO_SetBits(SIMCOM_PWRKEY_PORT, SIMCOM_PWRKEY_PIN))
#define __SIMCOM_PWRKEY_PIN_LOW()                     (GPIO_ResetBits(SIMCOM_PWRKEY_PORT, SIMCOM_PWRKEY_PIN))

#if MAX_SIM_COUNT > 1
#define MAIN_SIM_ID                                   (0)
#define USE_FAST_SIM_CHANGE                           //     
#define NO_NETWORK_TIME_MS_FOR_CHANGE_SIM             (5*60*1000) //    ,       
#define CHECK_MAINT_SIM_TIMEOUT_MS                    (0)//   ,     ,       (0 -  )
#define MODEM_SIM_SEL_PIN                             GPIO_Pin_4
#define MODEM_SIM_SEL_PORT                            GPIOE
#define MODEM_SIM_SEL_PIN_MODE                        GPIO_Mode_Out_PP
#define __MODEM_SEL_SIM_0()                           (GPIO_ResetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#define __MODEM_SEL_SIM_1()                           (GPIO_SetBits(MODEM_SIM_SEL_PORT, MODEM_SIM_SEL_PIN))
#endif //MAX_SIM_COUNT > 1

#define USE_PRECHARGE_MODEM_POWER
#if defined(USE_PRECHARGE_MODEM_POWER)
#define PRECHARGE_MODEM_POWER_PIN                     GPIO_Pin_1
#define PRECHARGE_MODEM_POWER_PORT                    GPIOE
#define PRECHARGE_MODEM_POWER_PIN_MODE                GPIO_OType_OD
#define __PRECHARGE_MODEM_POWER_ON()                  (GPIO_ResetBits(PRECHARGE_MODEM_POWER_PORT, PRECHARGE_MODEM_POWER_PIN))
#define __PRECHARGE_MODEM_POWER_OFF()                 (GPIO_SetBits(PRECHARGE_MODEM_POWER_PORT, PRECHARGE_MODEM_POWER_PIN))
#endif //USE_PRECHARGE_MODEM_POWER

//#define USE_PULSED_MODEM_POWER_ON
#if defined(USE_PULSED_MODEM_POWER_ON)
#define MODEM_PWR_TIM_CLOCK_MHZ                       (TARGET_CPU_FREQ_HZ/1000000)
#define MODEM_PWR_TIM                                 TIM4
#define MODEM_PWR_TIM_IRQn                            TIM4_IRQn
#define MODEM_PWR_TIM_IRQHandler                      TIM4_IRQHandler
#define MODEM_PWR_TIM_IRQ_PRIORITY                    12//highest-2 priority with use FreeRTOS API
#define __MODEM_PWR_TIM_CLOCK_CMD(DISABLE_OR_DISABLE) (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, DISABLE_OR_DISABLE))
#endif //USE_PULSED_MODEM_POWER_ON

#endif //__SERVER_MAN_CONFIG_H