#ifndef __SIGNAL_MAN_CONFIG_H
#define __SIGNAL_MAN_CONFIG_H

#include "system_config.h"

#define ADC_ONBOARD_PIN                 GPIO_Pin_0
#define ADC_ONBOARD_PORT                GPIOB
#define ADC_ONBOARD_CHANEL              ADC_Channel_8

#if defined(INTERNAL_AKB_PRESENT)
#define ADC_LIPO_PIN                    GPIO_Pin_1
#define ADC_LIPO_PORT                   GPIOB
#define ADC_LIPO_CHANEL                 ADC_Channel_9

#define LIPO_CHARGE_PIN                 GPIO_Pin_2         
#define LIPO_CHARGE_PORT                GPIOB
#define LIPO_CHARGE_RCC                 RCC_AHB1Periph_GPIOB

#if defined(INTERNAL_AKB_ON_OFF_CONTROL_PRESENT)
#define LIPO_ON_PIN                     GPIO_Pin_5         
#define LIPO_ON_PORT                    GPIOC
#define LIPO_ON_RCC                     RCC_AHB1Periph_GPIOC
#endif //INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
#endif //INTERNAL_AKB_PRESENT

#define VBAT_IN_DETECT_PIN              GPIO_Pin_0         
#define VBAT_IN_DETECT_PORT             GPIOA
#define VBAT_IN_DETECT_RCC              RCC_AHB1Periph_GPIOA

#if (defined(RS485_PRESENT) || defined(RS232_PRESENT))
#define RS232_RS485_PWR_PIN             GPIO_Pin_8         
#define RS232_RS485_PWR_PORT            GPIOC
#endif

#if defined(IGNITION_PRESENT)
#define IGN_PIN                         GPIO_Pin_2        
#define IGN_PORT                        GPIOE
#define IGN_RCC                         RCC_AHB1Periph_GPIOE
#endif //IGNITION_PRESENT

#if defined(TAMPERS_PRESENT)
#define TAMPER1_PIN                     GPIO_Pin_14        
#define TAMPER1_PORT                    GPIOB
#define TAMPER1_RCC                     RCC_AHB1Periph_GPIOB

#define TAMPER2_PIN                     GPIO_Pin_15        
#define TAMPER2_PORT                    GPIOB
#define TAMPER2_RCC                     RCC_AHB1Periph_GPIOB
#endif //TAMPERS_PRESENT

#if defined(INTERNAL_AKB_PRESENT)
// BQ24090DGQR   
#define __CHARGE_LIPO_DIS()             (GPIO_ResetBits(LIPO_CHARGE_PORT, LIPO_CHARGE_PIN))
#define __CHARGE_LIPO_EN()              (GPIO_SetBits(LIPO_CHARGE_PORT, LIPO_CHARGE_PIN))

#if defined(INTERNAL_AKB_ON_OFF_CONTROL_PRESENT)
#define __LIPO_ON_DIS()                 (GPIO_ResetBits(LIPO_ON_PORT, LIPO_ON_PIN))
#define __LIPO_ON_EN()                  (GPIO_SetBits(LIPO_ON_PORT, LIPO_ON_PIN))
#endif //INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
#endif //INTERNAL_AKB_PRESENT

#if (defined(RS485_PRESENT) || defined(RS232_PRESENT))
#define __RS232_RS485_PWR_DIS()         (GPIO_ResetBits(RS232_RS485_PWR_PORT, RS232_RS485_PWR_PIN))
#define __RS232_RS485_PWR_EN()          (GPIO_SetBits(RS232_RS485_PWR_PORT, RS232_RS485_PWR_PIN))
#endif

#if defined(IGNITION_PRESENT)
#define __GET_IGN_STATE()               (GPIO_ReadInputDataBit(IGN_PORT, IGN_PIN))
#endif //IGNITION_PRESENT

#if defined(TAMPERS_PRESENT)
#define __GET_TAMPER1_STATE()           (GPIO_ReadInputDataBit(TAMPER1_PORT, TAMPER1_PIN))
#define __GET_TAMPER2_STATE()           (GPIO_ReadInputDataBit(TAMPER2_PORT, TAMPER2_PIN))
#endif //TAMPERS_PRESENT

#define __GET_VBAT_IN_DETECT_STATE()    (GPIO_ReadInputDataBit(VBAT_IN_DETECT_PORT, VBAT_IN_DETECT_PIN))

#endif //__SIGNAL_MAN_CONFIG_H