/**
  ******************************************************************************
  * File Name          : System_config.h
  * Description        :  
  * 
  *                             
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef SYSTEM_CONFIG_H
#define SYSTEM_CONFIG_H

/* Includes  -----------------------------------------------------------------*/
#include "build_info/revision.h"
#include "System/vega_device_types.h"

/* Defines  ------------------------------------------------------------------*/
#if defined(IS_DEBUG_BUILD)
//#define IS_HW_VERSION_1
//#define IS_HW_VERSION_2

//#define IS_RIO_2017_BUILD
//#define IS_KAPTUR_2016_BUILD
//#define IS_GENESIS_2017_BUILD
//#define IS_AUDI_A3_2018_BUILD
//#define IS_AUDI_Q3_2018_BUILD
//#define IS_PORSCHE_MACAN_2018_BUILD
//#define IS_PORSCHE_911_2018_BUILD
//#define IS_SKODA_OCTAVIA_2018_BUILD
//#define IS_SKODA_RAPID_2018_BUILD
//#define IS_VW_POLO_2018_BUILD
//#define IS_VW_CADDY_2018_BUILD
//#define IS_BMW_520I_2018_BUILD
//#define IS_MB_E200_2018_BUILD
//#define IS_MB_C180_2015_BUILD
//#define IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD
//#define IS_FORD_TRANSIT_2017_BUILD
//#define IS_CITROEN_JUMPY_2018_BUILD
//#define IS_LADA_LARGUS_2017_BUILD
//#define IS_VOLVO_XC60_2018_BUILD
//#define IS_VOLVO_XC40_2018_BUILD
//#define IS_RANGE_ROVER_VELAR_2018_BUILD
//#define IS_VW_TRANSPORTER_2018_BUILD
//#define IS_HYUNDAI_CRETA_2019_BUILD
//#define IS_BMW_X1_2019_BUILD
//#define IS_FORD_MUSTANG_1965_BUILD
//#define IS_FORD_MUSTANG_1969_BUILD
#endif //IS_DEBUG_BUILD

#if defined(BOOTLOADER)
#define CUSTOM_CODE ""
#elif defined(IS_RIO_2017_BUILD)
#define CUSTOM_CODE " 'Rio'"
#elif defined(IS_KAPTUR_2016_BUILD)
#define CUSTOM_CODE " 'Kaptur'"
#elif defined(IS_GENESIS_2017_BUILD)
#define CUSTOM_CODE " 'Genesis'"
#elif defined(IS_AUDI_A3_2018_BUILD)
#define CUSTOM_CODE " 'A3'"
#elif defined(IS_AUDI_Q3_2018_BUILD)
#define CUSTOM_CODE " 'Q3'"
#elif defined(IS_PORSCHE_911_2018_BUILD)
#define CUSTOM_CODE " '911'"
#elif defined(IS_PORSCHE_MACAN_2018_BUILD)
#define CUSTOM_CODE " 'Macan'"
#elif defined(IS_SKODA_OCTAVIA_2018_BUILD)
#define CUSTOM_CODE " 'Octavia'"
#elif defined(IS_SKODA_RAPID_2018_BUILD)
#define CUSTOM_CODE " 'Rapid'"
#elif defined(IS_VW_POLO_2018_BUILD)
#define CUSTOM_CODE " 'Polo'"
#elif defined(IS_VW_CADDY_2018_BUILD)
#define CUSTOM_CODE " 'Caddy'"
#elif defined(IS_BMW_520I_2018_BUILD)
#define CUSTOM_CODE " '520i'"
#elif defined(IS_MB_E200_2018_BUILD)
#define CUSTOM_CODE " 'E200'"
#elif defined(IS_TOYOTA_RAV4_2019_BUILD)
#define CUSTOM_CODE " 'RAV4'"
#elif defined(IS_FORD_TRANSIT_2017_BUILD)
#define CUSTOM_CODE " 'Transit'"
#elif defined(IS_CITROEN_JUMPY_2018_BUILD)
#define CUSTOM_CODE " 'Jumpy'"
#elif defined(IS_RENAULT_DOKKER_2018_BUILD)
#define CUSTOM_CODE " 'Dokker'"
#elif defined(IS_LADA_LARGUS_2017_BUILD)
#define CUSTOM_CODE " 'Largus'"
#elif defined(IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD)
#define CUSTOM_CODE " 'Solaris Taxi'"
#elif defined(IS_SKODA_OCTAVIA_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Octavia Taxi'"
#elif defined(IS_VW_POLO_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Polo Taxi'"
#elif defined(IS_RENAULT_LOGAN_2018_TAXI_BUILD)
#define CUSTOM_CODE " 'Logan Taxi'"
#elif defined(IS_VOLVO_XC60_2018_BUILD)
#define CUSTOM_CODE " 'XC60'"
#elif defined(IS_VOLVO_XC40_2018_BUILD)
#define CUSTOM_CODE " 'XC40'"
#elif defined(IS_RANGE_ROVER_VELAR_2018_BUILD)
#define CUSTOM_CODE " 'Velar'"
#elif defined(IS_NISSAN_QASHQAI_2018_BUILD)
#define CUSTOM_CODE " 'Qashqai'"
#elif defined(IS_VW_TRANSPORTER_2018_BUILD)
#define CUSTOM_CODE " 'Transp'"
#elif defined(IS_HYUNDAI_CRETA_2019_BUILD)
#define CUSTOM_CODE " 'Creta'"
#elif defined(IS_BMW_X1_2019_BUILD)
#define CUSTOM_CODE " 'X1'"
#elif defined(IS_FORD_MUSTANG_1965_BUILD)
#define CUSTOM_CODE " 'Mustang65'"
#elif defined(IS_FORD_MUSTANG_1969_BUILD)
#define CUSTOM_CODE " 'Mustang69'"
#elif defined(IS_NISSAN_LEAF_2019_BUILD)
#define CUSTOM_CODE " 'Leaf'"
#elif defined(IS_PORSCHE_PANAMERA_2019_BUILD)
#define CUSTOM_CODE " 'Panamera'"
#elif defined(IS_HYUNDAI_SONATA_SD_2020_BUILD)
#define CUSTOM_CODE " 'Sonata SD'"
#else
#error unknown build
#endif //

#if !defined(BOOTLOADER)
#if ( (defined(IS_RIO_2017_BUILD)+defined(IS_KAPTUR_2016_BUILD)+defined(IS_GENESIS_2017_BUILD)+defined(IS_AUDI_A3_2018_BUILD)+defined(IS_AUDI_Q3_2018_BUILD)+\
       defined(IS_PORSCHE_911_2018_BUILD)+defined(IS_PORSCHE_MACAN_2018_BUILD)+defined(IS_SKODA_OCTAVIA_2018_BUILD)+defined(IS_SKODA_RAPID_2018_BUILD)+\
       defined(IS_VW_POLO_2018_BUILD)+ defined(IS_VW_CADDY_2018_BUILD)+defined(IS_BMW_520I_2018_BUILD)+defined(IS_MB_E200_2018_BUILD)+defined(IS_TOYOTA_RAV4_2019_BUILD)+\
       defined(IS_FORD_TRANSIT_2017_BUILD)+defined(IS_CITROEN_JUMPY_2018_BUILD)+defined(IS_RENAULT_DOKKER_2018_BUILD)+defined(IS_LADA_LARGUS_2017_BUILD)+\
       defined(IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD)+defined(IS_SKODA_OCTAVIA_2018_TAXI_BUILD)+defined(IS_VW_POLO_2018_TAXI_BUILD)+defined(IS_RENAULT_LOGAN_2018_TAXI_BUILD)+\
       defined(IS_VOLVO_XC60_2018_BUILD)+defined(IS_VOLVO_XC40_2018_BUILD)+defined(IS_RANGE_ROVER_VELAR_2018_BUILD)+defined(IS_NISSAN_QASHQAI_2018_BUILD)+defined(IS_VW_TRANSPORTER_2018_BUILD)+\
       defined(IS_HYUNDAI_CRETA_2019_BUILD)+defined(IS_BMW_X1_2019_BUILD)+defined(IS_FORD_MUSTANG_1965_BUILD)+defined(IS_FORD_MUSTANG_1969_BUILD)+defined(IS_NISSAN_LEAF_2019_BUILD)+\
       defined(IS_PORSCHE_PANAMERA_2019_BUILD)+defined(IS_HYUNDAI_SONATA_SD_2020_BUILD) )!=1)
#error define IS_RIO_2017_BUILD or IS_KAPTUR_2016_BUILD or IS_GENESIS_2017_BUILD or IS_AUDI_A3_2018_BUILD or IS_AUDI_Q3_2018_BUILD or IS_PORSCHE_911_2018_BUILD or IS_PORSCHE_MACAN_2018_BUILD \
or IS_SKODA_OCTAVIA_2018_BUILD orIS_SKODA_RAPID_2018_BUILD or IS_VW_POLO_2018_BUILD or IS_VW_CADDY_2018_BUILD or IS_BMW_520I_2018_BUILD or IS_MB_E200_2018_BUILD or IS_TOYOTA_RAV4_2019_BUILD or IS_FORD_TRANSIT_2017_BUILD \
or IS_CITROEN_JUMPY_2018_BUILD or IS_RENAULT_DOKKER_2018_BUILD or IS_LADA_LARGUS_2017_BUILD \
or IS_HYUNDAI_SOLARIS_2017_TAXI_BUILD or IS_SKODA_OCTAVIA_2018_TAXI_BUILD or IS_VW_POLO_2018_TAXI_BUILD or IS_RENAULT_LOGAN_2018_TAXI_BUILD \
or IS_VOLVO_XC60_2018_BUILD or IS_VOLVO_XC40_2018_BUILD or IS_RANGE_ROVER_VELAR_2018_BUILD or IS_NISSAN_QASHQAI_2018_BUILD or IS_VW_TRANSPORTER_2018_BUILD \
or IS_HYUNDAI_CRETA_2019_BUILD or IS_BMW_X1_2019_BUILD or IS_FORD_MUSTANG_1965_BUILD or IS_FORD_MUSTANG_1969_BUILD or IS_NISSAN_LEAF_2019_BUILD \
or IS_PORSCHE_PANAMERA_2019_BUILD or IS_HYUNDAI_SONATA_SD_2020_BUILD
#endif //
#endif //!defined(BOOTLOADER)
//// /////////////////////////////////////////////////////////////
#define APLICATION_VERSION_STRING               "VEGA MT-25K rc" RC_REVISION CUSTOM_CODE " " VCS_REVISION " " TOOLCHAIN_REVISION

////  /////////////////////////////////////////////////////////////
#define DEVICE_TYPE         DEVICE_TYPE_VEGA_MT_25K      //   (VEGA MT-25K)
#define DEV_TYPE_STRING     "VEGA MT-25K"

#define CURRENT_SETTINGS_VERSION 3                      //     

#define TARGET_CPU_FREQ_HZ               (60000000)
#define TARGET_CPU_FREQ_IN_SLEEP_HZ      (16000000)

// IWDG/////////////////////////////////////////////////////////////////////////
#define IWDG_ENABLE                       1
#if IWDG_ENABLE > 0   
#define IWDG_RELOAD_TIMEOUT_S           (12) 
#define IWDG_RCC_HZ                     (40000) 
#define IWDG_RELOAD_VAL                 ((IWDG_RELOAD_TIMEOUT_S*IWDG_RCC_HZ)/256)
#if IWDG_RELOAD_VAL > 0x0FFF
#error wrong IWDG_RELOAD_VAL
#endif 
#endif

#define UBXLOX_NMEA_RECEIVER_PRESENT
//#define UBLOX_GNSS_EXTERNAL_RTC_QUARTZ_PRESENT
#define GPS_MANAGER_MODEL_2_PRESENT
#define INTERNAL_ACC_MINIMAL_VOLTAGE  (3.35f)
#define IGNITION_PRESENT
#define GSENSOR_PRESENT
#define ALARM_BUTTON_PRESENT
//#define AUTORIZATION_PRESENT
#define MOTOHOURS_PRESENT
//#define CAMERA_PRESENT
//#define DUTS_PRESENT
#define INTERNAL_AKB_PRESENT
#define INTERNAL_AKB_ON_OFF_CONTROL_PRESENT
//#define INTERNAL_AKB_CHARGE_LEVEL_PRESENT
//#define EXT_ACC_DISCHARGE_PRESENT
//#define ONEWIRE_PRESENT
#define CANPRO_PRESENT
#define MFI_PRESENT
//#define AIN_PRESENT
//#define DIN_PRESENT
#define DIGITAL_OUTPUTS_PRESENT
#define TAMPERS_PRESENT
//#define VOICE_CALL_PRESENT
//#define INERTIAL_NAVIGATION_PRESENT
//#define FRIDGE_PRESENT
//#define ATOM_PRESENT
//#define LORA_SENSORS_PRESENT
//#define NRF_BEACONS_SCANNER_PRESENT
//#define TENZO_M_WEIGHER_PRESENT
#define PROD_TESTING_PRESENT
//#define EXT_GSENSOR_PRESENT
#define VEGA_CAN_PRESENT
#define VEGA_HARD_PASS_PRESENT
#define TRACK_POINT_GEN_FOR_VEGA_PROTOCOL_PRESENT
#define YANDEX_EXTENDED_SENSORS_PRESENT
//#define INTERNAL_NRF_PRESENT
#define ITF_TRANSPORT_PRESENT
//#define YANDEX_GUARD_MODE_PRESENT
//#define YANDEX_ANTITHEFT_PRESENT
#define BACKUP_SETTINGS_TO_MODEM_MEMORY_PRESENT
//#define EXTERNAL_BLE_BOARD_PRESENT
#define CAN_VEGA_FWD_PRESENT
#define YANDEX_OBD_PRESENT
#define YANDEX_GUARD_MODE_PRESENT
#define CHANGE_SIM_BY_NO_VALID_VEGA_PACKET_PRESENT

//#define RS232_PRESENT
#define RS485_PRESENT
#define BR_PRESENT

#if defined(RS232_PRESENT)

#endif //RS232_PRESENT

#if defined(RS485_PRESENT)

#endif //RS485_PRESENT

#if defined(FRIDGE_PRESENT)
#define MAX_FRIDGE_AIN         6
#define MAX_FRIDGE_DIN         4
#define MAX_FRIDGE_MAINTENANCE 5
#define MAX_FRIDGE_COMPARTMENT 3
#define MAX_FRIDGE_ALARM_CODES 16
#endif //FRIDGE_PRESENT

#if defined(LORA_SENSORS_PRESENT)
#define MAX_LORA_SENSORS_COUNT 10
#endif //LORA_SENSORS_PRESENT

#if defined(NRF_BEACONS_SCANNER_PRESENT)
#define MAX_NRF_BEACONS_COUNT 50           //     
#define MAX_NRF_AUTORIZED_BEACONS_COUNT 160 //   32
#endif //NRF_BEACONS_SCANNER_PRESENT

//    
#if defined(BR_PRESENT)
#define MAX_EXT_MF_INPUTS       15                  //    
#define MAX_EXT_ANALOG_INPUTS   MAX_EXT_MF_INPUTS   //    
#define MAX_EXT_DIGITAL_INPUTS  MAX_EXT_MF_INPUTS   //    
#define MAX_EXT_PULSE_INPUTS    MAX_EXT_MF_INPUTS   //    
#define MAX_EXT_FREQ_INPUTS     MAX_EXT_MF_INPUTS   //    
#define MAX_EXT_DIGITAL_OUTPUTS 15                  //    
#endif //BR_PRESENT

#define MAX_MF_INPUTS       5                   //    
#define MAX_ANALOG_INPUTS   MAX_MF_INPUTS       //    
#define MAX_ANALOG_OUTPUTS  0                   //    
#define MAX_DIGITAL_INPUTS  MAX_MF_INPUTS       //    
#define MAX_DIGITAL_OUTPUTS 10                  //    
#define MAX_PULSE_INPUTS    MAX_MF_INPUTS       //    
#define MAX_FREQ_INPUTS     MAX_MF_INPUTS       //    
#define MAX_FREQ_OUTPUTS    1                   //    
#define MAX_DUTS            4                   //     
#define MAX_DALLAS_TEMP_SENSORS   0             //       1-wire
#define MAX_TAMPERS         2                   //    
#define MAX_GEOZONES        50                  //     
#define MAX_SERVERS_COUNT   4                   //       
#define MAX_SIM_COUNT       2                   //  SIM-   
#define PROTOCOL_VERSION    1                   //   
#define MAX_AUTORIZED_PHONES 10                 //    
#define MAX_AUTORIZED_KEYS  0                   //    
#define MAX_SCENARIES       25                  //     
#define MODEM_VER_SIZE      36                  //       
#define GSM_MAX_SERVER_ADDR_LEN  32             //     ,  addr:port\0
#define GPS_MAX_SAT_VISIBLE 20                  //      GLONASS  GPS  
#define GPS_MAX_SAT_USED    24                  //    
#define GPS_RECV_VER_SIZE   50                  //       
#define MAX_SENSOR_COUNT    (420)               //    
#define MAX_CAMERAS         0                   //    
#define MAX_CAN_INTERFACES  2                   //  CAN 

#endif /* SYSTEM_SETTINGS_H */

