/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __JQ6500_H
#define __JQ6500_H

#ifdef __cplusplus
//extern "C" {
#endif 

#define JQ6500_BAUDRATE                                         9600

//Send commands
#define NEXT_JQ6500                                             0x01
#define PRE_JQ6500                                              0x02
#define ASSIGNED_SONG_JQ6500                                    0x03
#define VOLUME_P_JQ6500                                         0x04
#define VOLUME_M_JQ6500                                         0x05
#define ASSIGNED_VOLUME_JQ6500                                  0x06
#define ASSIGNED_EQ_JQ6500                                      0x07
#define ASSIGNED_DEVICE_JQ6500                                  0x09
#define ENTER_SLEEP_MODE_JQ6500                                 0x0A
#define CHIP_RESET_JQ6500                                       0x0C
#define PLAY_JQ6500                                             0x0D
#define PAUSE_JQ6500                                            0x0E
#define FOLDERS_SWITCH_JQ6500                                   0x0F
#define PRESERVE_JQ6500                                         0x10
#define LOOP_JQ6500                                             0x11
#define SPECIFIED_FOLDER_FILE_PLAYBCAK_JQ6500                   0x12

//Parameter Query
#define RETURN_ERROR_REQUEST_RESEND_JQ6500                      0x40
#define CHECK_THE_CURRENT_STATUS_JQ6500                         0x42
#define INQUIRE_THE_CURRENT_VOLUME_JQ6500                       0x43
#define INQUIRE_THE_CURRENT_EQ_JQ6500                           0x44
#define INQUIRE_THE_CURRENT_PLAY_MODE_JQ6500                    0x45
#define INQUIRE_THE_CURRENT_SOFTWARE_VERSION_JQ6500             0x46
#define CHECK_THE_TOTAL_NUMBER_OF_FILES_OF_TF_CARD_JQ6500       0x47
#define INQUIRE_THE_TOTAL_NUMBER_OF_UDISK_FILES_JQ6500          0x48
#define INQUIRE_THE_TOTAL_NUMBER_OF_FLASH_FILES_JQ6500          0x49
#define INQUIRE_THE_CURRENT_TRACK_OF_TF_CARD_JQ6500             0x4B
#define INQUIRE_THE_CURRENT_TRACK_OF_UDISK_JQ6500               0x4C
#define INQUIRE_THE_CURRENT_TRACK_OF_FLASH_JQ6500               0x4D
#define INQUIRE_THE_CURRENT_PLAY_TIME_JQ6500                    0x50
#define INQUIRE_THE_TOTAL_PLAY_TIME_OF_THE_CURRENT_TRACK_JQ6500 0x51
#define INQUIRE_THE_NAME_OF_THE_PLAYING_SONG_JQ6500             0x52
#define INQUIRE_THE_TOTAL_NUMBER_OF_THE_CURRENT_FOLDERS_JQ6500  0x53

#define LOOP_ALL_JQ6500                                         0
#define LOOP_FOLDER_JQ6500                                      1
#define LOOP_ONE_JQ6500                                         2
#define LOOP_RAM_JQ6500                                         3
#define LOOP_ONE_STOP_JQ6500                                    4
#define LOOP_NONE_JQ6500                                        4 

#define STATUS_STOPPED_JQ6500                                   0
#define STATUS_PLAYING_JQ6500                                   1
#define STATUS_PAUSED_JQ6500                                    2

inline uint8_t make_jq6500_cmd(const uint8_t cmd, const void* const arg, const uint8_t arg_len, uint8_t* const buff, const uint8_t buff_size)
{
  if(buff_size<4+arg_len) return 0;
  
  uint8_t offset=0;
  
  buff[offset++]=0x7E;
  buff[offset++]=2+arg_len;
  buff[offset++]=cmd;
  memcpy(&buff[offset], arg, arg_len);
  offset+=arg_len;
  buff[offset++]=0xEF;
  
  return offset;
}

#ifdef __cplusplus
//}
#endif 

#endif /* __JQ6500_H */