/**
******************************************************************************
* File Name          : add_tick_tim.c
* Description        : 
*                      
*                      
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include "add_tick_timer.h"
#include "system_config.h"
//#include "leds_driver.h"

/* Defines -------------------------------------------------------------------*/
#define TICK_TIM_FCPU_MHZ                    (TARGET_CPU_FREQ_HZ/1000000)
#define TICK_TIM                             TIM6
#define TICK_TIM_IRQn                        TIM6_DAC_IRQn
#define TICK_TIM_IRQHandler                  TIM6_DAC_IRQHandler
#define TICK_TIM_IRQ_PRIORITY                15//lowest priority
#define __TICK_TIM_CLOCK_CMD(EN_OR_DIS)      (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM6, EN_OR_DIS))

/* Global variables-----------------------------------------------------------*/

/* Private constants ---------------------------------------------------------*/

/* Private variables ---------------------------------------------------------*/

/* Public functions ----------------------------------------------------------*/

void AddTickTimerStart(void)
{
  TICK_TIM->SR = ~TIM_IT_Update; //clear Update IT flag
  TICK_TIM->DIER |= TIM_IT_Update;//enable Update IT
  TICK_TIM->CR1 |= TIM_CR1_CEN;//start timer
}

void AddTickTimerStop(void)
{
  TICK_TIM->DIER &= ~TIM_IT_Update; //disable Update IT
  TICK_TIM->DIER &= ~TIM_IT_CC1; //disable CC1 IT
  TICK_TIM->CR1&=~TIM_CR1_CEN;//stop timer
}

void AddTickTimerInit(void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStructure;
  
  AddTickTimerStop();
  
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = TICK_TIM_IRQ_PRIORITY;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;//Not used as 4 bits are used for the pre-emption priority
  NVIC_InitStructure.NVIC_IRQChannel = TICK_TIM_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init(&NVIC_InitStructure);
  
  __TICK_TIM_CLOCK_CMD(ENABLE);
  
  TIM_TimeBaseStructInit(&TIM_TimeBaseInitStructure);
  TIM_TimeBaseInitStructure.TIM_Prescaler=TICK_TIM_FCPU_MHZ*10-1;
  TIM_TimeBaseInitStructure.TIM_CounterMode=TIM_CounterMode_Up;
  TIM_TimeBaseInitStructure.TIM_ClockDivision=TIM_CKD_DIV1;
  TIM_TimeBaseInitStructure.TIM_RepetitionCounter=0;
  TIM_TimeBaseInitStructure.TIM_Period=1000/10;
  
  TIM_DeInit(TICK_TIM);
  TIM_TimeBaseInit(TICK_TIM, &TIM_TimeBaseInitStructure);
  
  AddTickTimerStart();
}

#ifdef __cplusplus
extern "C" {
#endif

#pragma optimize=speed
void TICK_TIM_IRQHandler(void)
{
  if(TICK_TIM->SR & TIM_IT_Update)
  {
    TICK_TIM->SR = ~TIM_IT_Update;//clear IT flag
    
    extern void can_timers_tick_callback(void);
    can_timers_tick_callback();
    
#if defined(INTERNAL_NRF_PRESENT)
    extern void nrf_timers_callback(void);
    nrf_timers_callback();
#endif //INTERNAL_NRF_PRESENT
  }
}
#ifdef __cplusplus
}
#endif