/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __BLE_GPIO_DRIVER_H
#define __BLE_GPIO_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif 

  /* Includes ----------------------------------------------------------------*/
#include "stm32f4xx.h"
#include <stdint.h>
#include <stdbool.h>

/* Private define ----------------------------------------------------------*/
#define BLE_POWER_GPIO           GPIOC
#define BLE_POWER_PIN            GPIO_Pin_9
#define BLE_POWER_PIN_MODE       GPIO_OType_OD
  
/* Exported types -----------------------------------------------------------*/

/* Exported functions ----------------------------------------------------- */   
void ble_gpio_init(void);
void ble_gpio_deinit(void);

inline void ble_power(bool is_on)
{
  if(is_on) BLE_POWER_GPIO->BSRRH = BLE_POWER_PIN;
  else      BLE_POWER_GPIO->BSRRL = BLE_POWER_PIN;
}

/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __BLE_GPIO_DRIVER_H */