/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __EXTERNAL_UART_H
#define __EXTERNAL_UART_H

#ifdef __cplusplus
extern "C" {
#endif 
  
  /* Includes ----------------------------------------------------------------*/
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"
#include "cbuff/cbuff.h"
#include <string.h>
#include <math.h>
#include <stdbool.h>

/* Private define ----------------------------------------------------------*/
#define EXTERNAL_UART_CTX_COUNT                1
#define EXTERNAL_UART_IRQn_PRIO                12 //highest-1 priority with use FreeRTOS API

#define EXTERNAL_UART_CTX1                     (0)
#define EXTERNAL_UART_RX_MEM_SIZE              (8)

#define EXTERNAL_UART1                          UART4
#define EXTERNAL_UART1_IRQn                     UART4_IRQn
#define EXTERNAL_UART1_IRQHandler               UART4_IRQHandler

#define EXTERNAL_UART1_TX_PIN                   GPIO_Pin_1
#define EXTERNAL_UART1_TX_PORT                  GPIOD
#define EXTERNAL_UART1_TX_PIN_MODE              GPIO_Mode_AF_PP

#define EXTERNAL_UART1_RX_PIN                   GPIO_Pin_0
#define EXTERNAL_UART1_RX_PORT                  GPIOD
#define EXTERNAL_UART1_TX_PIN_PUPD              GPIO_PuPd_NOPULL

#define EXTERNAL_UART1_RX_EXTI_LINE             0
#define EXTERNAL_UART1_RX_PORT_SOURCE           0
#define EXTERNAL_UART1_RX_PIN_SOURCE            0
#define EXTERNAL_UART1_RX_EXTI_IRQn             0
#define EXTERNAL_UART1_RX_EXTI_IRQHandler       NULL

/* Private macro -------------------------------------------------------------*/   
#define __EXTERNAL_UART1_REMAP()                {GPIO_PinAFConfig(EXTERNAL_UART1_TX_PORT, GPIO_PinSource1, GPIO_AF11_UART4); GPIO_PinAFConfig(EXTERNAL_UART1_RX_PORT, GPIO_PinSource0, GPIO_AF11_UART4);}    
#define __EXTERNAL_UART1_AFIO_CLOCK_ENABLE()    //
#define __EXTERNAL_UART1_AFIO_CLOCK_DISABLE()   //
#define __EXTERNAL_UART1_CLOCK_ENABLE()         (RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART4, ENABLE))
#define __EXTERNAL_UART1_CLOCK_DISABLE()        (RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART4, DISABLE))
  
#if (EXTERNAL_UART_CTX_COUNT>1)
#define EXTERNAL_UART_CTX2                      (EXTERNAL_UART_CTX1+1)
#define EXTERNAL_UART2_RX_MEM_SIZE              (32)

#define EXTERNAL_UART2                           UART8
#define EXTERNAL_UART2_IRQn                      UART8_IRQn
#define EXTERNAL_UART2_IRQHandler                UART8_IRQHandler

#define EXTERNAL_UART2_TX_PIN                    GPIO_Pin_1
#define EXTERNAL_UART2_TX_PORT                   GPIOE
#define EXTERNAL_UART2_TX_PIN_MODE               GPIO_Mode_AF_PP

#define EXTERNAL_UART2_RX_PIN                    GPIO_Pin_0
#define EXTERNAL_UART2_RX_PORT                   GPIOE
#define EXTERNAL_UART2_TX_PIN_PUPD               GPIO_PuPd_NOPULL
  
#define EXTERNAL_UART2_RX_EXTI_LINE              0
#define EXTERNAL_UART2_RX_PORT_SOURCE            0
#define EXTERNAL_UART2_RX_PIN_SOURCE             0
#define EXTERNAL_UART2_RX_EXTI_IRQn              0
#define EXTERNAL_UART2_RX_EXTI_IRQHandler        NULL

/* Private macro -------------------------------------------------------------*/   
#define __EXTERNAL_UART2_REMAP()                 {GPIO_PinAFConfig(EXTERNAL_UART2_TX_PORT, GPIO_PinSource1, GPIO_AF_UART8); GPIO_PinAFConfig(EXTERNAL_UART2_RX_PORT, GPIO_PinSource0, GPIO_AF_UART8);}    
#define __EXTERNAL_UART2_AFIO_CLOCK_ENABLE()     //
#define __EXTERNAL_UART2_AFIO_CLOCK_DISABLE()    //
#define __EXTERNAL_UART2_CLOCK_ENABLE()          (RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART8, ENABLE))
#define __EXTERNAL_UART2_CLOCK_DISABLE()         (RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART8, DISABLE))
#endif //(EXTERNAL_UART_CTX_COUNT>1)

/* Exported types -----------------------------------------------------------*/
typedef struct
{
  void* rx_mem;
  uint16_t rx_mem_size;
  
  uint8_t rx_full_flag;
  uint8_t rx_ore_flag;
  cbuff_t rx_cbuff;
  uint16_t wait_rx_len;
  bool (*rx_it_callback)(cbuff_t* const);
  SemaphoreHandle_t rx_sem;
  
  uint8_t is_init;
}uart_driver_t;

/* Exported functions ----------------------------------------------------- */   
void external_uart_init(const uint8_t ctx, const uint32_t baud_rate, void* const rx_heap, const uint16_t rx_heap_size, bool (*rx_it_callback)(cbuff_t* const));
void external_uart_deinit(const uint8_t ctx);
void external_uart_write(const uint8_t ctx, const void* src, const uint16_t len);
int16_t external_uart_read(const uint8_t ctx, void* const dst, const uint16_t len);
uint8_t external_uart_wait_sync(const uint8_t ctx, const uint32_t time_mS);
int16_t external_uart_set_wait_sync_len(const uint8_t ctx, const uint16_t len);
void external_uart_flush_rx(const uint8_t ctx);
int16_t external_uart_txrx(const uint8_t ctx, const void* const tx, const uint16_t tx_size, void* const rx, const uint16_t rx_size, const uint32_t timeout, const bool is_rx_flush);
//inline bool external_uart_is_rx_exti_present(void) {return IS_GET_EXTI_LINE(EXTERNAL_UART_RX_EXTI_LINE);}

/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __EXTERNAL_UART_H */