/**
******************************************************************************
* File Name          : leds_driver.h
* Description        : Leds
*                      
*                      
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LEDS_H
#define __LEDS_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"

/* Defines -------------------------------------------------------------------*/  
//-       
#define LedR_Port       GPIOD
#define LedR_Pin        GPIO_Pin_15     // RED
#define LedR_Rcc        RCC_AHB1Periph_GPIOD
   
#define LedG_Port       GPIOD   
#define LedG_Pin        GPIO_Pin_13     // GREEN
   
#define LedB_Port       GPIOD   
#define LedB_Pin        GPIO_Pin_14     // BLUE
   
#define LedCAN_Port     GPIOG   
#define LedCAN_Pin      GPIO_Pin_6      // CAN

#define DA_LedCAN_On()	        {LedCAN_Port->BSRRL = LedCAN_Pin;}
#define DA_LedCAN_Off()	        {LedCAN_Port->BSRRH = LedCAN_Pin;}
#define DA_LedCAN_Toggle()	{LedCAN_Port->ODR ^= LedCAN_Pin;}
   
#define DA_LedR_On()	        {LedR_Port->BSRRL = LedR_Pin;}	
#define DA_LedR_Off()	        {LedR_Port->BSRRH = LedR_Pin;}
#define DA_LedR_Toggle()	{LedR_Port->ODR ^= LedR_Pin;}

#define DA_LedG_On()	        {LedG_Port->BSRRL = LedG_Pin;}	
#define DA_LedG_Off()	        {LedG_Port->BSRRH = LedG_Pin;}
#define DA_LedG_Toggle()	{LedG_Port->ODR ^= LedG_Pin;}

#define DA_LedB_On()	        {LedB_Port->BSRRL = LedB_Pin;}	
#define DA_LedB_Off()	        {LedB_Port->BSRRH = LedB_Pin;}
#define DA_LedB_Toggle()	{LedB_Port->ODR ^= LedB_Pin;}
   
void LedR_On(void);
void LedR_Off(void);
void LedR_Toggle(void);
void LedG_On(void);
void LedG_Off(void);
void LedG_Toggle(void);
void LedB_On(void);
void LedB_Off(void);
void LedB_Toggle(void);
void LedCAN_On(void);
void LedCAN_Off(void);
void LedCAN_Toggle(void);
void Leds_SetBrightness(uint8_t brightness);

#define LEDS_UPDATE_RATE_HZ             90
#define LEDS_TIMx_RCC_CLOCK             (TARGET_CPU_FREQ_HZ)
#define LEDS_TIMx_RCC_CLOCK_IN_SLEEP    (TARGET_CPU_FREQ_IN_SLEEP_HZ)
#define LEDS_TIMx                       TIM4
#define LEDS_TIMx_IRQn                  TIM4_IRQn
#define LEDS_TIMx_IRQHandler            TIM4_IRQHandler
#define __LEDS_TIMx_CLOCK_ENABLE()      (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, ENABLE))
#define __LEDS_TIMx_CLOCK_DISABLE()     (RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, DISABLE))
#define LEDS_TIMx_IRQn_PRIO             15

/* Public functions ----------------------------------------------------------*/
void Leds_Init(void);
void Leds_DeInit(void);  

#ifdef __cplusplus
}
#endif

#endif // __LEDS_H
