/**
******************************************************************************
* File Name          : 
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __LIN_UART_H
#define __LIN_UART_H

#ifdef __cplusplus
extern "C" {
#endif 
  
/* Includes ----------------------------------------------------------------*/
#include <stdbool.h>
#include <string.h>
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h" 
#include "cbuff/cbuff.h"  
  
/* Private define ----------------------------------------------------------*/
#define LIN_UART                           USART6
#define LIN_UART_IRQn                      USART6_IRQn
#define LIN_UART_IRQHandler                USART6_IRQHandler   
#define LIN_UART_IRQn_PRIO                 12 //highest-1 priority with use FreeRTOS API
#define LIN_DEF_UART_BAUD_RATE             ((uint32_t)(9600))

#define LIN_UART_TX_PIN                    GPIO_Pin_6
#define LIN_UART_TX_PORT                   GPIOC

#define LIN_UART_RX_PIN                    GPIO_Pin_7
#define LIN_UART_RX_PORT                   GPIOC

#define __LIN_UART_REMAP()                 {GPIO_PinAFConfig(LIN_UART_TX_PORT, GPIO_PinSource6, GPIO_AF_USART6); GPIO_PinAFConfig(LIN_UART_RX_PORT, GPIO_PinSource7, GPIO_AF_USART6);}    

#define __LIN_UART_CLOCK_ENABLE()          (RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART6, ENABLE))
#define __LIN_UART_CLOCK_DISABLE()         (RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART6, DISABLE))

#define __LIN_AFIO_CLOCK_ENABLE()          //
#define __LIN_AFIO_CLOCK_DISABLE()         //
  
  
/* Exported types -----------------------------------------------------------*/
typedef struct
{
  uint8_t rx_ore_flag;
  
  uint8_t tx_buff[11];
  uint8_t tx_pos;
  uint8_t tx_len;
  
  uint8_t rx_buff[11];
  uint8_t rx_pos;
  
  bool is_init;
}lin_uart_driver_t;

/* Exported functions ----------------------------------------------------- */   
void lin_uart_init(uint32_t baud_rate);
void lin_uart_deinit(void);

void lin_uart_send_break(void);
void lin_uart_write(const uint8_t *src, uint8_t len);
void lin_uart_write_2(const uint8_t *src, uint8_t len);
bool is_lin_uart_write_busy(void);

void lin_rx_callback(const uint8_t* buff, uint8_t len);

uint8_t lin_get_pid_from_ident(uint8_t ident);
uint8_t lin_calc_checksum(uint8_t ident, uint8_t is_enhanced, const uint8_t* data, uint8_t dlen);
uint8_t lin_check_parity(uint8_t pid);

/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __LIN_UART_H */