/**
******************************************************************************
* File Name          : lis_spi_driver.c
* Description        : LIS3DH (or compatible) hw level spi driver
*
*
******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"
#include "lis_spi_driver.h"
#include "nvic_exti_driver.h"

/* Defines -------------------------------------------------------------------*/
/* Global variables-----------------------------------------------------------*/
/* Public functions ----------------------------------------------------------*/
//- Init
void LIS_SPI_Init(void)
{
 GPIO_InitTypeDef GPIO_InitStructure;

   //  SPI
  __LIS_SPI_CLOCK_ENABLE();
  
  // 
  __LIS_SPI_REMAP_ENABLE();
 
 /* Configure LIS_CS pin as push-pull */
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  
  GPIO_InitStructure.GPIO_Pin = LIS_CS_Pin;
  GPIO_Init(LIS_CS_GPIO_Port, &GPIO_InitStructure);
  LIS_CS_Up();

  /* Configure LIS_SPI SCK MOSI pins */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
  GPIO_InitStructure.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_SCK_PIN;
  GPIO_Init(LIS_SPI_SCK_PORT, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_MOSI_PIN;
  GPIO_Init(LIS_SPI_MOSI_PORT, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_MISO_PIN;
  GPIO_Init(LIS_SPI_MISO_PORT, &GPIO_InitStructure);
  
  //  SPI
  SPI_InitTypeDef SPI_InitStruct;
  SPI_StructInit(&SPI_InitStruct);       //   (..  )
  SPI_InitStruct.SPI_BaudRatePrescaler = LIS_SPI_BAUDRATE_PRESCALER;   // . .   SCLK = F_pclk / . 
  SPI_InitStruct.SPI_CPHA = SPI_CPHA_1Edge;                          //     (  )
  SPI_InitStruct.SPI_CPOL = SPI_CPOL_Low;                            //     (  )
  SPI_InitStruct.SPI_DataSize = SPI_DataSize_8b;                     //   (8   16 )
  SPI_InitStruct.SPI_Direction = SPI_Direction_2Lines_FullDuplex;    //     (MISO  MOSI)
  SPI_InitStruct.SPI_FirstBit = SPI_FirstBit_MSB;                    //     (MSB  LSB)
  SPI_InitStruct.SPI_Mode = SPI_Mode_Master;                         //  
  SPI_InitStruct.SPI_NSS = SPI_NSS_Soft;
  //  SPI
  SPI_Init(LIS_SPI, &SPI_InitStruct);
  SPI_CalculateCRC(LIS_SPI, DISABLE);
  //  SPI
  SPI_Cmd(LIS_SPI, ENABLE);

 //   
//  HAL_NVIC_SetPriority(SPI2_IRQn, 0, 0);
//  HAL_NVIC_EnableIRQ(SPI2_IRQn);
}


//-  (snd)    (rcv);     RXNE
void SPI_TxRxPoll( SPI_TypeDef* SPIx, uint8_t *sndbuf, uint16_t sndlen, uint8_t *rcvbuf, uint16_t rcvlen )
{
  while(SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_BSY)==SET) {} //   
  uint16_t i=sndlen;
 //  
  for(;i>0;i--) {
    SPI_I2S_SendData(SPIx, *sndbuf++);
    while(SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_RXNE)!=SET) {} //    
    SPI_I2S_ReceiveData(SPIx);       //   -  RXNE
  }
 //  
  for(i=rcvlen;i>0;i--) {
    SPI_I2S_SendData(SPIx, 0);
    while(SPI_I2S_GetFlagStatus(SPIx, SPI_I2S_FLAG_RXNE)!=SET) {} //    
    *rcvbuf++=SPI_I2S_ReceiveData(SPIx);       //  -  RXNE
  }
}

//-  (snd)    (rcv);  .
void SPI_TxRx( SPI_TypeDef* SPIx, uint8_t *sndbuf, uint16_t sndlen, uint8_t *rcvbuf, uint16_t rcvlen )
{ SPI_TxRxPoll( SPIx, sndbuf, sndlen, rcvbuf, rcvlen ); }


//- Deinit
void LIS_SPI_DeInit(void)
{
  //  SPI
  SPI_Cmd(LIS_SPI, DISABLE);
  SPI_I2S_DeInit(LIS_SPI); //     SPI_I2S
    
  /* Configure pins as analog */
  GPIO_InitTypeDef GPIO_InitStructure;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_SCK_PIN;
  GPIO_Init(LIS_SPI_SCK_PORT, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_MOSI_PIN;
  GPIO_Init(LIS_SPI_MOSI_PORT, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LIS_SPI_MISO_PIN;
  GPIO_Init(LIS_SPI_MISO_PORT, &GPIO_InitStructure);
  
  GPIO_InitStructure.GPIO_Pin = LIS_CS_Pin;
  GPIO_Init(LIS_CS_GPIO_Port, &GPIO_InitStructure);
  
  //  SPI
  __LIS_SPI_CLOCK_DISABLE();
}

