/**
******************************************************************************
* File Name          : lis_spi_driver.h
* Description        : LIS3DH (or compatible) hw level spi driver
*
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LIS_SPI_DRIVER_H
#define __LIS_SPI_DRIVER_H
#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx.h"
#include "system_config.h"
   
/* Defines -------------------------------------------------------------------*/

//-   LIS_CS chip select spi
#define LIS_CS_GPIO_Port                GPIOB
#define LIS_CS_Pin                      GPIO_Pin_12

//-  LIS_CS
#define LIS_CS_Up()	                GPIO_SetBits(LIS_CS_GPIO_Port, LIS_CS_Pin)
#define LIS_CS_Dwn()	                GPIO_ResetBits(LIS_CS_GPIO_Port, LIS_CS_Pin)

//- SPI
#define LIS_SPI                         SPI2
#define LIS_SPI_SCK_PORT                GPIOB
#define LIS_SPI_SCK_PIN                 GPIO_Pin_13
#define LIS_SPI_MOSI_PORT               GPIOB
#define LIS_SPI_MOSI_PIN                GPIO_Pin_15
#define LIS_SPI_MISO_PORT               GPIOB
#define LIS_SPI_MISO_PIN                GPIO_Pin_14

#define __LIS_SPI_REMAP_ENABLE()        {GPIO_PinAFConfig(LIS_SPI_SCK_PORT, GPIO_PinSource13, GPIO_AF_SPI2);  GPIO_PinAFConfig(LIS_SPI_MOSI_PORT, GPIO_PinSource15, GPIO_AF_SPI2);  GPIO_PinAFConfig(LIS_SPI_MISO_PORT, GPIO_PinSource14, GPIO_AF_SPI2);}

#define __LIS_SPI_CLOCK_ENABLE()        (RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI2, ENABLE))
#define __LIS_SPI_CLOCK_DISABLE()       (RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI2, DISABLE))

#if (TARGET_CPU_FREQ_HZ == 96000000)
#define LIS_SPI_BAUDRATE_PRESCALER      SPI_BaudRatePrescaler_8  // 48MHz /8=6MHz (max<=10MHz!)
#elif (TARGET_CPU_FREQ_HZ == 60000000)
#define LIS_SPI_BAUDRATE_PRESCALER      SPI_BaudRatePrescaler_4  // 30MHz /4=7.5MHz (max<=10MHz!)
#else
#error
#endif

//- LIS_IRQn EXTI 
//#define LIS_IRQ_EXTI_LINEx       EXTI_Line11
//#define __LIS_IRQ_NVIC_Init()   (NVIC_EXTI15_10_Init())


/* Public functions ----------------------------------------------------------*/
void LIS_SPI_Init(void);
void LIS_SPI_DeInit(void);
void SPI_TxRx( SPI_TypeDef* SPIx, uint8_t *sndbuf, uint16_t sndlen, uint8_t *rcvbuf, uint16_t rcvlen );
void SPI_TxRxPoll( SPI_TypeDef* SPIx, uint8_t *sndbuf, uint16_t sndlen, uint8_t *rcvbuf, uint16_t rcvlen );

#ifdef __cplusplus
 }
#endif
#endif // __LIS_SPI_DRIVER_H
