/**
******************************************************************************
* File Name          : ll_rs_driver.h
* Description        : 
*                      
*                      
******************************************************************************
*/
#ifndef __LL_RS_DRIVER_H
#define __LL_RS_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif 

/* Includes -----------------------------------------------------------------*/
#include "stm32f4xx.h"
#include "system_config.h"
#include "FreeRTOS.h"
#include "semphr.h"
#include "task.h"

/* Exported types ------------------------------------------------------------*/
typedef struct
{
  USART_TypeDef* uart_pherph;
  
  IRQn_Type irqn;
  uint8_t irq_prio;
  void (*remap)(void);
  void (*clock)(const bool);
  
  GPIO_TypeDef* tx_port;
  uint16_t tx_pin;
  GPIOOType_TypeDef tx_pin_otype;
  
  GPIO_TypeDef* rx_port;
  uint16_t rx_pin;
  GPIOPuPd_TypeDef rx_pin_pupd;
  
  GPIO_TypeDef* re_port;
  uint16_t re_pin;
  
  GPIO_TypeDef* de_port;
  uint16_t de_pin;
  uint8_t de_out_wait;
}ll_uart_hw_t;

typedef enum {IDLE, TX, RX, END} ll_uart_state_t;

typedef struct
{
  SemaphoreHandle_t txrx_end_sem;
  ll_uart_state_t uart_state;
  const uint8_t *tx_buf;
  uint8_t *rx_buf;
  uint16_t tx_cnt, rx_cnt, rx_num;
  uint32_t txrx_timewait;
  __IO uint8_t enable_stop_byte;
  __IO uint8_t stop_byte;
  __IO uint8_t assync_mode;
  uint8_t echo_disable_option;
  
  bool (*data_recv_it_callback)(const uint8_t* data, const uint16_t len);
  
  const ll_uart_hw_t* const hw;
}ll_uart_driver_t;

/* Private define ------------------------------------------------------------*/

/* Private macro -------------------------------------------------------------*/   

/* Exported functions --------------------------------------------------------*/   
void ll_rs_init(ll_uart_driver_t* const driver);
void ll_rs_deinit(ll_uart_driver_t* const driver);
void ll_rs_set_param(ll_uart_driver_t* const driver, const uint32_t baudrate, uint32_t timeout, const char *param_string);
void ll_rs_set_ext_param(ll_uart_driver_t* const driver, const uint32_t baudrate, uint32_t timeout, const char *param_string, bool (*data_recv_it_callback)(const uint8_t* data, const uint16_t len));
uint16_t ll_rs_txrx(ll_uart_driver_t* const driver, const uint8_t *sbuf, const uint16_t slen, uint8_t* const rbuf, uint16_t const rlen);
void ll_rs_irq_handler(ll_uart_driver_t* const driver);

uint16_t ll_rs_assync_tx(ll_uart_driver_t* const driver, const uint8_t *sbuf, const uint16_t slen);
void ll_rs_assync_rx(ll_uart_driver_t* const driver, uint8_t *rbuf, const uint16_t rbuf_size);
uint16_t ll_rs_assync_get_rx_count(ll_uart_driver_t* const driver);
/* External variables --------------------------------------------------------*/ 

#ifdef __cplusplus
}
#endif 

#endif /* __LL_RS_DRIVER_H */
