/**
  ******************************************************************************
  * File Name          : memory_spi.cpp
  * Description        :  SPI   Macronix
  *     
  *                      
  ******************************************************************************
*/

#ifndef    MEMORY_SPI_H
#define    MEMORY_SPI_H

#include <stdint.h>
#include "stm32f4xx.h"

#ifdef USE_FREERTOS
#include "FreeRTOS.h"
#include "semphr.h" 
#endif

//   SPI  
#define MEMORY_SPI                                      SPI1
//   
#define MEMORY_SPI_MISO_PIN                             GPIO_Pin_6
#define MEMORY_SPI_MISO_PORT                            GPIOA
#define MEMORY_SPI_MOSI_PIN                             GPIO_Pin_7
#define MEMORY_SPI_MOSI_PORT                            GPIOA
#define MEMORY_SPI_SCK_PIN                              GPIO_Pin_5
#define MEMORY_SPI_SCK_PORT                             GPIOA
#define MEMORY_SPI_CS_PIN                               GPIO_Pin_0
#define MEMORY_SPI_CS_PORT                              GPIOB

#define MEMORY_SPI_REMAP()                              {GPIO_PinAFConfig(MEMORY_SPI_MISO_PORT, GPIO_PinSource6, GPIO_AF_SPI1);  GPIO_PinAFConfig(MEMORY_SPI_MOSI_PORT, GPIO_PinSource7, GPIO_AF_SPI1);  GPIO_PinAFConfig(MEMORY_SPI_SCK_PORT, GPIO_PinSource5, GPIO_AF_SPI1);}

//  
#define MEMORY_SPI_CLOCK(ENABLE_OR_DISABLE)             RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI1, ENABLE_OR_DISABLE)         
//   CS
#define MEMORY_SPI_CS_HI()                              GPIO_SetBits(MEMORY_SPI_CS_PORT, MEMORY_SPI_CS_PIN)
#define MEMORY_SPI_CS_LOW()                             GPIO_ResetBits(MEMORY_SPI_CS_PORT, MEMORY_SPI_CS_PIN)

#define MEMORY_SPI_Tx_DMA_Chanel                        DMA_Channel_3
#define MEMORY_SPI_Tx_DMAy_Streamx                      DMA2_Stream3
#define MEMORY_SPI_Tx_DMAy_FLAG_TCx                     DMA_IT_TCIF3
#define MEMORY_SPI_Tx_DMAy_Streamx_IRQn                 DMA2_Stream3_IRQn
#define MEMORY_SPI_Tx_DMAy_Streamx_IRQHandler           DMA2_Stream3_IRQHandler
#define MEMORY_SPI_Tx_DMAy_Streamx_IRQn_PRIO            15 //lowest priority

#define MEMORY_SPI_Rx_DMA_Chanel                        DMA_Channel_3
#define MEMORY_SPI_Rx_DMAy_Streamx                      DMA2_Stream0
#define MEMORY_SPI_Rx_DMAy_FLAG_TCx                     DMA_IT_TCIF0
#define MEMORY_SPI_Rx_DMAy_Streamx_IRQn                 DMA2_Stream0_IRQn
#define MEMORY_SPI_Rx_DMAy_Streamx_IRQHandler           DMA2_Stream0_IRQHandler
#define MEMORY_SPI_Rx_DMAy_Streamx_IRQn_PRIO            15 //lowest priority

#define MEMORY_SPI_Tx_DMAx_CLOCK(ENABLE_OR_DISABLE)     RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_DMA2, ENABLE_OR_DISABLE)
#define MEMORY_SPI_Rx_DMAx_CLOCK(ENABLE_OR_DISABLE)     RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_DMA2, ENABLE_OR_DISABLE)

#define MEMORY_SPI_MAX_TX_RX_TIMEOUT_MS                 6000

//  SPI  
class CMemory_spi
{
  public:
  // 
  CMemory_spi(void);  
  // 
  void Init(void);
  // 
  void Deinit(void);
  //   
  void CS_up(void);
  //   
  void CS_down(void);
  //  
  void Send_data(const uint8_t* data, uint16_t len);
  //  
  void Send_byte(uint8_t byte);
  //  
  void Get_data(uint8_t* data, uint16_t len);
  //   
  uint8_t Get_byte(void);
  #ifdef USE_FREERTOS
  //    
  static SemaphoreHandle_t  MEMORY_SPI_Semaphore; 
  #else
  static volatile uint8_t MEMORY_SPI_Semaphore;
  #endif
  private:
  //    
  DMA_InitTypeDef DMA_InitStructure;
};
#endif    /* MEMORY_SPI_H */
