/*
################################################################################
##            INCLUDE
##############################################################################*/
#include "nrf_common.h"
#include "cph_Encrypt.h"
#include "nrf_GlobalService.h"
#include "y_eeprom.h"

/*
################################################################################
##            VARIABLES
##############################################################################*/

//_______________________________________________________________
///////////// COMMON ////////////////////////////////////////////
const uint8_t rf_CRCPOS[2] = {3, 5};  //  CRC  ACK-    
static uint8_t RGD_MarkRequestCounter; //  ,         

TWOBYTES USWF_RELAY;
uint8_t RelayFrequencyPairCode = RELAY_FREQUENCY_PAIR_CODE_CHIP; //    510-
WORDUM SNrl = {0x00,0x00,0x00,0x00};
uint8_t ReservedLockoutStatus = LOCKOUT_DIS;
WORDUM SNd = {0x00,0x00,0x00,0x00}; //   
uint8_t Mk_ChForAnswer; //     


//_______________________________________________________________
/////////////// SCANER //////////////////////////////////////////
const uint8_t GenerRandNum1[256] = {
  0x87,0xD0,0x2D,0x20,0x91,0xD9,0xE4,0x78,	0x60,0xBD,0xCE,0xF3,0x89,0x14,0x50,0x1D,
  0xAB,0xD6,0xC4,0x82,0xE0,0xE5,0xF8,0x07,	0x11,0xA4,0xBC,0xE7,0xA2,0xF2,0x73,0x1C,
  0xAA,0x1F,0x66,0x4F,0x40,0x31,0x0D,0x23,	0x12,0x48,0x61,0x53,0x3D,0x6B,0x72,0x4E,
  0x70,0xB8,0xDE,0x09,0xC2,0x57,0x12,0x80,	0x3E,0x10,0x4B,0x32,0x67,0x6A,0x46,0xF1,
  0x84,0x9E,0xDA,0xF5,0x63,0x7E,0x0C,0x43,	0x93,0x38,0x9A,0xF6,0xAE,0x21,0x8E,0x59,
  0xEA,0x5C,0x7F,0xB7,0x6F,0xEC,0x8D,0x2E,	0x65,0x3B,0xB9,0xF4,0xE8,0xFB,0x3A,0xC8,
  0x68,0xAD,0xE9,0x16,0xBF,0x5A,0xB1,0x6C,	0x45,0x79,0xAA,0x01,0x99,0xCC,0x42,0x19,
  0x0A,0x5E,0x00,0x94,0xB0,0x24,0x8C,0x5B,	0x4D,0x0F,0x88,0xA0,0x29,0xC7,0x1A,0x47,
  0x15,0xCB,0xE2,0x95,0x4C,0x7B,0x86,0xA9,	0x52,0x7A,0xD1,0xED,0x02,0x41,0xBE,0xD4,
  0xBB,0x2C,0x1B,0x37,0xD3,0xCF,0xA3,0xB4,	0x34,0xB2,0x56,0x90,0x98,0xA5,0x06,0x4A,
  0x25,0x9D,0xEF,0xA1,0xDF,0xE3,0x77,0x2B,	0x26,0x76,0xD5,0xA8,0xC3,0x03,0x55,0xA6,
  0x6E,0x54,0x81,0xD2,0x71,0x39,0x5D,0xCD,	0xD7,0x04,0x6D,0x8F,0xE1,0x7C,0x3F,0xC9,
  0x9C,0x28,0x9F,0x13,0x44,0xAF,0x22,0xE6,	0x64,0xB3,0xDC,0xC6,0x83,0xBA,0x8A,0x51,
  0x69,0x17,0x74,0x49,0x58,0x5F,0x36,0xC1,	0xF9,0xFC,0x62,0xFA,0x34,0x2A,0x53,0x35,
  0x85,0xB6,0xC5,0xEB,0xF7,0xC0,0x18,0x96,	0x8B,0x75,0x08,0xF0,0x2F,0xDD,0xDB,0x27,
  0x30,0x0B,0xCA,0xAC,0x33,0x05,0x9B,0xA7,	0x97,0x1E,0xB5,0x3C,0x7D,0xD8,0x92,0x0E
};

ENCRYPT_KEY m2_KEY = {0x00,0x00,0x00}; //    2.4   . KEY    base frequency key,               
TWOBYTES m2_USWF; //   pipe-   
TWOBYTES m2_DTM; //  DTM ( ,       )
FREQ_PAIR m2_ChannelBlock[2]; //   
uint8_t m2_PipeAddrBlock[2][5] = {{0x00,0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00,0x00}};
uint8_t m2_ChForAnswer = 0x00; //     
WORDUM RequestBuf = {0x00,0x00,0x00,0x00}; 
WORDUM m2_PredictAnsw[MAX_MARK_NUMBER] = {
   {0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},
   {0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00}}; //       2.4 
uint8_t UniqueAck0[12] = {0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00}; //    0
//uint8_t rf_NumberValidMarks = 0x00; //      
//uint8_t rf_MarkCountPosition = 0x00; //     
uint8_t UniqueDigit[4] = {0x00,0x00,0x00,0x00}; //  
uint8_t AckCmd = 0x00; //          
TWOBYTES GRD_ExecuteTimer; //      ACK
TWOBYTES GRD_MainTimer; //   
TWOBYTES GRD_MainSwitchTimer; //   
uint8_t CurDevNum = 0x00;


//####################################################################
//##################################################################
//##                  SUPERVISOR 
//##################################################################
//####################################################################
//============================================================================
//    
void cph_DownloadRequest(uint8_t _dm, uint8_t* _buf, uint8_t* _buf_length)
{
  RGD_MarkRequestCounter = (((RGD_MarkRequestCounter+0x10)&0xF0)|ID_CHIP);	// 
  
  if(_dm == NRF_DIALOG_MODE_NORMAL)
  {
    _buf[0] = RGD_MarkRequestCounter;
    *_buf_length = 1;
  }
  else
  {
    _buf[0] = SNd.E8[0];
    _buf[1] = SNd.E8[1];
    _buf[2] = SNd.E8[2];
    _buf[3] = RGD_MarkRequestCounter;
    *_buf_length = 4;
  }
}

//==============================================================================
//   CRC  .     ACK 
//      .
//  : _unique_ack -      crc 
//                 _pack_length -    
//                 _crc_position -   CRC  
//  : _unique_ack[_crc_position] - CRC    ACK- _unique_ack
void cph_CalculateAckCrc(uint8_t* _unique_ack, uint8_t _pack_length, uint8_t _crc_position)
{
  uint8_t i = 0x00;
  uint8_t crc_buf = 0x00;
  
  //    ,   crc,  ,     
  //     CRC  
  _unique_ack[_crc_position] = 0x00; 
  ////////////   CRC //////////////
  crc_buf = _unique_ack[0]+1;
  for(i=1;i<_pack_length;i++)
  {
    crc_buf = crc_buf ^ _unique_ack[i];
  }
  /////////  CRC   //////////
  _unique_ack[_crc_position] = crc_buf^0xA9; //   crc    
}

//============================================================================
//  R 
//  : _buf -   
//                 _buf_length -    
//  : _crc_buf -  CRC 
void cph_CalculateCrc(uint8_t* _buf, uint8_t _buf_length, uint8_t* _crc_buf)
{
  uint8_t i = 0x00;
  *_crc_buf = _buf[0]+1;
  for(i=1;i<_buf_length;i++)
  {
    *_crc_buf = *_crc_buf ^ _buf[i];
  }
  /////////  CRC   //////////
  *_crc_buf = *_crc_buf^0xA9; //  CRC 
}

//==========================================================================
//   CRC      
BOOLEAN cph_CheckCrc(uint8_t _dm, uint8_t* _buf)
{ 
  uint8_t CaclCrc = 0x00;
  uint8_t RxCrc = 0x00;
  
  RxCrc = _buf[rf_CRCPOS[_dm]];  //   CRC   
  //    ,   crc,  ,     
  //     CRC    cph_CalculateCrc
  _buf[rf_CRCPOS[_dm]] = 0x00; 
  ////////////   CRC //////////////
  cph_CalculateCrc(_buf, rf_ACKNB[_dm], &CaclCrc);
  if(CaclCrc == RxCrc)
  {
    _buf[rf_CRCPOS[_dm]] = RxCrc; //     
    return(BOOL_TRUE);
  }
  else{return(BOOL_FALSE);}
}

//==============================================================================
//   .     
//   ,    _fn
//  : _fn -     
//                 _cover_byte -  
//                 _unique_ack -   RGD -   ACK.
//  : uncover_byte -  .
uint8_t cph_Uncover(uint8_t _fn, uint8_t _cover_byte, uint8_t* _unique_ack)
{
  uint8_t uncover_byte = 0x00; 
  switch(_fn)
  {
  case 0:  // DTM.high
    uncover_byte = (((_cover_byte^0x36)+_unique_ack[6])^ 0x54 ^ _unique_ack[4])-_unique_ack[2]-1;
    break;
    
  case 1:  // DTM.low
    uncover_byte = ((((_cover_byte-0x03)^_unique_ack[2])+_unique_ack[4])^_unique_ack[6]^0x92)-0x11;
    break;       
    
  case 2:  // RxData(CMD), SNam[0]
    uncover_byte = ((((_cover_byte+_unique_ack[2])^0xB1)-_unique_ack[6])^0x12)+0x27+_unique_ack[4];
    break;  
    
  case 3:  // settings, SNam[1]
    uncover_byte = ((_cover_byte^_unique_ack[6])-0x52)^(_unique_ack[2]+_unique_ack[6]-_unique_ack[4]);
    break;        
    
  case 4:  // SNam[2]
    uncover_byte = (_cover_byte^(_unique_ack[4] - _unique_ack[2])) - 0x4C;
    break;  
    
  case 5:  // USWF.low
    uncover_byte = ((_cover_byte + _unique_ack[6]) ^ _unique_ack[2]) - 0xA2;
    break; 
    
  case 6:  // USWF.high
    uncover_byte = ((_cover_byte - _unique_ack[2]) ^ _unique_ack[4]) - 0xED;
    break;      
    
  case 7:  // KEY.bfc
    uncover_byte = ((((_cover_byte ^ _unique_ack[8]) - _unique_ack[6]) ^ _unique_ack[7]) + _unique_ack[4]) ^ 0x5B;
    break;    
    
  default: break;  
  }
  
  return(uncover_byte);
}

//------------------------------------------------------------------------------
//       
//  :
//      _unique_ack -         
//      _open_mark_settings -   (,   , 
//                -  )
//  :     
uint8_t cph_CalculateFreqChannel(uint8_t* _unique_ack, uint8_t* _open_mark_settings, ENCRYPT_KEY* _key)
{
  uint8_t buf_i = 0x00;
  
  //   
  if(_unique_ack[1]&0x08)	{buf_i|=0x01;}
  if(_unique_ack[7]&0x40)	{buf_i|=0x02;}
  if(_unique_ack[3]&0x80)	{buf_i|=0x04;}
  if(_unique_ack[6]&0x02)	{buf_i|=0x08;}
  if(_unique_ack[4]&0x04)	{buf_i|=0x10;}
  if(_unique_ack[5]&0x01)	{buf_i|=0x20;}
  if(_unique_ack[2]&0x10)	{buf_i|=0x40;}
  buf_i = (buf_i ^ (((*_open_mark_settings)>>1)+0x11));
  buf_i = (((_key->bfc ^ buf_i)+_key->high)^_key->low) & 0x7F; //
  
  //         0x7F (127)
  if(buf_i>125) {buf_i&=0xFC;}		// 0x7D   nRF24L01+
  
  return(buf_i);
}

//==============================================================================
//    SNmk  
//  :
//      _unique_ack -       
//      _sn -        
//  :
//      _predict_answ -     
void cph_CalculatePredictAnsw(uint8_t* _unique_ack, WORDUM* _sn, uint8_t _fc, WORDUM* _predict_answ)
{
  uint8_t buf_i = 0x00;
  /////////////////      
  buf_i = (_sn->E8[0]+_sn->E8[1]-_sn->E8[2])^(_sn->E8[3]&0x0F);
  _predict_answ->E8[0] = ((_sn->E8[2]>>4)|(_sn->E8[0]<<4)) ^ buf_i;
  _predict_answ->E8[1] = ((_sn->E8[2]<<4)|(_sn->E8[0]>>4)) ^ buf_i ^ 0x25;
  _predict_answ->E8[2] = ((_sn->E8[1]<<4)|(_sn->E8[1]>>4)) ^ buf_i ^ 0xD2;
  
  _predict_answ->E8[0] = (_predict_answ->E8[0] + _unique_ack[1] + 1) ^ _unique_ack[4];
  _predict_answ->E8[1] = (_predict_answ->E8[1] + _unique_ack[3] - 2) ^ _unique_ack[0];
  _predict_answ->E8[2] = (_predict_answ->E8[2] - _unique_ack[5]) ^ _unique_ack[6] ^ 0x36;
  _predict_answ->E8[3] = (((_fc ^ _unique_ack[2]) - _unique_ack[4]) ^ _unique_ack[6]) + 0x8E;
}




//============================================================================
//   (ACK) 
BOOLEAN cph_DecipherAck(uint8_t* _rx_buf, uint8_t* _answ_buf, uint8_t* _ch_for_answer, uint8_t* _status)
{
  DECIPHER_STATE DecipherState;
  FlagStatus F_DecipherFinish = RESET;
  uint8_t tmp;
  ENCRYPT_KEY KeyBuf;
  BOOLEAN DecipherResult = BOOL_FALSE;
  TWOBYTES Buf;
  
  *_status = 0x00;  //       
  DecipherState = ds_CheckPacketCrc;
  do
  {
    switch(DecipherState)
    { //___________________________________________________________
      ////////////////    /////////////////
    case ds_CheckPacketCrc:
      if(cph_CheckCrc(0, _rx_buf) == BOOL_TRUE)
      {DecipherState = ds_UncoverPacket;}
      else{DecipherState = ds_Exit;}
      break;
      
      //___________________________________________________________
      ///////////////////////   /////////////////////
    case ds_UncoverPacket:
      /////////   ///////////
      Buf.low = cph_Uncover(1, _rx_buf[7], _rx_buf); 	 /////////   DTM.low ///////////
      Buf.high = cph_Uncover(0, _rx_buf[5], _rx_buf);  /////////   DTM.high ///////////
      if((Buf.low == m2_DTM.low) && (Buf.high == m2_DTM.high))
      {
        /////////    ///////////
        //    
        *_status = cph_Uncover(2, _rx_buf[1], _rx_buf);
        tmp = cph_Uncover(3, _rx_buf[0], _rx_buf);
        DecipherState = ds_CalculateAnswer;
        KeyBuf = m2_KEY;    
      }
      else{DecipherState = ds_Exit;} //   
      break;
      
      //___________________________________________________________
      /////////////////////   /////////////////////
    case ds_CalculateAnswer:
      //////////    ////////////
      *_ch_for_answer = cph_CalculateFreqChannel(_rx_buf, &tmp, &KeyBuf);
      
      cph_CalculatePredictAnsw(_rx_buf, &SNd, ReservedLockoutStatus, (WORDUM*)_answ_buf);
      // uart_PrintString("sn:"); 
      // uart_PrintMassive((uint8_t*)&SNd,4); 
      DecipherResult = BOOL_TRUE;
      DecipherState = ds_Exit;
      break;
      
      
      //___________________________________________________________
      /////////////////////   /////////////////////
    case ds_Exit:
      F_DecipherFinish = SET;
      break;
    }
  }while(F_DecipherFinish == RESET);
  
  return(DecipherResult);
}




//==============================================================================
//          .
//  : true -  
//                  false -  
bool CheckRegStatus(uint8_t _reg_type)
{
  bool reg_status = false;
  //      "Scaner" ( )
  if(_reg_type ==  SCAN_MODE)
  {
    if((e_NumberOfValidMarksInSystem >= 1) && (e_NumberOfValidMarksInSystem <= MAX_MARK_NUMBER))
    {
      reg_status = true; //  ,  
    }
  }
  //     
  else
  {
    if(e_NumberOfValidRelaysInSystem >= 1)
    {
      reg_status = true; //  
    }
  }
  return(reg_status);
}




//####################################################################
//##################################################################
//##                  SCANER 
//##################################################################
//####################################################################

//==============================================================================
//    
uint8_t cph_FreqChannelGet(void)
{
  return(m2_ChForAnswer);
}



//==============================================================================
//    
void cph_UpdateRequestBuf(uint8_t _dialog_mode, uint8_t* _rx_id, uint8_t _rx_length)
{
  RequestBuf.E32 = *((uint32_t*)_rx_id);
  
  /////////  ID    ////////
  //   ,  ID   0- , ..    
  //  ,   0,1,2 - , a ID  3- 
  // .. ID    
  RGD_MarkRequestCounter = _rx_id[_rx_length-1];
  
  if(_dialog_mode == NRF_DIALOG_MODE_PROGRAMM)
  {
    //     PredictAnsw       
    //  .        ,    
    //            cph_UpdateRequestBuf
    //  PredictAnsw
    cph_CalculatePredictAnsw(UniqueAck0, &RequestBuf, 0x00, &m2_PredictAnsw[0]); m2_PredictAnsw[0].E8[3] = 0x00;
  }
  //else
  //{
  //    ,         ,
  //  PredictAnsw        
  //   UniqueAck0.
  //}
}













//==============================================================================
//     ID (  )
uint8_t cph_GetRqId(void)
{
  return(RGD_MarkRequestCounter&0x0F);
}

//==============================================================================
//         
//  : _instruct[1] -      
//                              0xFF -   
//                              0x00 -  
//                              0x01 -  
//                              0x02 -         
//                 _instruct[0] -    
BOOLEAN cph_DecipherAnswer(uint8_t _dialog_mode, uint8_t* _id, uint8_t* _rx_buffer, uint8_t* _instruct)
{
  uint8_t i = 0;
  BOOLEAN DecipherAnswerResult = BOOL_FALSE;
  WORDUM rx_Answer;
  rx_Answer.E32 = *(uint32_t*)_rx_buffer;
  rx_Answer.E8[3] = 0x00; // ..     
  
  for(i=0;i<MAX_MARK_NUMBER;i++)
  {
    m2_PredictAnsw[i].E8[3] = 0x00;  
  }
  
  if(_dialog_mode == NRF_DIALOG_MODE_NORMAL)
  {
    //          
    //       .    
    //      ,  e_NumberOfValidMarksInSystem = 1
    //          PredictAnsw[0]
    if(*_id == ID_MARK)
    {
      //if(chp_CheckAnswer(&rx_Answer, &PredictAnsw, &e_NumberOfValidMarksInSystem) == BOOL_TRUE)
      //{
      //  DecipherAnswerResult = BOOL_TRUE;
      //  break;
      //}
      for(i=0;i<MAX_MARK_NUMBER;i++)	//     (     SN),          n24_MarkEnableCondition (  )
      {
        if(ram_ItIsZero(SNnrf[i].E8, 3) == false) //    0,     
        {
          if(m2_PredictAnsw[i].E32 == rx_Answer.E32)
          {
            DecipherAnswerResult = BOOL_TRUE;
            break;
          }
        }
      }
    }
  }
  else
  { //        ,   
    //  ,       
    //         
    //   PredictAnsw[0].E32
    if(m2_PredictAnsw[0].E32 == rx_Answer.E32)
    {
      DecipherAnswerResult = BOOL_TRUE;
    }
  }
  
  //       (CHIP)       RF_MARK_GRAFT
  if(DecipherAnswerResult == BOOL_TRUE)
  {
    _instruct[0] = ((((_rx_buffer[3] - 0x8E) ^ UniqueAck0[6]) + UniqueAck0[4]) ^ UniqueAck0[2]);
    _instruct[1] = i;   //     
  }
  else
  {
    _instruct[0] = 0x00;      
    _instruct[1] = 0xFF;
  }
  return(DecipherAnswerResult);
}

//============================================================================== 
//      2.4
void cph_GenAckCommon(uint8_t _dialog_mode, uint8_t* _unique_ack, uint8_t* _length)
{
  uint8_t i;
  cph_GenerateRandomNuber((uint8_t*)&SNd, &RGD_MarkRequestCounter, UniqueDigit);
  if(_dialog_mode == NRF_DIALOG_MODE_NORMAL)
  {
    //           
    //  ,        - 
    cph_CodingAckBytes(UniqueDigit, &m2_DTM, &m2_KEY, AckCmd, e_MarkPower, HARDWARE_RETRANSMIT_EN, UniqueAck0, &m2_ChForAnswer);
    //      , MAX_MARK_NUMBER  
    for(i=0;i<MAX_MARK_NUMBER;i++)
    {
      cph_CalculatePredictAnsw(UniqueAck0, &SNnrf[i], 0, &m2_PredictAnsw[i]); 
    }
    *_length = rf_ACKNB[_dialog_mode];
  }
  else
  {
    //        :
    //    (SNam),   (USWF),   (KEY).
    //  KEY.bfc    ,     
    // .       (ANSW)    .
    cph_CodingAckBytesProg(UniqueDigit, (uint8_t*)&SNd, &m2_KEY, &m2_USWF, UniqueAck0, &m2_ChForAnswer);
    *_length = rf_ACKNB[_dialog_mode];
  }
  //   
  for(i=0;i<*_length;i++)
  {
    _unique_ack[i] = UniqueAck0[i];
  }
}

//==============================================================================
//    main.    
//  
void cph_Service(void)
{
  GRD_MainTimer.word++;
}

//==============================================================================
//    .    
//  
void cph_Service2(void)
{
  GRD_MainSwitchTimer.word++;
}

//==============================================================================
//   
//  :     _sn_am[3] -    
//                     _mrc -    (      ) 
//  :     _unique_digit[4] -    
void cph_GenerateRandomNuber(uint8_t* _sn_am, uint8_t* _mrc, uint8_t* _unique_digit)
{
  TWOBYTES GRD_Number0;                 //    1
  TWOBYTES GRD_Number1;                 //    2
  
  //        
  GRD_Number0.word = (uint16_t)(nrf_bsp_get_ms()>>0); //    
  GRD_Number1.word = (uint16_t)(nrf_bsp_get_ms()>>16); //    
  
  GRD_Number0.word = GRD_Number0.word ^ GRD_MainSwitchTimer.word;
  GRD_Number1.word = GRD_Number1.word + GRD_MainSwitchTimer.word;
  //        
  GRD_ExecuteTimer.word++;	        //      
  if(GRD_ExecuteTimer.low == 0x00)
  {
    GRD_ExecuteTimer.low = GenerRandNum1[GRD_MainTimer.low];
  }
  
  _unique_digit[0] = GRD_ExecuteTimer.low + GRD_Number0.low;
  _unique_digit[0] = GenerRandNum1[_unique_digit[0]]; 			// 256   
  _unique_digit[0] = _unique_digit[0] + _sn_am[0];
  _unique_digit[1] = GRD_ExecuteTimer.low - GRD_Number1.low + *_mrc;
  _unique_digit[1] = GenerRandNum1[_unique_digit[1]];//+(SNam[1]);	// 256   
  _unique_digit[1] = (_sn_am[1] ^ GRD_MainTimer.low) + _unique_digit[1] + GRD_Number0.high;
  _unique_digit[2] = GRD_MainTimer.high + GRD_ExecuteTimer.high;
  _unique_digit[2] = (GRD_Number0.low-GRD_ExecuteTimer.low) ^ _unique_digit[2]; 
  _unique_digit[2] = _unique_digit[2] ^ GRD_Number1.high ^ _unique_digit[0];
  _unique_digit[2] = _unique_digit[2] + _sn_am[2] - *_mrc;
  _unique_digit[3] = (GRD_MainTimer.high ^ GRD_ExecuteTimer.low) + GRD_Number0.low;
  _unique_digit[3] = (_unique_digit[3] ^ _unique_digit[0]) + _unique_digit[1];
}

//==============================================================================
//        2.4    
void cph_CodingAckBytes(uint8_t* _unique_digit, TWOBYTES* DTM, ENCRYPT_KEY* _key, uint8_t _cmd, uint8_t _mark_power, uint8_t _hr, uint8_t* _unique_ack, uint8_t* _frequency_channel)
{
  uint8_t OpenMarkSettings = 0x00;      //          
  
  ///////////////   4-  /////////////////
  //     RGD (_unique_digit)   
  //    (_unique_ack)
  cph_LoadRgd(_unique_ack, _unique_digit);
  
  /////////////// POWER AND HARDWARE RETRANSMIT ////////////////////////
  cph_AttachSettings(_mark_power, _hr, &_unique_ack[0]);
  OpenMarkSettings = _unique_ack[0]; //    , ..     
  
  //////////////  ACK /////////////////////////
  //  DTM.high
  _unique_ack[5] = cph_Cover(0, DTM->high, _unique_ack);
  //  DTM.low
  _unique_ack[7] = cph_Cover(1, DTM->low, _unique_ack);  
  //  CMD 
  _unique_ack[1] = cph_Cover(2, _cmd, _unique_ack);  
  //   
  _unique_ack[0] = cph_Cover(3, OpenMarkSettings, _unique_ack);
  
  //////////////  CRC /////////////////////////
  cph_CalculateAckCrc(_unique_ack, rf_ACKNB[NRF_DIALOG_MODE_NORMAL], 3);
  
  //      
  *_frequency_channel = cph_CalculateFreqChannel(_unique_ack, &OpenMarkSettings, _key);
  
  //////////////   //////////////////////////
  //_unique_ack[5] = _unique_ack[5] + _key->low;
  // _unique_ack[7] = _unique_ack[7] - _key->high;
  //_unique_ack[1] = _unique_ack[1] ^ _key->low;
  //_unique_ack[0] = _unique_ack[0] ^ _key->high;
}

//==============================================================================
//        2.4    
void cph_CodingAckBytesProg(uint8_t* _unique_digit, uint8_t* _sn_am, ENCRYPT_KEY* _key, TWOBYTES* _uswf_prog, uint8_t* _unique_ack, uint8_t* _frequency_channel)
{
  //     RGD (_unique_digit)      (_unique_ack)
  cph_LoadRgd(_unique_ack, _unique_digit);
  
  ///////////    //////////////
  //  SN[0]
  _unique_ack[3] = cph_Cover(2, _sn_am[0], _unique_ack);  
  //  SN[1]
  _unique_ack[7] = cph_Cover(3, _sn_am[1], _unique_ack);
  //  SN[2]
  _unique_ack[1] = cph_Cover(4, _sn_am[2], _unique_ack);
  //  KEY.low
  _unique_ack[0] = cph_Cover(1, _key->low, _unique_ack);  
  //  KEY.high
  _unique_ack[9] = cph_Cover(0, _key->high, _unique_ack);
  //  USWF.low
  _unique_ack[8] = cph_Cover(5, _uswf_prog->low, _unique_ack); 
  //  USWF.high
  _unique_ack[10] = cph_Cover(6, _uswf_prog->high, _unique_ack);  
  //  KEY.bfc 
  _unique_ack[11] = cph_Cover(7, _key->bfc, _unique_ack);  
  
  //  CRC
  cph_CalculateAckCrc(_unique_ack, rf_ACKNB[NRF_DIALOG_MODE_PROGRAMM], 5);
  
  //      
  *_frequency_channel = cph_CalculateFreqChannel(_unique_ack, &_key->low, _key);
}

//==============================================================================
//    RGD      
//  : _unique_digit -   
//  : _unique_ack -  
void cph_LoadRgd(uint8_t* _unique_ack, uint8_t* _unique_digit)
{
  _unique_ack[0] = _unique_digit[3];    //freq channe, mark power, retransmite
  _unique_ack[2] = _unique_digit[0];
  _unique_ack[4] = _unique_digit[1];
  _unique_ack[6] = _unique_digit[2];
}

//==============================================================================
//    _oms       
//  : _mark_power
//                 _hr - ./.  
//                 _oms -      
//  : _oms -    .
void cph_AttachSettings(uint8_t _mark_power, uint8_t _hr, uint8_t* _oms)
{
  /////////////// HARDWARE RETRANSMIT ////////////////////////
  if(_hr == HARDWARE_RETRANSMIT_EN)  
  {
    *_oms = *_oms | 0x04;
  } 
  else
  {
    *_oms = *_oms & 0xFB;
  }
  ///////////////// MARK POWER ///////////////////////////////
  *_oms = ((*_oms&0xFC) | (_mark_power&0x03));
}

//==============================================================================
//   .     
//   ,    _fn
//  : _fn -     
//                 _uncover_byte -  
//                 _unique_ack -   RGD -   ACK.
//  : cover_byte -  .
uint8_t cph_Cover(uint8_t _fn, uint8_t _uncover_byte, uint8_t* _unique_ack)
{
  uint8_t cover_byte = 0x00; 
  switch(_fn)
  {
  case 0:  // DTM.high
    cover_byte = _uncover_byte + 1 + _unique_ack[2];
    cover_byte = cover_byte ^ _unique_ack[4] ^ 0x54;
    cover_byte = cover_byte - _unique_ack[6];
    cover_byte = cover_byte ^ 0x36;
    break;
    
  case 1:  // DTM.low
    cover_byte = _uncover_byte + 0x11;
    cover_byte = cover_byte ^ _unique_ack[6] ^ 0x92;
    cover_byte = cover_byte - _unique_ack[4];
    cover_byte = cover_byte ^ _unique_ack[2];
    cover_byte = cover_byte + 0x03;
    break;       
    
  case 2:  // CMD
    cover_byte = _uncover_byte - _unique_ack[4] - 0x27;
    cover_byte = cover_byte ^ 0x12;
    cover_byte = cover_byte + _unique_ack[6];
    cover_byte = cover_byte ^ 0xB1;
    cover_byte = cover_byte - _unique_ack[2]; 
    break;  
    
  case 3:  // settings 
    cover_byte = _uncover_byte ^ (_unique_ack[2] + _unique_ack[6] - _unique_ack[4]);
    cover_byte = cover_byte + 0x52;
    cover_byte = cover_byte ^ _unique_ack[6];
    break;        
    
  case 4:  // SNam[2]
    cover_byte = (_uncover_byte + 0x4C) ^ (_unique_ack[4] - _unique_ack[2]);
    break;  
    
  case 5:  // USWF.low
    cover_byte = ((_uncover_byte + 0xA2) ^ _unique_ack[2]) - _unique_ack[6];           
    break;         
    
  case 6:  // USWF.high
    cover_byte = ((_uncover_byte + 0xED) ^ _unique_ack[4]) + _unique_ack[2];
    break;      
    
  case 7:  // KEY.bfc
    cover_byte = ((((_uncover_byte ^ 0x5B) - _unique_ack[4]) ^ _unique_ack[7]) + _unique_ack[6]) ^ _unique_ack[8];
    break;    
    
  default: break;  
  }
  
  return(cover_byte);
}

//==============================================================================
//       
void cph_DeleteMark(uint8_t _cell_number)
{
  if(_cell_number < MAX_MARK_NUMBER)
  {  
    if(SNnrf[_cell_number].E32)
    {
      SNnrf[_cell_number].E32 = 0x00000000; 
      nRF_MarksGrafted_MaskUpdate();
      //////  EEPROM /////////
      eeprom_UpdateItemLaunch();
      eeprom_Service();             //    EEPROM
    }
  }
}

//==============================================================================
//       (     EEPROM)
void cph_GraftNewMark(void)
{
  uint8_t i;
  RequestBuf.E8[3] = 0x00;
  
  //____________________________________________________________________________
  //         -  
  // ,   ,    
  for(i=0;i<MAX_MARK_NUMBER;i++)
  {
    if(ram_ItIsEqual(RequestBuf.E8, SNnrf[i].E8, 3) == true)
    {
      //   ,   ID  
      SNnrf[i].E32 = 0x00000000;
    }
  }
  //____________________________________________________________________________
  //   ID      
  if(NRFCtrl.MarkCurGraftCell < MAX_MARK_NUMBER)
  {
    SNnrf[NRFCtrl.MarkCurGraftCell].E32 = RequestBuf.E32; //  ID   
  }

  
  nRF_MarksGrafted_MaskUpdate(); //     
  
  e_NumberOfValidMarksInSystem = cph_GetNumberValidMarksInSystem();
  //////  EEPROM /////////
  eeprom_UpdateItemLaunch();
}
//==============================================================================
//       
uint8_t cph_GetNumberValidMarksInSystem(void)
{
  uint8_t i;
  uint8_t mark_cnt = 0;
  
  for(i=0;i<MAX_MARK_NUMBER;i++)	//     (     SN),          n24_MarkEnableCondition (  )
  {
    if(ram_ItIsZero(SNnrf[i].E8, 3) == false) //    0,   
    {
      mark_cnt = mark_cnt + 1;
    }
  }
  return(mark_cnt);
}
/*
//==============================================================================
//       (     EEPROM)
//    
//         
//    
//    
void cph_GraftNewMark(void)
{
  uint8_t i = 0x00;
  
  ////////       ///////
  for(i=0; i<rf_NumberValidMarks; i++)
  {
    if((RequestBuf.E8[0] == SNnrf[i].E8[0]) && 
       (RequestBuf.E8[1] == SNnrf[i].E8[1]) && 
         (RequestBuf.E8[2] == SNnrf[i].E8[2]))
    {
      // 
      CurDevNum = i; //    
      goto eu_Update;
    }
  }
  
  ///////       ///////
  rf_MarkCountPosition++;
  if(rf_NumberValidMarks < 3)
  {
    if(rf_NumberValidMarks == 0x00)
    {
      rf_MarkCountPosition = 0x00;
    }
    rf_NumberValidMarks++;
  }
  
  if(rf_MarkCountPosition >= 3)
  {
    rf_MarkCountPosition = 0x00;
  }
  CurDevNum = rf_MarkCountPosition; //  
  
eu_Update:
  //////   /////////  
  e_NumberOfValidMarksInSystem = rf_NumberValidMarks; //    
  RequestBuf.E8[3] = 0x00;
  SNnrf[CurDevNum].E32 = RequestBuf.E32;
  //////  EEPROM /////////
  eeprom_UpdateItemLaunch();
}
*/



//==============================================================================
//    
void cph_DeleteRelay(void)
{
  if(SNrl.E32)
  {
    SNrl.E32 = 0x00000000; 
    e_NumberOfValidRelaysInSystem = 0;
    //////  EEPROM /////////
    eeprom_UpdateItemLaunch();
    eeprom_Service();             //    EEPROM
  }
}

//==============================================================================
//       (     EEPROM)
//    
//         
//    
//void es_UpdateEncryptSettings(VALID_DEVICE_COUNTER* _gnv_device, VALID_DEVICE_COUNTER* _count_position, TWOBYTES* _pc, WORDUM* _sn, DECRYPT_KEY* _dkey)
void cph_GraftNewRelay(void)
{
  RequestBuf.E8[3] = ID_RELAY;
  SNrl.E32 = RequestBuf.E32; 
  e_NumberOfValidRelaysInSystem = 1; //    
  //////  EEPROM /////////
  eeprom_UpdateItemLaunch();
}

//==============================================================================
//    
void cph_DownloadRelayRequest(uint8_t* tx_buf, uint8_t* tx_buf_len)
{
  tx_buf[0] = SNrl.E8[0];
  tx_buf[1] = SNrl.E8[1];
  tx_buf[2] = SNrl.E8[2];  
  tx_buf[3] = ID_CHIP;   
  *tx_buf_len = 4;
}

//#############################################################################
//##                      CALCULATE FUNCTIONS
//#############################################################################

//==============================================================================
//      pipe- .
// Pipe-         (uswf)
// Pipe-     ,    
//   pipe       
//   ,     .   
// pipe-     ,  
//  uswf.        .
//   uswf    pipe-.    
// ,       .
void calculate_PipeAddr(WORDUM* _sn, TWOBYTES* _uswf, uint8_t* _pa)
{
  uint8_t i;
  TWOBYTES unique_filter;
  WORDUM serial_number;
  unique_filter = *_uswf;
  serial_number = *_sn;
  
  _pa[0] = serial_number.E8[0];
  for(i=4;i>=1;i--)
  {
    serial_number.E32 = serial_number.E32<<4;
    _pa[i] =(unique_filter.high&0xF0)|(serial_number.E8[3]&0x0F);
    unique_filter.word = unique_filter.word<<4;
  }
}

//==============================================================================
//  pipe-   2.4
//  : _pa - pipe-  2.4
void calculate_PipeAddrProg(uint8_t* _pa)
{
  ///////// PROGRAMM ADDRESS /////////
  _pa[0] = PIPE_ADDRESS_PROG_0; 
  _pa[1] = PIPE_ADDRESS_PROG_1; 
  _pa[2] = PIPE_ADDRESS_PROG_2; 
  _pa[3] = PIPE_ADDRESS_PROG_3; 
  _pa[4] = PIPE_ADDRESS_PROG_4;
}

//==============================================================================
//  DTM -  
//  : _sn -        
//  : _dtm -  
void calculate_DTM(uint8_t* _pa, TWOBYTES* _dtm)
{
  _dtm->low = (_pa[1]^_pa[2])+_pa[0]; 
  _dtm->high = (_pa[3]^_pa[4])-_pa[0]; 
}

//==============================================================================
//          
//  : _bfc -     0  63,   > 
//   63  .
//  : _ch_pair -   (    )
void calculate_FreqChannelPair(uint8_t _bfc, FREQ_PAIR* _ch_pair)
{
  _ch_pair->main = (_bfc)&0x3F;
  _ch_pair->reserve = ((_bfc)&0x3F)+63; //     63 
}

//==============================================================================
//  BFC - Base Frequency Code
// BFC    : <*,*><*,*,*,*,*,*> 
//  2  -  
//  6  -   ,      
//    ( 63 )
//     2.4   .    
//           
//  : _sn -    2.4
//  : _bfc -       
void calculate_KEY(WORDUM* _sn, ENCRYPT_KEY* _key)
{    
  //    (& 0xDE | 0x10)       2.4
  //  8    ,  (  ), 
  //    , ..   1 ,     2 .
  //  GenerRandNum1[256]       
  _key->bfc = (GenerRandNum1[_sn->E8[0]] & 0xDE) | 0x10; 
  _key->low = GenerRandNum1[_sn->E8[1]] + _sn->E8[0]; 
  _key->high = GenerRandNum1[_sn->E8[2]] - _sn->E8[0];  
}



//==============================================================================
//     .       .
//      BOOL_TRUE
BOOLEAN cph_CheckToRelay(void)
{ // ,     
  if((RGD_MarkRequestCounter & 0x0F) == ID_RELAY)
  {return(BOOL_TRUE);}
  else
  {return(BOOL_FALSE);}
}

//==============================================================================
//       .
//   ,    ,     ACK2 .
BOOLEAN cph_HandleRequestRelay(uint8_t _dialog_mode, uint8_t* _ack2)
{
  BOOLEAN is_it_relay = BOOL_FALSE;
  WORDUM LoadBuf;
  
  if(_dialog_mode == NRF_DIALOG_MODE_PROGRAMM)
  {
    LoadBuf.E8[0] = USWF_RELAY.low;
    LoadBuf.E8[1] = USWF_RELAY.high;
    LoadBuf.E8[2] = RelayFrequencyPairCode;  //   ,                    
    LoadBuf.E8[3] = 0xAA;
    
    _ack2[0] = cph_Cover(3, LoadBuf.E8[0], UniqueAck0);  
    _ack2[1] = cph_Cover(4, LoadBuf.E8[1], UniqueAck0);    
    _ack2[2] = cph_Cover(5, LoadBuf.E8[2], UniqueAck0); 
    _ack2[3] = cph_Cover(6, LoadBuf.E8[3], UniqueAck0); 
    is_it_relay = BOOL_TRUE;  
  }
  
  return(is_it_relay);
}

/*
//==============================================================================
//    SNrl
uint8_t uf_CheckCoincidence(FlagStatus* _rvs, WORDUM* _buf_sn, uint8_t* _rx_sn)
{
uint8_t i;
if(*_rvs == SET) //   ,    SN
{    
if(ram_ItIsEqual((uint8_t*)&(_buf_sn[i]), _rx_sn, 3) == BOOL_TRUE)
{  
return(0); //   ,     
    }
  }
return(0xFF);
}
*/






