#ifndef __cph_Encrypt_H
#define __cph_Encrypt_H

#ifdef __cplusplus
extern "C" {
#endif    

//_______________________________________________________________
/////////////// SCANER //////////////////////////////////////////
#define DB_NRF_NO_ERRORS                        0x00
#define DB_NRF_TIMEOUT_WAIT_ANSWER              0x01


#define PIPE_ADDRESS_PROG_0                     0x5A // pipe-  
#define PIPE_ADDRESS_PROG_1                     0x22
#define PIPE_ADDRESS_PROG_2                     0xA5
#define PIPE_ADDRESS_PROG_3                     0xDD
#define PIPE_ADDRESS_PROG_4                     0x96

#define SPV_MODE                                1
#define SCAN_MODE                               2
#define RELAY_MODE                              3

#define MAX_NUMBER_VALID_RELAY                  1 //        

/*
################################################################################
##            TYPEDEF
##############################################################################*/
typedef union {
  struct {
    uint8_t main;
    uint8_t reserve;
  };
  uint16_t pair;
}FREQ_PAIR;

typedef struct{
	uint8_t low;
	uint8_t high;
	uint8_t bfc;
}ENCRYPT_KEY;

typedef enum{
	ds_CheckPacketCrc,
	ds_UncoverPacket,
	ds_CalculateAnswer,
	ds_Exit,
}DECIPHER_STATE;

/*
################################################################################
##            EXTERN VARIABLES
##############################################################################*/
//_______________________________________________________________
///////////// SUPERVISOR ////////////////////////////////////////
extern WORDUM SNd;
extern uint8_t Mk_ChForAnswer;

extern uint8_t debug_RqPack[]; //     (SNd  ID)
extern uint8_t debug_RqLength;
extern uint8_t debug_AckPack[]; //
extern uint8_t debug_AckLength;
extern uint8_t debug_AnswPack[]; //
extern uint8_t debug_AnswLength;

//_______________________________________________________________
/////////////// SCANER //////////////////////////////////////////
extern WORDUM m2_PredictAnsw[];
extern ENCRYPT_KEY m2_KEY;
extern TWOBYTES m2_USWF;
extern TWOBYTES m2_DTM;
extern FREQ_PAIR m2_ChannelBlock[];
extern uint8_t m2_PipeAddrBlock[][5];
extern uint8_t CurDevNum;

extern WORDUM SNrl;
extern TWOBYTES USWF_RELAY;
extern uint8_t e_NumberOfValidRelaysInSystem;
extern uint8_t RelayFrequencyPairCode;
extern uint8_t ReservedLockoutStatus;
/*
################################################################################
##            PROTOTYPES
##############################################################################*/
//_______________________________________________________________
///////////// COMMON ////////////////////////////////////////////


//_______________________________________________________________
///////////// SUPERVISOR ////////////////////////////////////////
void cph_DownloadRequest(uint8_t _dm, uint8_t* _buf, uint8_t* _buf_length);
void cph_CalculateAckCrc(uint8_t* _unique_ack, uint8_t _pack_length, uint8_t _crc_position);
void cph_CalculateCrc(uint8_t* _buf, uint8_t _buf_length, uint8_t* _crc_buf);
BOOLEAN cph_CheckCrc(uint8_t _dm, uint8_t* _buf);
BOOLEAN cph_DecipherAck(uint8_t* _rx_buf, uint8_t* _answ_buf, uint8_t* _ch_for_answer, uint8_t* _status);
void cph_SaveGraftValues(void);
uint8_t cph_Uncover(uint8_t _fn, uint8_t _cover_byte, uint8_t* _unique_ack);
void cph_CalculatePredictAnsw(uint8_t* _unique_ack, WORDUM* _sn, uint8_t _fc, WORDUM* _predict_answ);
uint8_t cph_CalculateFreqChannel(uint8_t* _unique_ack, uint8_t* _open_mark_settings, ENCRYPT_KEY* _key);
void calculate_PipeAddr(WORDUM* _sn, TWOBYTES* _uswf, uint8_t* _pa);
void calculate_PipeAddrProg(uint8_t* _pa);
void calculate_DTM(uint8_t* _pa, TWOBYTES* _dtm);
void calculate_FreqChannelPair(uint8_t _bfc, FREQ_PAIR* _ch_pair);
void calculate_KEY(WORDUM* _sn, ENCRYPT_KEY* _key);
void ram_Copy(uint8_t* _in, uint8_t* _out, uint8_t _length);
bool CheckRegStatus(uint8_t _reg_type);

//_______________________________________________________________
/////////////// SCANER //////////////////////////////////////////
void cph_Service(void);
void cph_Service2(void);
uint8_t cph_GetRqId(void);
void cph_UpdateRequestBuf(uint8_t _dialog_mode, uint8_t* _rx_id, uint8_t _rx_length);
uint8_t cph_FreqChannelGet(void);
BOOLEAN cph_DecipherAnswer(uint8_t _dialog_mode, uint8_t* _id, uint8_t* _rx_buffer, uint8_t* _instruct);
BOOLEAN cph_CheckToValidInstruction(uint8_t* _dev_id, uint8_t* _instr);
void cph_GenAckCommon(uint8_t _dialog_mode, uint8_t* _unique_ack, uint8_t* _length);
void cph_CodingAckBytes(uint8_t* _unique_digit, TWOBYTES* DTM, ENCRYPT_KEY* _key, uint8_t _cmd, uint8_t _mark_power, uint8_t _hr, uint8_t* _unique_ack, uint8_t* _frequency_channel);
void cph_CodingAckBytesProg(uint8_t* _unique_digit, uint8_t* _sn_am, ENCRYPT_KEY* _key, TWOBYTES* _uswf_prog, uint8_t* _unique_ack, uint8_t* _frequency_channel);
void cph_GenerateRandomNuber(uint8_t* _sn_am, uint8_t* _mrc, uint8_t* _unique_digit);
void cph_LoadRgd(uint8_t* _unique_ack, uint8_t* _unique_digit);
uint8_t cph_Cover(uint8_t _fn, uint8_t _uncover_byte, uint8_t* _unique_ack);
void cph_AttachSettings(uint8_t _mark_power, uint8_t _hr, uint8_t* _oms);
void cph_GraftNewMark(void);
void cph_GraftProcedureReset(void);
void cph_DeleteMark(uint8_t _cell_number);
void cph_DeleteRelay(void);

BOOLEAN cph_CheckToRelay(void);
BOOLEAN cph_HandleRequestRelay(uint8_t _dialog_mode, uint8_t* _ack2);
uint8_t uf_CheckCoincidence(FlagStatus* _rvs, WORDUM* _buf_sn, uint8_t* _rx_sn);
void cph_GraftNewRelay(void);
uint8_t cph_GetNumberValidMarksInSystem(void);

void cph_DownloadRelayRequest(uint8_t* tx_buf, uint8_t* tx_buf_len);

#ifdef __cplusplus
}
#endif    
  
#endif
