
#include "nrf_common.h"
#include "nrf_GlobalService.h"
#include "nrf_subroutines.h"
#include "cph_Encrypt.h"
#include "y_eeprom.h"

//_______________________________________________________________
///////////// COMMON ////////////////////////////////////////////
//  ,   
FlagStatus F_TIMEOUT_MARK_SEARCH = RESET; //    
FlagStatus F_COMMUNICATION_MODE_LAUNCH = RESET; //    
FlagStatus F_FAST_NEXT_GLOBAL_STATE = RESET; //        
FlagStatus F_REPEAT_RELAY_REQUEST = RESET; //      
FlagStatus F_CHANGE_NRF_FREQUENCY = RESET; //     (  )
FlagStatus F_CommunicationFinish = RESET; //    
GLOBAL_STATE GlobalState = gs_Out; //    
MASTER_MODE GlobalCommunication = mm_Inactive; //   
WORDUM SNnrf[MAX_MARK_NUMBER] = {
  {0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00},{0x00,0x00,0x00,0x00}}; //     
RESULT_STRUCTURE TotalResult = {RESET, fcr_Undefined, 0x00}; //    
uint8_t EepromUpdatePosition = 0x00;
uint8_t rf_DialogMode = NRF_DIALOG_MODE_NORMAL; //     (, )
uint8_t nRF_CH[2] = {0x00,0x00}; //      
uint8_t nRF_RxBuffer[12] = {0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00}; //    
uint8_t nRF_RxLength = 0x00; //   


//_______________________________________________________________
///////////// RELAY COMMUNICATION ///////////////////////////////
uint8_t LinkAttemptCount = 0; //       (    )
LINK_RESULT LinkResult = lr_OK_Successful; //        
CHANNEL_NUMBER ChannelNumber = {0x00,0x01}; //   ,        ,
COMMUNICATION_STATE TxComState;
DIALOGUE_STEP DialogueStep; //     
FREQ_PAIR relay_ChannelBlock; //      
uint8_t rf_RelayPipeAddrBlock[5]; //   pipe- 
uint8_t nRF_TxBuffer[4] = {0x00,0x00,0x00,0x00}; //    
uint8_t nRF_TxLength = 0x00;
uint8_t nRF_RxAck1[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
uint16_t Count_WaitRepeatRelayRequest = 0x0000; //          

//_______________________________________________________________
/////////////// SCANER //////////////////////////////////////////
//    "Scaner"
//const uint8_t rf_RQNB[2] = {1, 4};
const uint8_t rf_ACKNB[2] = {8, 12};
N24_DIALOGUE_STATE N24DialogueState; //     
uint8_t RxDeviceID = 0x00; //    ID ,      
uint8_t MarkInstruction[2] = {0x00, 0x00}; //     2.4
uint8_t Count_nRFChangeFreqChannel = 0x00; //   
uint8_t nRF_RequestChannel = 0x00; //    (0, 1)
uint8_t nRF_AckBuffer[12] = {0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00}; //   
uint8_t rf_AckLength = 0x00; //      
uint32_t Count_TimeOutMarkSearch = 0x00000000; //       
FlagStatus SA_GRAFT_IS_ACTIVE = RESET; //     ,          


NRF_CTRL NRFCtrl = {0x0000, 0x0000, 0x0000, 0x00};

//######################################################
//##                
//######################################################

//==============================================================================
//      2.4
//       
//     .
//  : _mm -    
void GC_Launch(MASTER_MODE _mm)
{
  F_COMMUNICATION_MODE_LAUNCH = SET;
  GlobalCommunication = _mm;
}
//==============================================================================
//   ,     ID .  
//    GC_Launch(mm_ScanProgMark)
void GC_SetCell(uint8_t _cell_number)
{
  if(_cell_number < MAX_MARK_NUMBER)
  {
    NRFCtrl.MarkCurGraftCell = _cell_number;
  }
  else{NRFCtrl.MarkCurGraftCell = 0;}
}
//==============================================================================
uint8_t GC_GetCell(void)
{
  return(NRFCtrl.MarkCurGraftCell);
}

//==============================================================================
//  -   2.4
void nRF_GlobalService(void)
{
  //________________________________________________
  //  
  if(F_COMMUNICATION_MODE_LAUNCH == SET)
  {
    F_COMMUNICATION_MODE_LAUNCH = RESET;
    switch(GlobalCommunication)
    {
      //////////   ,   //////////////////
    case mm_ScanNorm:
      //////////   ,    //////
    case mm_ScanProgMark:
      /////////    ////////////////////////////////
    case mm_ScanProgRelay:     
      GlobalState = gs_InitScaner;
      break;
      
      //////////    "" //////////////////
    case mm_RelayLock:
      //////////    "" ////////////
    case mm_RelayUnlock:
      GlobalState = gs_InitRelay;
      break;
    }
  }
  
  //___________________________________________
  //  
  do
  {
    F_FAST_NEXT_GLOBAL_STATE = RESET;
    switch(GlobalState)
    {
      //__________________________________________________________________________
      //      
    case gs_InitScaner:
      rf_DialogMode = nrf_GetDialogMode(&GlobalCommunication); //      RxCommunication()
      nrf_ScanSetSpecialSettings(rf_DialogMode); //   ,  
      nRF_ReInit24();                   //  
      nRF_LoadChannel(&m2_ChannelBlock[rf_DialogMode], &(m2_PipeAddrBlock[rf_DialogMode][0])); //    ( ,   )
      nRF_Receive(rf_DialogMode);       //       
      cph_Service2();                   //   
      result_Reset();                   //     
      IndicateMarkSearch(1);            //  
      //   
      if(GlobalCommunication == mm_ScanNorm)
      {
        nRF_MarksStatus_Reset();
        nRF_MarksGrafted_MaskUpdate(); //        
      }
      if(GlobalCommunication == mm_ScanProgMark)
      {
        nRF_MarksGrafted_MaskUpdate();
      }
      GlobalState = gs_WaitConnect;
      break;
      
      //__________________________________________________________________________
      //    ,     
    case gs_WaitConnect:
      cph_Service();
      nRF_RxConnection();               //       
      
      //   
      //  nRF_RxConnection()  ,        .
      //    nRF_RxConnection()  ,      
      if(TotalResult.flag == RESET)
      {
        if(F_TIMEOUT_MARK_SEARCH == SET)
        {
          F_TIMEOUT_MARK_SEARCH = RESET;
          TotalResult.flag = SET; 
          TotalResult.code = scan_SearchTimeOut;      
          TotalResult.data = 0x00;
          SA_GRAFT_IS_ACTIVE = RESET;
          //     ,     .
          nrf_NextChannel(); //  
          GlobalState = gs_Innactive; //   power down
          F_FAST_NEXT_GLOBAL_STATE = SET;
        }
        else
        {
          nrf_ChangeFrequencyChannel();
        }
        
        //       
        if(F_REPEAT_RELAY_REQUEST == SET)
        {
          F_REPEAT_RELAY_REQUEST = RESET;
          TotalResult.flag = SET; 
          TotalResult.code = scan_GraftSuccessRelay; 
          TotalResult.data = 0x00; //     
          GlobalState = gs_Innactive; //   power down
          F_FAST_NEXT_GLOBAL_STATE = SET;            
        }
      }
      else
      {
        GlobalState = gs_Innactive; //    
        F_FAST_NEXT_GLOBAL_STATE = SET;
      }
      break; 
      
      
      //__________________________________________________________________________
      //     
    case gs_InitRelay:
      nrf_SpvSetSpecialSettings();
      nRF_ReInit24();
      nRF_LoadChannel(&relay_ChannelBlock, rf_RelayPipeAddrBlock);
      SA_GRAFT_IS_ACTIVE = RESET;
      nRF_LinkCycle(); //        
      GlobalState = gs_Innactive; 
      F_FAST_NEXT_GLOBAL_STATE = SET;
      break;
      
      
      //__________________________________________________________________________
      //     "power down"
    case gs_Innactive:
      nrf_SetMarkSearchTimeout(0);   //    
      cph_Service2();
      TRX_CE(0);
      Flag_InterruptTRX = RESET; 
      nRF_StatusReset();            //   
      nRF_PowerDown();              //  PD, PD  , ..         Power Down ( )
      IndicateMarkSearch(0);        //  
      GlobalState = gs_Out;         //   
      GlobalCommunication = mm_Inactive; //   ""
      eeprom_Service();             //  -    EEPROM,  
#ifdef db_ChipCom_uart
      terminal_Result();            //      
#endif 
      break;      
      
      //__________________________________________________________________________
      //  
    case gs_Out:
      
      break;
    }
  }while(F_FAST_NEXT_GLOBAL_STATE == SET);
}



//=============================================================================
//    (.  .)     
uint8_t nrf_GetDialogMode(MASTER_MODE* _mm)
{
  if((*_mm == mm_RelayUnlock) ||(*_mm == mm_RelayLock) || (*_mm == mm_ScanNorm))
  {
    return(NRF_DIALOG_MODE_NORMAL); //  
  }
  else // mm_ScanProgMark || mm_ScanProgRelay
  {
    return(NRF_DIALOG_MODE_PROGRAMM); //  
  }
}

//==============================================================================
//    .
//  pipe- (       )
//        ( )
//  : _dialog_mode - ,      .
void nRF_LoadChannel(FREQ_PAIR* _channel_block, uint8_t* _pipe_block)
{
  TRX_CE(0);
  ////      
  nRF_CH[0] = _channel_block->main;       //   
  nRF_CH[1] = _channel_block->reserve;    //    
  nRF_SetRxPipeAddress(_pipe_block, 5);   //[0x2A]  RX   (SW & SNmk)
  nRF_SetTxPipeAddress(_pipe_block, 5);   //     
}








//####################################################################
//##################################################################
//##                  RELAY SERVICE
//##################################################################
//####################################################################

//==============================================================================
//     ,   .   
//   ,   .
void nrf_SpvSetSpecialSettings(void)
{
  //   
  if(GlobalCommunication == mm_RelayLock)
  {ReservedLockoutStatus = LOCKOUT_EN;}
  else if(GlobalCommunication == mm_RelayUnlock)
  {ReservedLockoutStatus = LOCKOUT_DIS;}
  
  nrf_SetMarkSearchTimeout(0); //          
}


//==============================================================================
//     (  )
void nRF_LinkCycle(void)
{
  FUNCTIONAL_CODE link_cycle_result;
  
  link_cycle_result = nRF_LinkFrameBlock(RELAY_CONNECT_ATTEMPT);
  switch(link_cycle_result)
  {
  case spv_ConnectSuccess:
    TotalResult.flag = SET;
    TotalResult.code = relay_ConnectSuccess;
    TotalResult.data = 0x00; 
    break;
    
    // case spv_ConnectFailure:
    //	TotalResult.flag = SET; 
    //	TotalResult.code = relay_ConnectFailure;      
    //	TotalResult.data = 0x00;
    //break;
    
  default:
    TotalResult.flag = SET; 
    TotalResult.code = relay_ConnectFailure;      
    TotalResult.data = 0x00;
    break;
  }
}

//==============================================================================
//     
//  : _connect_attempt -     
//  : spv_ConnectFailure -      
//                  spv_ConnectSuccess -   
FUNCTIONAL_CODE nRF_LinkFrameBlock(uint8_t _connect_attempt)
{
  uint8_t i;
  FUNCTIONAL_CODE frame_block_result = spv_ConnectFailure;
  
  //    
  // --\\--\\-- 
  for(i=0;i<_connect_attempt;i++)
  {
    if((i%5) == 0x00)
    {
      IndicateRelayConnect(1);
    }
    if(nRF_LinkFrame() == spv_ConnectSuccess)
    {
      IndicateRelayConnect(0);     
      frame_block_result = spv_ConnectSuccess;
      break;
    }
    else
    {
      IndicateRelayConnect(0);
    }
  }
  
  Flag_InterruptTRX = RESET;
  nRF_StatusReset();
  nRF_PowerDown();
  return(frame_block_result);
}

//==============================================================================
//  
//  : _link_state -  ,  result     
//  lfr_ConnectSuccess -     ,  .  
//  lfr_GraftSuccess -   
//  lfr_ConnectFailure -   
FUNCTIONAL_CODE nRF_LinkFrame(void)
{
  FUNCTIONAL_CODE link_frame_result = spv_ConnectFailure;
  //  "" .   
  //      1500       PowerDown   Standby1
  //   3500 ,  , ..   
#ifdef db_request_relay_pin
  LED_TRX(1);
#endif
  nRF_PowerUp(POWER_UP_TX);
#ifdef db_request_relay_pin
  LED_TRX(0);
#endif

  nrf_bsp_delay_ms(4); //  ,          3.5 ms
  
  // 1.      ,           PowerDown
  // 2.      nRF_TxConnection()   
  //   PowerDown       .  
  //   (      )
  //      Standby 
  LinkAttemptCount = NUMBER_BASE_FREQUENCY;
  while(LinkAttemptCount)
  {
    //uart_PrintString("<d>");
    //uart_PrintDigit(LinkAttemptCount);
    LinkResult = nRF_TxConnection(); //     
    switch(LinkResult)
    {
      //________________________________________________________________________________
      //         
    case lr_ER_AbsentAck1:        //     Request-
    case lr_ER_DecryptionFailure: //     CRC! 
      {
        ptc_ChangeChannel(&ChannelNumber);  //   
        LinkAttemptCount--;         //   
      }
      break;  
      
      //________________________________________________________________________________
      //          ( 1 .)
    case lr_OK_Successful:        //      
      {
        //    
        link_frame_result = spv_ConnectSuccess;
        LinkAttemptCount=0; 
      }
      break; 
      
      //________________________________________________________________________________
      //          
    case lr_ER_AbsentAck2:        //     Answer-
      //        
      LinkAttemptCount--;         //   
      break; 
      
      //________________________________________________________________________________
      //  
    case lr_ER_HardwareFailure:   //      ( )
      LinkAttemptCount=0; 
      break; 
      
      //_______________________________________________________________________________
      //    
    case lr_OK_Grafted:           //   ,     
      {
        link_frame_result = spv_GraftSuccess;
        LinkAttemptCount=0; 
      }	
      break; 
      
    default: LinkAttemptCount=0; break;
    } 
  }
  //nRF_PowerDown();
  return(link_frame_result);
}



//##################################################################
//##              
//##################################################################
//     . 
//==============================================================================
//  ,       
LINK_RESULT nRF_TxConnection(void)
{
  LINK_RESULT ComResult = lr_ER_AbsentAck1; //  
  uint8_t UnusedByte = 0x00;                //    ,      
  
  F_CommunicationFinish = RESET;            //  
  TxComState = cs_LoadRequest;              //   
  do
  {
    switch(TxComState)
    {
      //##############################################################################
      //##                        
      //##############################################################################
    case cs_LoadRequest:
      {
        // <170 >    
#ifdef db_request_relay_pin
        LED_TRX(1);
#endif
        //    
        nRF_Frequency(nRF_CH[ChannelNumber.current]);   
        nRF_FlushTRX();                                  
        cph_DownloadRelayRequest(nRF_TxBuffer, &nRF_TxLength); //  
        nRF_TxPayloadWrite(nRF_TxBuffer, nRF_TxLength); //[0xA0]     TX
#ifdef db_request_relay_pin
        LED_TRX(0);
#endif
        nRF_StatusReset();                       //[0x27]  
        DialogueStep = ds_Request;               //    - 
        TxComState = cs_Transmite;               //   
      }
      break;
      
      //##############################################################################
      //##                       
      //##############################################################################
      //    Standby-1,    
      //    POWER_UP     Power down 
      //   Standby-1 (POWER_UP) 
    case cs_Transmite:
      {
#ifdef db_request_relay_pin
        LED_TRX(1);
#endif
        ptc_Pulse();
#ifdef db_request_relay_pin
        LED_TRX(0);
#endif
        WaitTimeOut_Launch(D_5ms); //    
        TxComState = cs_WaitAck;   //  
      }
      break;
      
      //##############################################################################
      //##                       
      //##############################################################################
      ///////////////////// WAIT ACK ///////////////////////////////////////////
      //      ,    
      //           
      //    nRF24L01:
      //  - MAX_RT (   ,     ),
      //  - TX_DR ( ,   ),
      //  - TRX_DR ( ,   )
      //       200  (130 , 60  )
      // MAX_RT   1700  (   )
      // MAX_RT   . 
      //      ,    ,
      //         ( , ) 
    case cs_WaitAck:
      {
        nrf_wait_irq_event();
        if(WaitTimeOut_GetFlag() == RESET)
        {
          if(Flag_InterruptTRX == SET)
          {
            Flag_InterruptTRX = RESET;
            WaitTimeOut_Launch(0);
            TxComState = cs_CheckAck; //  ACK  
          }
        }
        else
        { 
#ifdef db_request_relay_pin
          LED_TRX(1);
#endif
          // !    .   
          // 2.4  ,      .
          ComResult = lr_ER_HardwareFailure; //  ,  
          TxComState = cs_Exit;
#ifdef db_request_relay_pin
          LED_TRX(0);
#endif
        }
      }
      break;   
      
      //##############################################################################
      //##                        (CHECK ACK)
      //##############################################################################
      //       
    case cs_CheckAck:
      {
        nRF_GetIrqStatus(); //   ( 20 )
        
        //___________________________________________________________________
        ///////// 1   ////////////////////////////////////////////
        //     ,  ACK   (1 ) 
        //   ACK   (2 )
        if(DialogueStep == ds_Request)
        {
          if(irq_GetState(irq_TRX_DR) == SET) //  ACK   ,  irq_TX_DR = 1   , irq_RX_DR = 1  C   
          {
#ifdef db_request_relay_pin
            LED_TRX(1);
#endif
            nRF_RxPayloadRead(nRF_RxAck1, rf_ACKNB[0]); 
            nRF_StatusReset();
            
            if(cph_DecipherAck(nRF_RxAck1, nRF_TxBuffer, &Mk_ChForAnswer, &UnusedByte) == BOOL_TRUE)
            {
              /////////     ///////////
              //      
              nRF_Frequency(Mk_ChForAnswer); //[0x25]
              nRF_TxPayloadWrite((uint8_t*)nRF_TxBuffer, ANSWER_PACKET_LENGTH); //[0xA0]
#ifdef db_request_relay_pin
              LED_TRX(0);
#endif
              nRF_StatusReset(); //[0x27]  
              
              /////////     /////////////////////////
              //   retransmit,      
              //   .      , 
              //       ,      
              //  .         
              //    1800     !
              nrf_bsp_delay_ms(2); //2-3,5 
              
              DialogueStep = ds_Answer; //     
              TxComState = cs_Transmite;
            }
            else
            { // !   ,    
              ComResult = lr_ER_DecryptionFailure;
              TxComState = cs_Exit;
            }
          }
          ////////  ACK- /////////////////////////////////
          // if((irq_GetState(irq_MAX_RT) == SET)||   //   , ack    
          //    (irq_GetState(irq_TX_DR) == SET))		  //     
          else 
          {
            /////////   RETRANSMIT ///////////
            // !     () 
            //  ACK   ().     .
            //    Standby
            ComResult = lr_ER_AbsentAck1;
            TxComState = cs_Exit;
          }
        }  
        //__________________________________
        ///////// 2   ///////////
        else // DialogueStep == ds_Answer
        {
          // POWER DOWN   ACK1  ,    () 
          //     .     ACK2, 
          //     .
          // nRF_PowerDown(); //     Power Down      Receive
          if(irq_GetState(irq_TX_DR) == SET)
          {
            // !        ACK  .
            //       ACK.
            //       ACK
            
            // !   ACK     
            //       .           
            //  ,     ACK2   
            //  .   ,     
            //  ,          
            //      ,       
            ComResult = lr_OK_Successful; 
          }
          else
          {
            // !       
            //    ACK.    ,
            //          2.4  
            //  2.4.   ,  Answer-     2.4
            //        ,   ACK2
            //  2.4         , 
            //           .
            //   ,  ,     , 
            //    (  ACK2).   
            //  ACK1,     .     
            // ,        ACK2.
            // .       ACK2  , 
            //           ACK2.           
            ComResult = lr_ER_AbsentAck2;
          }
          TxComState = cs_Exit;
        }  
      }    
      break;
      
    case cs_Exit:
      {
        nRF_StatusReset();
        F_CommunicationFinish = SET; //   
      }
      break;
      
    default: break;		
    } // switch()
  }while(F_CommunicationFinish == RESET); //   switch,    	
  
  return(ComResult);
}

//===============================================================================
//     .
//         
//            
//  : ChNum_Current - ,     
//                  ChNum_Previous - ,     
void ptc_ChangeChannel(CHANNEL_NUMBER* _channel_number)
{
  //    
  //         
  if(_channel_number->current == _channel_number->previous)
  {
    _channel_number->current = 0x01;
    _channel_number->previous = 0x00;
  }
  _channel_number->previous = _channel_number->current;
  _channel_number->current++;
  if(_channel_number->current >= NUMBER_BASE_FREQUENCY)
  {
    _channel_number->current = 0x00;
  }
}





//####################################################################
//##################################################################
//##                  SCANER 
//##################################################################
//####################################################################
// nRF_RequestChannel -  
//==============================================================================
//          
void nrf_ScanSetSpecialSettings(uint8_t _dm)
{
  if(_dm == NRF_DIALOG_MODE_PROGRAMM)
  {
    if(SA_GRAFT_IS_ACTIVE == SET)
    {	//             
      nrf_SetMarkSearchTimeout(TIME_OUT_AFTER_MARK_GRAFT);
    }
    else
    {
      //cph_GraftProcedureReset(); //     
      nrf_SetMarkSearchTimeout(TIME_OUT_MARK_GRAFT); //      ,           
    }
  }
  else //       
  {
    SA_GRAFT_IS_ACTIVE = RESET; 
    nrf_SetMarkSearchTimeout(TIME_OUT_MARK_SEARCH);
  }
}

//=============================================================================
//     .
//  F_CHANGE_NRF_FREQUENCY     
void nrf_ChangeFrequencyChannel(void)
{
  ///////////// CHANGE FREQUENCY TIMEOUT ////////////// 
  if(rf_DialogMode == NRF_DIALOG_MODE_PROGRAMM) 
  {
    if(F_CHANGE_NRF_FREQUENCY == SET)
    {
      F_CHANGE_NRF_FREQUENCY = RESET;
      nrf_NextChannel(); //    
      nRF_Receive(rf_DialogMode);
    }
  }
}

//==============================================================================
//    nRF_RequestChannel
void nrf_NextChannel(void)
{
  nRF_RequestChannel++; //      
  if(nRF_RequestChannel >= NUMBER_BASE_FREQUENCY)
  {
    nRF_RequestChannel = 0x00;
  }
}




//==============================================================================
//   ,       
void nRF_RxConnection(void)
{
  ////////    /////////
  // !       
  //     .
  // SA_COM        
  //   .       
  //  ,  SA_COM  F_FastNextState  .  
  //   F_CommunicationFinish     .
  //if(SA_COM == RESET)
  //{
  
  if(Flag_InterruptTRX == SET)
  {
    Flag_InterruptTRX = RESET;
    F_CommunicationFinish = RESET;            //  
    //SA_COM = SET;                           //   
    N24DialogueState = n24ds_CheckRequest;
  }
  else
  {
    return;
  } //  
  //}  
  
  ///////////   //////////////
  do
  {
    switch(N24DialogueState)
    {
      //#########################################################################
      //                          GET REQUEST
      //#########################################################################
    case n24ds_CheckRequest: 
      {
        TotalResult.code = scan_ConnectFailure;
        nRF_GetIrqStatus();      //  
#ifdef db_nrf_rx_operate_pin
        LED_TRX(1);
#endif
        nRF_FloatDelayForMarkRetransmite();     //1800  250      ( retransmit)							//       (      retransmin  3 )
#ifdef db_nrf_rx_operate_pin
        LED_TRX(0);
#endif
        TRX_CE(0);	                            //      Standby-1,  Power Down,        RX-,    Power Down  Stanby-1  1500 
        nRF_StatusReset();                      //  
        Flag_InterruptTRX = RESET;              //   
        
        //////////     ////////// 
        if(irq_GetState(irq_RX_DR) == SET)	    //  ?
        { //////////////////////////////////////////////////////////////////////
          //   
          nRF_RxLength = nRF_RxLengthGet();
          if(nRF_RxLength <= 4)
          { 
            nRF_RxPayloadRead(nRF_RxBuffer, nRF_RxLength); //rf_RQNB[rf_DialogMode] //   
            
            //////////////////////////////////////////////////////////////////////
            //   
            //  ID   RGD_MarkRequestCounter    .
            //  ,      
            //    .      ,   
            cph_UpdateRequestBuf(rf_DialogMode, nRF_RxBuffer, nRF_RxLength);//     
            
            //     ,   ACK2
            //  ID    RGD_MarkRequestCounter,    
            if(cph_CheckToRelay() == BOOL_TRUE)  
            {
              //_____CHECK_SELECTOR__________________________ 2015/07/09_
              //  ,         
              //      64 -  
              if(GlobalCommunication == mm_ScanProgMark)
              {
                N24DialogueState = n24ds_Exit; //    
                break; 
              }
              
              if(cph_HandleRequestRelay(rf_DialogMode, nRF_AckBuffer) == BOOL_TRUE)
              { //    ,      ACK
                nRF_AckPayloadWrite(nRF_AckBuffer, 4); 
                
                nRF_Frequency(cph_FreqChannelGet());//   
                nRF_FlushRX();                      //  RX FIFO
                TRX_CE(1);					          			//  RX-
                WaitTimeOut_Launch(D_6ms);                   //     
                N24DialogueState = n24ds_WaitAnswer;//                      
              }
              else
              { //      
                N24DialogueState = n24ds_Exit;
              }
            }
            else //    ,      
            {
              //_____CHECK_SELECTOR__________________________ 2015/07/09_
              //  ,       
              //      65 -  
              if(GlobalCommunication == mm_ScanProgRelay)
              {
                N24DialogueState = n24ds_Exit; //    
                break; 
              }
              nRF_Frequency(cph_FreqChannelGet());  //   
              nRF_FlushRX();                        //  RX FIFO
              TRX_CE(1);			    //  RX-
              WaitTimeOut_Launch(D_6ms);            //     
              N24DialogueState = n24ds_WaitAnswer;  //                      
            }
          }
          else
          { //    ,  
            N24DialogueState = n24ds_Exit;
          }
        }
        else
        {
          N24DialogueState = n24ds_Exit;                //   , 
        } 
      }
      break;	
      
      //#########################################################################
      //                          WAIT ANSWER
      //#########################################################################
    case n24ds_WaitAnswer:
      {
        nrf_wait_irq_event();
        if(WaitTimeOut_GetFlag() == RESET)	//        
        {
          if(Flag_InterruptTRX == SET)
          {	
            WaitTimeOut_Launch(0);                        //   
            nRF_GetIrqStatus();                           //  
            #ifdef db_nrf_rx_operate_pin
            LED_TRX(1);
            #endif        
            nRF_FloatDelayForMarkRetransmite();           // 1800      ( retransmit)							//       (      retransmin  3 )
            #ifdef db_nrf_rx_operate_pin
            LED_TRX(0);
            #endif   
            TRX_CE(0);													          //      Standby-1,  Power Down,        RX-,    Power Down  Stanby-1  1500 
            nRF_StatusReset();                            //  
            Flag_InterruptTRX = RESET;                    //            
            N24DialogueState = n24ds_Exit;                //    ,  
            if(irq_GetState(irq_TRX_DR) == SET)           // irq_RX_DR=1  ; irq_TX_DR=1         
            {		
              nRF_RxLength = nRF_RxLengthGet();
              if(nRF_RxLength == 4)
              {
                nRF_RxPayloadRead(nRF_RxBuffer, 4);         //   
                RxDeviceID = cph_GetRqId();                 //  ID 
                if(cph_DecipherAnswer(rf_DialogMode, &RxDeviceID, nRF_RxBuffer, MarkInstruction) == BOOL_TRUE)
                {
                  // MarkInstruction[0] -        
                  // MarkInstruction[1] -       
                  if(rf_DialogMode == NRF_DIALOG_MODE_NORMAL)
                  {//          (  )
                    if(RxDeviceID == ID_MARK) //   ID 
                    {
                      N24DialogueState = n24ds_MarkFixed;
                    }
                  }
                  else
                  { // MarkInstruction[1] -       (0xFF) 
                    //         
                    if((MarkInstruction[0]&0xFE) == CL_DEVICE_GRAFT)
                    {
                      N24DialogueState = n24ds_DeviceGraft;
                    }
                  }
                }
              }
            }
          }		 
        }
        else
        { //    
          WaitTimeOut_SetFlag(RESET);                     //   
          N24DialogueState = n24ds_Exit;                  //  
        }
      }	
      break; 
      
      //#########################################################################
      //                          MARK FIXED
      //#########################################################################          
    case n24ds_MarkFixed:
      {
        //    
        TotalResult.data = GetMarkBatteryStatus(MarkInstruction); //  
        nRF_MarksStatus_Update(MarkInstruction); //           
        //    ,    
        if(nRF_Marks_CheckAllToOnline() == true)
        {
          TotalResult.code = scan_ConnectSuccess; 
          TotalResult.flag = SET; 
        }
        
        //    
        #ifdef db_nrf_rx_operate_beep
        PiezoSignalConnect(); //   
        #endif
        
        //////////////////////////////////////////////////////////////////////////
        //   
        //    -      
        // mark_CommandInterpreter(MarkInstruction);
        //       
        N24DialogueState = n24ds_Exit;
      }
      break;  
      
      //#########################################################################
      //                          EXIT (END COMMUNICATION PROCEDURE)
      //#########################################################################        
    case n24ds_Exit:
      {
        ////////////////////////////////////////////////////////////////////////
        //    
        // !        
        TRX_CE(0);	
        Count_nRFChangeFreqChannel = 0x00;          //   
        Flag_InterruptTRX = RESET;
        nRF_Frequency(nRF_CH[nRF_RequestChannel]);	//  
        nRF_FlushTRX();			                //  TX    RX
        
        ////////////////////////////////////////////////////////////////////////
        //  ACK /////
        cph_GenAckCommon(rf_DialogMode, nRF_AckBuffer, &rf_AckLength);	//     
        nRF_AckPayloadWrite(nRF_AckBuffer, rf_AckLength);       //    
        nRF_StatusReset();                                      // 
        TRX_CE(1);                                              // 
        //SA_COM = RESET; //   
        N24DialogueState = n24ds_Out;
        F_CommunicationFinish = SET; //   
      }	
      break;		
      
      //#########################################################################
      //                          MARK GRAFT
      //#########################################################################        
    case n24ds_DeviceGraft:
      {
        switch(RxDeviceID)
        {
        case ID_MARK:
          //////////////   ////////////////////
          cph_GraftNewMark(); //      
          #ifdef db_nrf_rx_operate_beep
          PiezoSignalGraft(); // 
          #endif
          //////////////   /////////////////////
          TotalResult.flag = SET; 
          TotalResult.code = scan_GraftSuccess; 
          TotalResult.data = NRFCtrl.MarkCurGraftCell; //      
          SA_GRAFT_IS_ACTIVE = SET;
          break;
          
        case ID_RELAY:
          cph_GraftNewRelay();             //       
          #ifdef db_nrf_rx_operate_beep
          PiezoSignalGraft(); // 
          #endif
          //        ,    
          //   ACK2      ,     
          //  mm_Inactive
          //   ,   ,    
          
          nrf_RepeatRelayRequestTimeout(WAIT_REPEAT_RELAY_REQUEST); //          
          //        ..   !!
          nrf_SetMarkSearchTimeout(0); //      
          //////////////   /////////////////////
          //TotalResult.flag = SET; 
          //TotalResult.code = scan_GraftSuccessRelay; 
          //TotalResult.data = 0x00; //     
          break;
        }  
        /////////////     /////////////
        N24DialogueState = n24ds_Exit; 
      }
      break;  
      
    default:
      {
        N24DialogueState = n24ds_Out;    
      }	 
      break;
    }
  }while(F_CommunicationFinish == RESET); //   switch,      
}

//==============================================================================
//      
//  : _mi -    
//                 _mi[0] - - ,       0-   _mi[0] 
//                 _mi[1] -  ,         _mi[0]
//  :        0-  1-     
//       3- .
uint8_t GetMarkBatteryStatus(uint8_t* _mi)
{
  return(((_mi[0]<<3)&0x08)|((_mi[1]+1)&0x03));
}


//==============================================================================
//    
void nRF_MarksStatus_Update(uint8_t* _mi)
{
  uint8_t mark_number = _mi[1]&0x0F; //    
  uint8_t mark_bat_status = _mi[0]&0x01; //     
  //____________________________________________________________________________
  //         
  NRFCtrl.mark_online_status |= (1<<mark_number);
  
  //____________________________________________________________________________
  //        
  if(mark_bat_status != 0) //  
  {
    NRFCtrl.mark_battery_status |= (1<<mark_number); //  "1" -  
  }
  else
  {
    NRFCtrl.mark_battery_status &= (~(1<<mark_number)); //  "0" -  
  }
}   
//==============================================================================
void nRF_MarksStatus_Reset(void)
{
  NRFCtrl.mark_online_status = 0x0000; //    ( )
  NRFCtrl.mark_battery_status = 0x0000; //     ( )
}  
//==============================================================================
//     
void nRF_MarksGrafted_MaskUpdate(void)
{
  uint8_t i;
  
  NRFCtrl.mark_graft_config = 0x0000;             //      
  for(i=0;i<MAX_MARK_NUMBER;i++)	//     (     SN),          n24_MarkEnableCondition (  )
  {
    if(ram_ItIsZero(SNnrf[i].E8, 3) == false) //    0,     
    {
      NRFCtrl.mark_graft_config |= (1<<i);
    }
  }
}
//==============================================================================
//     
bool nRF_Marks_CheckAllToOnline(void)
{
  if(NRFCtrl.mark_graft_config == NRFCtrl.mark_online_status)
    {return(true);}
  else{return(false);}
}




//######################################################	
//	       
//######################################################

//==============================================================================
//        .    
//   4 .        
//      ,      
//  ,  ,        
void nRF_FloatDelayForMarkRetransmite(void) 
{
  nrf_bsp_delay_ms(2); //2 ,   2,5 
}

//==============================================================================
//   
void nRF_Receive(uint8_t _dialog_mode)
{
  TRX_CE(0); 
  Count_nRFChangeFreqChannel=0x00;	     //     
  Flag_InterruptTRX = RESET;                 //        
  nRF_Frequency(nRF_CH[nRF_RequestChannel]); // [0x25] Sets the frequency channel nRF24L01 operates on
  nRF_Power(NRF_SYSTEM_POWER);     	     // [0x26] 2 Mbps, - 0 dBm   ()		
  nRF_FlushTRX();                            //   TX  RX 
  cph_GenAckCommon(_dialog_mode, nRF_AckBuffer, &rf_AckLength);//  ,      
  nRF_AckPayloadWrite(nRF_AckBuffer, rf_AckLength); //      0
  nRF_StatusReset();                         // [0x27]  
  nRF_PowerUp(POWER_UP_RX);                  // [0x20]   
  TRX_CE(1);                                 //  
  
#ifdef db_ChangeNrfFrequency_uart
  //uart_PrintSymbol(CARRIAGE_RETURN);
  uart_PrintString(" Frq");
  uart_PrintDigit(nRF_RequestChannel);
#endif
}

//==============================================================================
//          
void TRX_CE(uint8_t _x)
{
  if(_x == 1)
  {
    nrf_chip_enable();
  }
  else
  {
    nrf_chip_disable();
  }
}

//==============================================================================
void result_Reset(void)
{
  TotalResult.flag = RESET;
  TotalResult.code = fcr_Undefined; 
  TotalResult.data = 0x00;
}

//################################################################
//##           TIMEOUTS MARK SEARCH AND RELAY DELAY
//################################################################

//==============================================================================
//    
void nrf_SetMarkSearchTimeout(uint32_t _msto)
{
  Count_TimeOutMarkSearch = _msto;
  F_CHANGE_NRF_FREQUENCY = RESET;
  F_TIMEOUT_MARK_SEARCH = RESET;
}
//==============================================================================
//      
void nrf_RepeatRelayRequestTimeout(uint16_t _rrrt)
{
  Count_WaitRepeatRelayRequest = _rrrt;
  F_REPEAT_RELAY_REQUEST = RESET;
}
//=============================================================================
//       
void nrf_CountModeTimeOut(void)
{
  //   
  if(Count_TimeOutMarkSearch>0)
  {
    Count_TimeOutMarkSearch--;
    if(Count_TimeOutMarkSearch==0)
    {
      //   "  "
      F_TIMEOUT_MARK_SEARCH = SET;
    } 
    else
    { //   ,  3   
      if(Count_TimeOutMarkSearch%TIME_OUT_CHANGE_FREQUENCY == 0)
      {
        F_CHANGE_NRF_FREQUENCY = SET;
      }
    }
  }
  
  //      
  if(Count_WaitRepeatRelayRequest>0)
  { 
    Count_WaitRepeatRelayRequest--;
    if(Count_WaitRepeatRelayRequest==0)
    { 
      F_REPEAT_RELAY_REQUEST = SET;
    }    
  }
}
//########################################################
//##            
//########################################################
//     - 
FlagStatus F_WAIT_TIMEOUT = RESET;
uint16_t count_WaitTimeOut = 0x0000;
//==============================================================================
//    
void WaitTimeOut_Launch(uint16_t _to_ms)
{
  //  
  if(_to_ms != 0)
  {
    F_WAIT_TIMEOUT = RESET;
    count_WaitTimeOut = _to_ms;
  }
  else //  
  {
    F_WAIT_TIMEOUT = RESET;
    count_WaitTimeOut = 0x0000;
  }
}
//==============================================================================
//    
void WaitTimeOut_Count(void)
{
  if(count_WaitTimeOut > 0)
  {
    count_WaitTimeOut--;
    if(count_WaitTimeOut == 0)
    {
      F_WAIT_TIMEOUT = SET;
    }
  }
}
//==============================================================================
//   
FlagStatus WaitTimeOut_GetFlag(void)
{
  return(F_WAIT_TIMEOUT);
}
//==============================================================================
//   
void WaitTimeOut_SetFlag(FlagStatus _fs)
{
  F_WAIT_TIMEOUT = _fs;
}

//########################################################
//##              AUXILIRY FUNCTIONS
//########################################################
//==============================================================================
//==============================================================================
//     
BOOLEAN ram_ItIsEqual(uint8_t* _a, uint8_t* _b, uint8_t _length)
{
  uint8_t i;
  for(i=0;i<_length;i++)
  {
    if(_a[i] != _b[i])
    {
      return(BOOL_FALSE);
    }
  }
  return(BOOL_TRUE);
}

//==============================================================================
//    
// IN: _in - 
//     _length -       "0"
bool ram_ItIsZero(uint8_t* _in, uint8_t _length)
{
  uint8_t i;
  for(i=0;i<_length;i++)
  {
    if(_in[i] != 0x00)
    {
      return(false);
    }
  }
  return(true);
}


//==============================================================================
//   - -.  -  "0"
void LED_TRX(uint8_t x)
{

}

/*
################################################################################
##  NORDIC external interrupt
##############################################################################*/
//==============================================================================
//  OC,     
__weak void nrf_wait_irq_event(void)
{
}

