/*
** ============================================================================
** FILE            nrf_GlobalService.c
** DESCRIPTION     Contains all EEPROM functions,        
**
** TERGET          PIC18LF26K22
** CREATED         Solovyev A.F. Vega-Absolute Ltd.
** DATA            28.08.2013
** ============================================================================
*/



#ifndef __nrf_GlobalService_H
#define __nrf_GlobalService_H

#ifdef __cplusplus
extern "C" {
#endif     

#include "cph_Encrypt.h"
#include "nrf_bsp_driver.h" 

//______________________________________________________________________________
// 
#define NRF_DIALOG_MODE_NORMAL    0x00 //     
#define NRF_DIALOG_MODE_PROGRAMM  0x01 //    
//______________________________________________________________________________
//    
#define CL_DEVICE_GRAFT           0x0A //       
#define CL_NOP                    0x06 //    
//______________________________________________________________________________
//    
#define irq_MAX_RT                0x10 //    
#define irq_TX_DR                 0x20 //  
#define irq_RX_DR                 0x40 //  
#define irq_TRX_DR                0x60 //     
//______________________________________________________________________________
//   
#define ID_MARK			  0x00
#define ID_RELAY		  0x01
#define ID_CHIP			  0x02 //  ,  2.4    CHIP  ID (   )
#define ID_MODULE24               0x03
//______________________________________________________________________________
//  " " (  ,  4 )
#define HARDWARE_RETRANSMIT_EN    0x01 //        ( 4 )
#define HARDWARE_RETRANSMIT_DIS   0x00 //   
//______________________________________________________________________________
//   
#define LOCKOUT_UNDEF             0x02 //    
#define LOCKOUT_EN                0x01 //   , 
#define LOCKOUT_DIS               0x00 //   , 
//______________________________________________________________________________
//    
// ..    1ms,      1 ms  
// "+1"      ,
#define TIME_OUT_MARK_SEARCH               3000  // [ms]       (     )
#define TIME_OUT_MARK_GRAFT              300000  // [ms]         
#define TIME_OUT_AFTER_MARK_GRAFT         60000  // [ms]             
#define TIME_OUT_CHANGE_FREQUENCY          3000  // [ms]      
#define WAIT_REPEAT_RELAY_REQUEST          4000  // [ms]            
//______________________________________________________________________________
//  
//#define RELAY_FREQUENCY_PAIR_CODE_M24       32 // [M24 STM]           2.4 (510-)
//#define RELAY_FREQUENCY_PAIR_CODE_CHIP      36 // [M24 PIC  .]           (CHIP)
#define RELAY_FREQUENCY_PAIR_CODE_CHIP        40 // [M24 STM  .]           (CHIP)
//#define RELAY_SYNCHWORD_CHIP            0xD6A5 // [M24 PIC  .]         
#define RELAY_SYNCHWORD_CHIP              0x65AC // [M24 STM  .]         
#define RELAY_CONNECT_ATTEMPT                 18 //         GlobalService()
#define NUMBER_BASE_FREQUENCY                  2 //       (  )
#define ANSWER_PACKET_LENGTH                   4 //    
#define MAX_MARK_NUMBER                       10 //   ,     

#define IndicateMarkSearch(x)                  //{NOP(); LED_TRX(x); NOP();}
#define IndicateRelayConnect(x)                //{NOP(); LED_TRX(x); NOP();}
/*
################################################################################
##            TYPEDEF
##############################################################################*/
//______________________________________________________________________________
//   
typedef enum {
  gs_InitScaner,
  gs_WaitConnect,
  gs_InitRelay,
  gs_Innactive,
  gs_Out,
}GLOBAL_STATE;
//______________________________________________________________________________
//   
typedef enum {
  mm_Inactive = 0,     //  , -  ,   Power Down
  mm_SpvNorm = 1,      //    ()
  mm_SpvProg = 2,      //      ()
  mm_ScanNorm = 3,     //    
  mm_ScanProgMark = 4, //     
  mm_Undefined = 5,    //   
  mm_RelayLock = 6,    //   
  mm_RelayUnlock = 7,  //   
  mm_ScanProgRelay = 8,//    
}MASTER_MODE;
//______________________________________________________________________________
typedef struct {
  uint8_t current; 
  uint8_t previous;
}CHANNEL_NUMBER;
//______________________________________________________________________________
//   
typedef enum {
  cs_LoadRequest,
  cs_Transmite,
  cs_WaitAck,
  cs_CheckAck,
  cs_Exit,
}COMMUNICATION_STATE;
//______________________________________________________________________________
//   - 
typedef enum {
  ds_Request = 0,
  ds_Answer = 1,
}DIALOGUE_STEP;
//______________________________________________________________________________
//      
typedef enum
{
  lr_OK_Successful,        //   
  lr_OK_Grafted,           //   
  lr_ER_AbsentAck1,        //   1
  lr_ER_AbsentAck2,        //   2
  lr_ER_DecryptionFailure, //   
  lr_ER_HardwareFailure,   //  
}LINK_RESULT;
//______________________________________________________________________________
//     
typedef enum
{
  lfr_ConnectSuccess,      //   
  lfr_GraftSuccess,        //   
  lfr_ConnectFailure,      //  
}LINK_FRAME_RESULT;

//__________________________________
////////////// SCANER //////////////
typedef enum {
  n24ds_CheckRequest,
  n24ds_WaitAnswer,
  n24ds_MarkFixed,
  n24ds_ChipFixed,
  n24ds_RelayFixed,
  n24ds_Exit,
  n24ds_Out,
  n24ds_DeviceGraft,
}N24_DIALOGUE_STATE;

//______________________________________________________________________________
typedef enum {
  //     2.4
  fcr_Undefined = 0, //  
  scan_SearchTimeOut = 1, //   
  scan_ConnectFailure = 2, //   
  scan_ConnectSuccess = 3, //   
  scan_GraftSuccess = 4, //   
  
  spv_ConnectFailure = 5, //   
  spv_ConnectSuccess = 6, //   
  spv_GraftSuccess = 7, //   
  scan_GraftSuccessRelay = 8, //    
  relay_ConnectFailure = 9, //   
  relay_ConnectSuccess = 0x0A, //   

  //       "Supervisor"  "Scaner"
  fci_RelayUnlock = 0x1E, //   
  fci_RelayLock = 0x1F, //   
  fci_SupervisorNormal = 0x20, //   "SUPERVISOR"
  fci_SupervisorGraft = 0x21, //      "SUPERVISOR"
  fci_ScanerNormal = 0x22, //   "SCANER"
  fci_ScanerGraft = 0x23, //      "SCANER"
  fci_Inactive = 0x24, //    (Power down)
  fci_ScanerSetMarkPower = 0x25, //    (  "Scaner")
}FUNCTIONAL_CODE;
//______________________________________________________________________________
//   
typedef struct{
  FlagStatus flag;
  FUNCTIONAL_CODE code; //  
  uint8_t data; //  
}RESULT_STRUCTURE;
//______________________________________________________________________________
//   nrf 
typedef struct{
 uint16_t mark_online_status;  //         ( )
 uint16_t mark_battery_status; //             ( )
 uint16_t mark_graft_config;   //      ( )
 uint8_t MarkCurGraftCell;     //        
}NRF_CTRL;
/*
################################################################################
##            VARIABLE
##############################################################################*/
extern CHANNEL_NUMBER ChannelNumber;
extern uint8_t nRF_CH[];
extern const uint8_t rf_ACKNB[];
extern FlagStatus F_CommunicationFinish;
extern uint8_t rf_DialogMode;
extern uint8_t nRF_RxBuffer[];
extern RESULT_STRUCTURE TotalResult;
extern uint8_t Debug_IRQ_STATE[];
extern FREQ_PAIR relay_ChannelBlock; //      
extern uint8_t rf_RelayPipeAddrBlock[];
extern FlagStatus FR_SpvConnectSuccess; // ,   510-  ,   -  
extern FlagStatus FR_SpvGraftSuccess; // ,   510-  
extern FlagStatus FR_ScanGraftSuccess;  // ,     chip,   -   
extern FlagStatus FR_ScanConnectSuccess; // ,   ,   -      
extern FlagStatus FR_ScanSearchTimeOut; // ,   
extern MASTER_MODE GlobalCommunication;
extern WORDUM SNnrf[];
extern NRF_CTRL NRFCtrl;
/*
################################################################################
##            PROTOTYPES
##############################################################################*/

void nrf_RelayService(void);
void nRF_LinkCycle(void);
FUNCTIONAL_CODE nRF_LinkFrameBlock(uint8_t _connect_attempt);
void nRF_LinkBlock(void);
LINK_RESULT nRF_TxConnection(void);
void nRF_GlobalService(void);
void GC_Launch(MASTER_MODE _mm);
bool RF_CheckRequiredModeReadiness(MASTER_MODE _tested_conf);
uint8_t nrf_GetDialogMode(MASTER_MODE* _mm);
FlagStatus irq_GetState(uint8_t _st);
void ptc_ChangeChannel(CHANNEL_NUMBER* _channel_number);
void nrf_SpvSetSpecialSettings(void);
void nrf_RepeatRelayRequestTimeout(uint16_t _rrrt);

//__________________________________
////////////// SCANER //////////////
void nrf_ScanerService(void);
void nRF_m2_LoadChannel(uint8_t _dialog_mode);
void nRF_FloatDelayForMarkRetransmite(void);
uint8_t GetMarkBatteryStatus(uint8_t* _mi);
void nrf_ChangeFrequencyChannel(void);
void nRF_Receive(uint8_t _dialog_mode);
void nRF_RxConnection(void);
void nrf_ScanSetSpecialSettings(uint8_t _dm);
void nrf_SetMarkSearchTimeout(uint32_t _msto);
void nrf_CountModeTimeOut(void);
void nRF_LoadChannel(FREQ_PAIR* _channel_block, uint8_t* _pipe_block);
FUNCTIONAL_CODE nRF_LinkFrame(void);
void TRX_CE(uint8_t x);
void nrf_NextChannel(void);
void result_Reset(void);
void nRF_ScanerHandler(void);

void nRF_MarksStatus_Update(uint8_t* _mi);
void nRF_MarksStatus_Reset(void);
void GC_SetCell(uint8_t _cell_number);
uint8_t GC_GetCell(void);
void nRF_MarksGrafted_MaskUpdate(void);
bool nRF_Marks_CheckAllToOnline(void);

BOOLEAN ram_ItIsEqual(uint8_t* _a, uint8_t* _b, uint8_t _length);
bool ram_ItIsZero(uint8_t* _in, uint8_t _length);


void WaitTimeOut_Launch(uint16_t _to_ms);
void WaitTimeOut_Count(void);
FlagStatus WaitTimeOut_GetFlag(void);
void WaitTimeOut_SetFlag(FlagStatus _fs);
void LED_TRX(uint8_t x);

//      1 ms (  OC)
extern void nrf_wait_irq_event(void);

#ifdef __cplusplus
}
#endif     
#endif





