/*
** ============================================================================
** FILE            nrf_common.h
** DESCRIPTION    
**
** TERGET          STM32L151
** CREATED         Solovyev A.F. Vega-Absolute Ltd.
** DATA            15.06.2016
** ============================================================================
*/


#ifndef __NRF_COMMON_H
#define __NRF_COMMON_H

#ifdef STM32F10X_HD
#include "stm32f10x.h"
#endif

#ifdef STM32F2XX
#include "stm32f2xx.h"
#endif

#ifdef STM32F413_423xx
#include "stm32f4xx.h"
#endif

#include <stdbool.h>
#include <string.h>

#include "nrf_bsp_driver.h" 
#include "nrf_reg_name.h"

//_______________________________________________________________________________________
//    1 ms,        
#define D_2ms                   3  
#define D_3ms                   4
#define D_4ms                   5
#define D_5ms                   6
#define D_6ms                   7
#define D_7ms                   8
#define D_8ms                   9
#define D_9ms                  10
#define D_10ms                 11

//_______________________________________________________________________________________
//     2.4
#define CMD_SCAN_NORM        0x20  //   
#define CMD_SCAN_PROG_MARK   0x21  //     
#define CMD_SCAN_PROG_RELAY  0x22  //     
#define CMD_RELAY_UNLOCK     0x23  //      ""
#define CMD_RELAY_LOCK       0x24  //      ""

#define NOP()                   __no_operation();  // NOP 
#define InterruptsEnable()      __set_PRIMASK(0);  //  
#define InterruptsDisable()     __set_PRIMASK(1);  //  
#define enableInterrupts()      __set_PRIMASK(0);  //  
#define disableInterrupts()     __set_PRIMASK(1);  //  
/*
################################################################################
##            TYPEDEF
##############################################################################*/
typedef enum { BOOL_FALSE = 0, BOOL_TRUE = 1, BOOL_ERROR = 2,}BOOLEAN;
typedef enum {FUNC_DISABLE = 0, FUNC_ENABLE = !FUNC_DISABLE} FUNC_STATE;
typedef enum {FLAG_RESET = 0, FLAG_SET = !FLAG_RESET} FLAG_STATE;
typedef union{
  uint8_t E8[4];
  uint16_t E16[2];
  uint32_t E32; 
} WORDUM;

typedef union {
  struct {
    uint8_t low;
    uint8_t high;
  };
 uint16_t word;
}TWOBYTES;

/*
################################################################################
##            PROTOTYPES
##############################################################################*/


/*
################################################################################
##            INCLUDE
##############################################################################*/


#endif