#ifndef __nrf_reg_name_H
#define __nrf_reg_name_H
/*
################################################################################
##            INCLUDE
##############################################################################*/

/*
################################################################################
##            DEFINE
##############################################################################*/  

//commands write
#define W_CONFIG                  0x20 //0b00100000 // R/W
#define W_EN_AA                   0x21 //0b00100001 // R/W
#define W_EN_RXADDR               0x22 //0b00100010 // R/W
#define W_SETUP_AW                0x23 //0b00100011 // R/W
#define W_SETUP_RETR              0x24 //0b00100100 // R/W
#define W_RF_CH                   0x25 //0b00100101 // R/W
#define W_RF_SETUP                0x26 //0b00100110 // R/W
#define W_STATUS                  0x27 //0b00100111 // R/W // see datasheet
#define W_RX_ADDR_P0              0x2A //0b00101010 // R/W   
#define W_RX_ADDR_P1              0x2B //0b00101011 // R/W   
#define W_RX_ADDR_P2              0x2C //0b00101100 // R/W
#define W_RX_ADDR_P3              0x2D //0b00101101 // R/W
#define W_RX_ADDR_P4              0x2E //0b00101110 // R/W
#define W_RX_ADDR_P5              0x2F //0b00101111 // R/W
#define W_TX_ADDR                 0x30 //0b00110000 // R/W   
#define W_RX_PW_P0                0x31 //0b00110001 // R/W
#define W_RX_PW_P1                0x32 //0b00110010 // R/W
#define W_RX_PW_P2                0x33 //0b00110011 // R/W
#define W_RX_PW_P3                0x34 //0b00110100 // R/W
#define W_RX_PW_P4                0x35 //0b00110101 // R/W
#define W_RX_PW_P5                0x36 //0b00110110 // R/W
#define W_DYNPD                   0x3C //0b00111100 // R/W
#define W_FEATURE                 0x3D //0b00111101 // R/W

//commands read
#define R_CONFIG                  0x00 //0b00000000 // R/W
#define R_EN_AA                   0x01 //0b00000001 // R/W
#define R_EN_RXADDR               0x02 //0b00000010 // R/W
#define R_SETUP_AW                0x03 //0b00000011 // R/W
#define R_SETUP_RETR              0x04 //0b00000100 // R/W
#define R_RF_CH                   0x05 //0b00000101 // R/W
#define R_RF_SETUP                0x06 //0b00000110 // R/W
#define R_STATUS                  0x07 //0b00000111 // R/W // see datasheet
#define R_OBSERVE_TX              0x08 //0b00001000 // R
#define R_CD                      0x09 //0b00001001 // R
#define R_RX_ADDR_P0              0x0A //0b00001010 // R/W  ??????? 5 byte  1 ??? 
#define R_RX_ADDR_P1              0x0B //0b00001011 // R/W  ??????? 5 byte  1 ???
#define R_RX_ADDR_P2              0x0C //0b00001100 // R/W
#define R_RX_ADDR_P3              0x0D //0b00001101 // R/W
#define R_RX_ADDR_P4              0x0E //0b00001110 // R/W
#define R_RX_ADDR_P5              0x0F //0b00001111 // R/W
#define R_TX_ADDR                 0x10 //0b00010000 // R/W  ??????? 5 byte  1 ???
#define R_RX_PW_P0                0x11 //0b00010001 // R/W
#define R_RX_PW_P1                0x12 //0b00010010 // R/W
#define R_RX_PW_P2                0x13 //0b00010011 // R/W
#define R_RX_PW_P3                0x14 //0b00010100 // R/W
#define R_RX_PW_P4                0x15 //0b00010101 // R/W
#define R_RX_PW_P5                0x16 //0b00010110 // R/W
#define R_FIFO_STATUS             0x17 //0b00010111 // R
#define R_DYNPD                   0x1C //0b00011100 // R/W
#define R_FEATURE                 0x1D //0b00011101 // R/W

//R_REGISTER 000A AAAA 
//W_REGISTER 001A AAAA 
#define R_RX_PAYLOAD              0x61 //0b01100001
#define W_TX_PAYLOAD              0xA0 //0b10100000
#define W_ACK_PAYLOAD_P0          0xA8 //0b10101000	//  3   pipe
#define W_ACK_PAYLOAD_P1          0xA9 //0b10101001	//  3   pipe
#define W_ACK_PAYLOAD_P2          0xAA //0b10101010	//  3   pipe
#define W_ACK_PAYLOAD_P3          0xAB //0b10101011	//  3   pipe
#define FLUSH_TX                  0xE1 //0b11100001
#define FLUSH_RX                  0xE2 //0b11100010
#define REUSE_TX_PL               0xE3 //0b11100011
#define ACTIVATE                  0x50 //0b01010000
#define R_RX_PL_WID               0x60 //0b01100000
#define nRF_NOP                   0xFF //0b11111111

/*
################################################################################
##            TYPEDEF
##############################################################################*/

/*
################################################################################
##            PROTOTYPES
##############################################################################*/

#endif
