/*
** ============================================================================
** FILE            nrf_subroutines.
** DESCRIPTION     Contains all transciever`s subfunction          
**
** TERGET          PIC18LF26K22
** CREATED         Solovyev A.F. Vega-Absolute Ltd.
** DATA            25.12.2013
** ============================================================================
*/


/*
################################################################################
##            INCLUDE
##############################################################################*/
#include "nrf_common.h"
#include "nrf_subroutines.h"
#include "nrf_GlobalService.h"
/*
################################################################################
##            VARIABLES
##############################################################################*/
FlagStatus Flag_InterruptTRX = RESET; //     ,        
uint8_t FLAGS_IRQ_STATE; //      nRF24L01+
//#define irq_TX_FIFO_FULL					FLAGS_IRQ_STATE.bits_fl._bit0
//#define irq_RX_PIPE_N0						FLAGS_IRQ_STATE.bits_fl._bit1
//#define irq_RX_PIPE_N1						FLAGS_IRQ_STATE.bits_fl._bit2
//#define irq_RX_PIPE_N2						FLAGS_IRQ_STATE.bits_fl._bit3
//#define irq_MAX_RT								FLAGS_IRQ_STATE.bits_fl._bit4 //   ,     
//#define irq_TX_DR								  FLAGS_IRQ_STATE.bits_fl._bit5 // Data Sent TX FIFO interrupt. Asserted when packet transmitted on TX. If AUTO_ACK is activated, this bit is set high only when ACK is received.
//#define irq_RX_DR								  FLAGS_IRQ_STATE.bits_fl._bit6 //    RX-FIFO 
//#define reserved								  FLAGS_IRQ_STATE.bits_fl._bit7


/*    _____________________________________________
     /		Pipe address		           \     Counter
___  ______  ______  ______  ______  ______  ______  ______  ______  ______  ______________    
   \/PREAMB\/  SW1 \/  SW0 \/  SN2 \/  SN1 \/  SN0 \/  PID \/ DATA \/ CRC  \/      
    \______/\______/\______/\______/\______/\______/\______/\______/\______/\______________
*/

//============================================================================
//      
//       "power down"
void Config_nRF24(void)
{
  //  nRF24L01   
  TRX_CE(0);                              // 
  nrf_bsp_delay_ms(12);                         // power on reset 10,3 ms by datasheet
  nRF_PowerDown();	                      //[0x20] POWER DOWN, CRC enable, 1 byte CRC
  nRF_ReInit24();
  //     "POWER DOWN" (900nA),    
  //     -   "STANDBY 1" (22 uA)
  nRF_PowerDown();                        //   POWER DOWN
}


//==============================================================================
//       
void nRF_ReInit24(void)
{
  uint8_t Buf;

  TRX_CE(0);     // 
  nrf_bsp_delay_ms(1);
  spi_write_byte_nRF(W_EN_RXADDR, 0x01);	//[0x22] Enable data pipe 0 only.
  spi_write_byte_nRF(W_EN_AA, 0x01);		//[0x21] Enable auto acknowledgement data pipe 0 (    0)
  spi_write_byte_nRF(W_SETUP_AW, 0x03);		//[0x23] Address field width: 5 bytes
  spi_write_byte_nRF(W_SETUP_RETR, 0x03);	//[0x24] Auto Retransmit enabled.	    : Auto Retransmit Delay Wait 250uS, Up to 3 Re-Transmit on fail of AA
  nRF_Power(NRF_SYSTEM_POWER); //    
  
  //        
  Buf = spi_read_byte_nRF(R_FEATURE);	 	//[0x1D] FEATURE //    1Dh
  NOP();					//Enables Payload with ACK, Enables Dynamic Payload Length
  if((Buf&0x06)!=0x06)			        //       
  {//   .   ,       
    spi_write_byte_nRF(ACTIVATE, 0x73);	        //[0x50]   
    spi_write_byte_nRF(W_FEATURE, 0x06);	//[0x3D]   ,      
    spi_write_byte_nRF(W_DYNPD, 0x01);		//[0x3C]     PIPE_0
  }
  nRF_FlushTRX();
  nRF_StatusReset();	//[0x27]  
}



//==============================================================================
//    
void nRF_SetRxPipeAddress(uint8_t* _pipe_addr, uint8_t _length)
{
  spi_write_block_nRF(W_RX_ADDR_P0, _pipe_addr, _length); //[0x2A]  RX   (SW & SNmk)
}

//==============================================================================
//    
void nRF_SetTxPipeAddress(uint8_t* _pipe_addr, uint8_t _length)
{
  spi_write_block_nRF(W_TX_ADDR, _pipe_addr, _length); //[0x30]  TX 
}

//==============================================================================
//  
void nRF_Frequency(uint8_t _freq)
{
  if(_freq<=125)
  {
    spi_write_byte_nRF(W_RF_CH, _freq);		
  }
}

//==============================================================================
//  
void nRF_FlushTX(void)
{
  spi_write_com_nRF(FLUSH_TX);			//[0xE1]   TX
}

//==============================================================================
//  
void nRF_FlushRX(void)
{
  spi_write_com_nRF(FLUSH_RX);			//[0xE1]   TX
}

//==============================================================================
//     
void nRF_FlushTRX(void)
{
  spi_write_com_nRF(FLUSH_TX);			//[0xE1]   TX
  spi_write_com_nRF(FLUSH_RX);			//[0xE1]   RX    
}

//==============================================================================
//         ACK
//  : _retransmite_attempt -   
//                 0 -    (retransmite )
//                 1 -  
//                 15 -    15 
void nRF_SetAutoRetransmite(uint8_t _retransmite_attempt)
{
  if(_retransmite_attempt <= 15)
  {
    spi_write_byte_nRF(W_SETUP_RETR, _retransmite_attempt);
  }
}

//==============================================================================
//    
void nRF_Power(uint8_t _pwr_level)
{
  if(_pwr_level<=3)
  {
    spi_write_byte_nRF(W_RF_SETUP, (0x08 | (_pwr_level<<1)));		//[0x26] 2 Mbps, - 0 dBm  	
  }
}

//==============================================================================
//   
void nRF_AckPayloadWrite(uint8_t* _buf_data, uint8_t _length)
{
  spi_write_block_nRF(W_ACK_PAYLOAD_P0, _buf_data, _length); //    0
}

//==============================================================================
//      
void nRF_TxPayloadWrite(uint8_t* _buf_data, uint8_t _length)
{
  spi_write_block_nRF(W_TX_PAYLOAD, _buf_data, _length);
}

//==============================================================================
//    
void nRF_RxPayloadRead(uint8_t* _buf_data, uint8_t _length)
{
  spi_read_block_nRF(R_RX_PAYLOAD, _buf_data, _length);	//  SN  ID   
}

//==============================================================================
// C 
void nRF_StatusReset(void)
{
  spi_write_byte_nRF(W_STATUS, nRF_RESET);	//[0x27]   
}

//==============================================================================
//   Power down
void nRF_PowerUp(uint8_t _up_mode)
{
  spi_write_byte_nRF(W_CONFIG, _up_mode);	//[0x20] POWER UP
}

//==============================================================================
//   Power down  
void nRF_PowerUpTx(void)
{
  spi_write_byte_nRF(W_CONFIG, POWER_UP_TX);	//[0x20] POWER UP
}  

//==============================================================================
//   Power down  
void nRF_PowerUpRx(void)
{
  spi_write_byte_nRF(W_CONFIG, POWER_UP_RX);	//[0x20] POWER UP
}  

//==============================================================================
//    Power down
void nRF_PowerDown(void)
{
  spi_write_byte_nRF(W_CONFIG, POWER_DOWN); 	//[0x20] POWER DOWN
}

//==============================================================================
//   ()
uint8_t nRF_GetIrqStatus(void)
{
  FLAGS_IRQ_STATE = spi_read_byte_nRF(R_STATUS);
  return(FLAGS_IRQ_STATE);
}

//==============================================================================
//    
FlagStatus irq_GetState(uint8_t _st) 
{
  if((FLAGS_IRQ_STATE & _st) == _st)
   {return(SET);}
  else{return(RESET);}
}


//==============================================================================
//   
void nRF_RxAddrEnable(void)
{
  spi_write_byte_nRF(W_EN_RXADDR, 0x01);	       //   
}

//==============================================================================
//      (   re-transmite)
uint8_t nRF_ObserveTx(void)
{
  return(spi_read_byte_nRF(R_OBSERVE_TX) & 0x0F);	//     
}

//==============================================================================
//    
uint8_t nRF_RxLengthGet(void)
{
  return(spi_read_byte_nRF(R_RX_PL_WID));
}

//=====================================================================================
//      
void ptc_Pulse(void)
{
  Flag_InterruptTRX = RESET;
  TRX_CE(1);  // 12  -   nRF24L01
  nrf_bsp_delay_us(15);
  TRX_CE(0);
}

//==============================================================================
//      
void nrf_SetNordicInterrupt(FlagStatus _fs)
{
  Flag_InterruptTRX = _fs;
}



