/**
  ******************************************************************************
  * @file    nrf_subroutines.h
  * @author  Solovyev A.F.
  * @date    12-12-2012
  * @brief   
  *******************************************************************************
 @verbatim
*/



#ifndef __nrf_subroutines_H
#define __nrf_subroutines_H

#ifdef __cplusplus
extern "C" {
#endif     
  
#define	nRF_RESET                       0x7F //     
#define	POWER_UP_RX                     0x0B //  power up  
#define	POWER_UP_TX                     0x0A //  power up  
#define	POWER_DOWN                      0x09 //  power down  

#define NRF_POWER_MINUS_0dBm            3  //   
#define NRF_POWER_MINUS_6dBm            2 
#define NRF_POWER_MINUS_12dBm           1 
#define NRF_POWER_MINUS_18dBm           0  //   

//         
#define NRF_SYSTEM_POWER                NRF_POWER_MINUS_0dBm //   


/*
################################################################################
##            TYPEDEF
##############################################################################*/

/*
################################################################################
##            EXTERN VARIABLES
##############################################################################*/

extern FlagStatus Flag_InterruptTRX;	
/*
################################################################################
##            PROTOTYPES
##############################################################################*/
void Config_nRF24(void);
void nRF_ReInit24(void);
void nRF_FlushTX(void);
void nRF_FlushRX(void);
void nRF_FlushTRX(void);
void nRF_Power(uint8_t _pwr_level);
void nRF_Frequency(uint8_t _freq);
void nRF_SetRxPipeAddress(uint8_t* _pipe_addr, uint8_t _length);
void nRF_SetTxPipeAddress(uint8_t* _pipe_addr, uint8_t _length);
void nRF_AckPayloadWrite(uint8_t* _buf_data, uint8_t _length);
void nRF_RxPayloadRead(uint8_t* _buf_data, uint8_t _length);
void nRF_TxPayloadWrite(uint8_t* _buf_data, uint8_t _length);
void nRF_SetAutoRetransmite(uint8_t _retransmite_attempt);
void nRF_PowerUp(uint8_t _up_mode);
void nRF_PowerUpTx(void);
void nRF_PowerUpRx(void);
void nRF_PowerDown(void);
void nRF_StatusReset(void);
void nRF_RxAddrEnable(void);
void ptc_Pulse(void);
uint8_t nRF_GetIrqStatus(void);
uint8_t nRF_ObserveTx(void);
uint8_t nRF_RxLengthGet(void);
void nrf_SetNordicInterrupt(FlagStatus _fs);

#ifdef __cplusplus
}
#endif    

#endif




