/**
  ******************************************************************************
  * @file    sf_BlackBox.h
  * @author  Solovyev A.F.
  * @date    11-04-2016
  * @brief   
  *******************************************************************************
 @verbatim
*/



#ifndef __sf_BlackBox_H
#define __sf_BlackBox_H

#ifdef __cplusplus
extern "C" {
#endif

//______________________________________________________________________________
//       EEPROM
#define EE_BB_START_POSITION           (0)
#define LENGTH_SETTINGS                ((MAX_MARK_NUMBER*3)+3+3)  //       ( )
 
/*
################################################################################
##            TYPEDEF
##############################################################################*/
typedef struct{
  uint8_t length;        //    
  uint8_t wordlen;       //     
  uint32_t addr_start;   //    
  uint32_t addr_end;     //      
  uint8_t* data;         //   
}BLACK_BOX_ITEM_CTRL;

/*
################################################################################
##            VARIABLE
##############################################################################*/
/*

################################################################################
##            PROTOTYPES
##############################################################################*/
void bb_Write(uint8_t* src, uint16_t len);
bool bb_Read(uint8_t* dst, uint16_t len);

#ifdef __cplusplus
}
#endif
  
#endif






