/*
** ============================================================================
** FILE            y_eeprom.c
** DESCRIPTION     Contains all EEPROM functions, PIC16F946 dependent functions          
**
** TERGET          PIC18LF26K22
** CREATED         Solovyev A.F. Vega-Absolute Ltd.
** DATA            28.08.2013
** ============================================================================
*/

/*
################################################################################
##            INCLUDE
##############################################################################*/
#include "nrf_common.h"
#include "nrf_GlobalService.h"
#include "serial_number.h"
#include "y_eeprom.h"
#include "sf_BlackBox.h"

/*
################################################################################
##            VARIABLE
##############################################################################*/
uint8_t nRF_EEPROM[LENGTH_SETTINGS]; //    
uint8_t e_MarkPower = 0x00; //      "Scaner"
uint8_t e_NumberOfValidMarksInSystem = 0x00; //     
uint8_t e_NumberOfValidRelaysInSystem = 0x00; //      (  )
FlagStatus F_EUPD_SERVICE_ENABLE = RESET;

//-------------------------------------------------------------------
//     eeprom  
void eeprom_RestoreAllBuffers(void)
{
  //------------------------------------------------------------------------------
  //        
  ///////////////  SNd ////////////////////
  //       
  //SNd = FLASH_SNd; //   
  nrf_bsp_get_unique_id(&SNd.E32);
  SNd.E8[3] = 0x00; // ID_CHIP;
  GlobalCommunication = mm_Inactive; //    

  //------------------------------------------------------------------------------
  //       
  ///////         ////////////////////////
  RelayFrequencyPairCode = RELAY_FREQUENCY_PAIR_CODE_CHIP;
  ///////       //////////////////////////////
  calculate_FreqChannelPair(RelayFrequencyPairCode, &relay_ChannelBlock);
  ///////        ////////////////////
  USWF_RELAY.word = RELAY_SYNCHWORD_CHIP;
  //////  PIPE-    //////////////////////////////
  calculate_PipeAddr(&SNd, (TWOBYTES*)&USWF_RELAY, rf_RelayPipeAddrBlock);

  //------------------------------------------------------------------------------
  //       
  ///////    ///////////////////////////////////////
  m2_USWF.word = USWF_CHIP; //     
  //////  PIPE-    ///////////////////////////
  calculate_PipeAddr(&SNd, &m2_USWF, &m2_PipeAddrBlock[NRF_DIALOG_MODE_NORMAL][0]);  //    USWF  SNam   
  //////  PIPE-    //////////////////////
  calculate_PipeAddrProg(&m2_PipeAddrBlock[NRF_DIALOG_MODE_PROGRAMM][0]); //     2.4
  /////   /////////////////////////////////////////////////
  calculate_DTM(&m2_PipeAddrBlock[NRF_DIALOG_MODE_NORMAL][0], &m2_DTM); //  DTM   SNam
  /////     ///////////////////////////////////////
  calculate_KEY(&SNd, &m2_KEY); //       SNam ( BFC)
  /////         //////////
  calculate_FreqChannelPair(m2_KEY.bfc, &m2_ChannelBlock[NRF_DIALOG_MODE_NORMAL]);
  ///          //////
  calculate_FreqChannelPair(62, &m2_ChannelBlock[NRF_DIALOG_MODE_PROGRAMM]);

  //_______________________________________________________________________________
  //    EEPROM
  //   EEPROM    ,      EEPROM   
  eeprom_SmartReadGraftValues();

  //////  PIPE-    ///////////////////////////
  //calculate_PipeAddr(&SNam, &USWF, &m1_PipeAddrBlock[NRFDM_NORMAL][0]);
  //////  PIPE-    //////////////////////
  //calculate_PipeAddrProg(&m1_PipeAddrBlock[NRFDM_PROGRAMM][0]); 
  //////   DTM ////////////////////////////////////////////
  //calculate_DTM(&m1_PipeAddrBlock[NRFDM_NORMAL][0], &DTM); //   (   pipe- (  SNam  USWF))
  /////         //////////
  //calculate_FreqChannelPair((uint8_t)KEY.bfc, &rf_ChannelBlock[NRFDM_NORMAL]);
  ///          //////
  //calculate_FreqChannelPair(62, &rf_ChannelBlock[NRFDM_PROGRAMM]);
  
  //SNnrf[0].E8[3] = ID_MARK;
  //SNnrf[1].E8[3] = ID_MARK;
  //SNnrf[2].E8[3] = ID_MARK;
}

//==============================================================================
//    eeprom    
//        ,  
//    .
// !      ,     
void eeprom_SmartReadGraftValues(void)
{
  if(bb_Read(nRF_EEPROM, sizeof(nRF_EEPROM)) == false) //  
  { //     eeprom
    eeprom_UploadDefaultValues(); //       
    eeprom_SmartSaveGraftValues(); //     EEPROM
  }
  else
  { //    
    eeprom_UploadGraftValues(); //     
  }
}

//===========================================================================
//        nRF_EEPROM
void eeprom_DownloadGraftValues(void)
{
  uint16_t offset=0;
  
  //        nRF_EEPROM
  for(uint8_t i=0; i<MAX_MARK_NUMBER; i++)
  {
    memcpy(&nRF_EEPROM[offset], &SNnrf[i].E8[0], 3);
    offset+=3;
  }
  
  //        nRF_EEPROM
  memcpy(&nRF_EEPROM[offset], &SNrl.E8[0], 3);
  offset+=3;
  
  //     
  nRF_EEPROM[offset++]=e_MarkPower;
  nRF_EEPROM[offset++]=e_NumberOfValidMarksInSystem;
  nRF_EEPROM[offset++]=e_NumberOfValidRelaysInSystem;
}

//===========================================================================
//     nRF_EEPROM   
void eeprom_UploadGraftValues(void)
{
  const uint8_t empty[3]={0,0,0};
  uint16_t offset=0;
  
  //        nRF_EEPROM
  for(uint8_t i=0; i<MAX_MARK_NUMBER; i++)
  {
    memcpy(&SNnrf[i].E8[0], &nRF_EEPROM[offset], 3);
    if(memcmp(&SNnrf[i].E8[0], &empty[0], 3)!=0) SNnrf[i].E8[3]=ID_MARK;
    offset+=3;
  }
  
  //        nRF_EEPROM
  memcpy(&SNrl.E8[0], &nRF_EEPROM[offset], 3);
  if(memcmp(&SNrl.E8[0], &empty[0], 3)!=0) SNrl.E8[3]=ID_RELAY;
  offset+=3;
  
  //    
  e_MarkPower=nRF_EEPROM[offset++];
  e_NumberOfValidMarksInSystem=nRF_EEPROM[offset++];
  e_NumberOfValidRelaysInSystem=nRF_EEPROM[offset++];
}

//===========================================================================
//       
void eeprom_UploadDefaultValues(void)
{
  e_MarkPower = DEFAULT_MARK_POWER;
  e_NumberOfValidMarksInSystem=0;
  e_NumberOfValidRelaysInSystem=0;
  memset(SNrl.E8, 0, sizeof(SNrl.E8));
  for(uint8_t i=0; i<MAX_MARK_NUMBER; i++)
  {
    memset(SNnrf[i].E8, 0, sizeof(SNnrf[i].E8));
  }
} 

//------------------------------------------------------------------------------
//     EEPROM
void eeprom_Service(void)
{
  //////    EEPROM /////
  if(F_EUPD_SERVICE_ENABLE == SET)
  { 
    F_EUPD_SERVICE_ENABLE = RESET;
    eeprom_SmartSaveGraftValues();
  } 
}

//===========================================================================
// C    EEPROM   
void eeprom_SmartSaveGraftValues(void)
{
  eeprom_DownloadGraftValues();             //    nRF_EEPROM[]
  bb_Write(nRF_EEPROM, sizeof(nRF_EEPROM)); //   nRF_EEPROM[]
}

//---------------------------------------------------------------------------
//      "SCAN_MODE"      .
void ClearEncryptSettings(uint8_t _reg_type)
{
  //     "SCAN_MODE"
  //   ,   ,           
  if(_reg_type ==  SCAN_MODE)
  {
    e_NumberOfValidMarksInSystem = 0x00;  //   
    for(uint8_t i=0; i<MAX_MARK_NUMBER; i++)
    {
      memset(SNnrf[i].E8, 0, sizeof(SNnrf[i].E8));//         
    }
    eeprom_SmartSaveGraftValues(); //    EEPROM
  }
  //    
  else
  {
    e_NumberOfValidRelaysInSystem = 0x00; //     
    memset(SNrl.E8, 0, sizeof(SNrl.E8)); //        
    eeprom_SmartSaveGraftValues(); //    EEPROM
  }
}

//##############################################################################
//                      EEPROM SERVICE
//##############################################################################

//------------------------------------------------------------------------------
//      EEPROM 
//    eeprom_Service      
//   eeprom
void eeprom_UpdateItemLaunch(void)
{
   F_EUPD_SERVICE_ENABLE = SET;
}
