/**
  ******************************************************************************
  * @file    y_eeprom.h
  * @author  Solovyev A.F.
  * @date    11-02-2014
  * @brief   
  *******************************************************************************
 @verbatim
*/



#ifndef __y_eeprom_H
#define __y_eeprom_H
/*
################################################################################
##            INCLUDE
##############################################################################*/
#include "nrf_subroutines.h"
#include "cph_Encrypt.h"

#ifdef __cplusplus
extern "C" {
#endif
  
/*
################################################################################
##            DEFINE
##############################################################################*/
//#define USWF_M24                         (uint16_t)0x569A //    2.4
//#define USWF_CHIP                        (uint16_t)0xA965 // [PIC  .]    2.4
#define USWF_CHIP                          (uint16_t)0x6953 // [STM  .]    2.4
#define USWF_DARK                          (uint16_t)0x0000 //     
#define DEFAULT_MARK_POWER                 (NRF_POWER_MINUS_0dBm)

#define EE_WRITE                           0x00 //  
#define EE_READ                            0x01 //  

#define EE_BB_OFFSET_POSITION              (0x00000010) //    

#if (EE_BB_OFFSET_POSITION%4!=0)
#error EE_BB_OFFSET_POSITION%4!=0
#endif
  
/*
################################################################################
##            TYPEDEF
##############################################################################*/
extern uint8_t e_NumberOfValidMarksInSystem;
extern uint8_t e_NumberOfValidRelaysInSystem;
extern uint8_t e_MarkPower;

/*
################################################################################
##            PROTOTYPES
##############################################################################*/
			
void eeprom_RestoreAllBuffers(void);
void eeprom_DoMas(uint8_t _type_operation, uint16_t _addr, uint8_t* _data, uint8_t _length);
void uart_PrintInfo(void);
void uart_PrintChannel(WORDUM* _sn, TWOBYTES* _uswf, ENCRYPT_KEY* _key, FREQ_PAIR* _cb, uint8_t* _pan, uint8_t* _pap);
void eeprom_UpdateItemLaunch(void);
void eeprom_Service(void);
void ClearEncryptSettings(uint8_t _reg_type);

void eeprom_DownloadGraftValues(void);
void eeprom_UploadGraftValues(void);
void eeprom_UploadDefaultValues(void);
void eeprom_SmartSaveGraftValues(void);
void eeprom_SmartReadGraftValues(void);
BOOLEAN eeprom_CheckBlock(void);

#ifdef __cplusplus
}
#endif
  
#endif






