/**
******************************************************************************
* File Name          : nrf_bsp_driver.h
* Description        : 
*     
*                      
******************************************************************************
*/

#ifndef __NRF_BSP_H
#define __NRF_BSP_H

#ifdef __cplusplus
extern "C" {
#endif     
  
#include <stdint.h>
#include "stm32f4xx.h"
#include "boot_config.h"
  
#ifdef USE_FREERTOS
#include "FreeRTOS.h"
#include "semphr.h" 
#endif

#define NRF_CE_PIN                                   GPIO_Pin_2
#define NRF_CE_PORT                                  GPIOF

#define NRF_SPI                                      SPI5
#define NRF_SPI_MISO_PIN                             GPIO_Pin_5
#define NRF_SPI_MISO_PORT                            GPIOE
#define NRF_SPI_MOSI_PIN                             GPIO_Pin_6
#define NRF_SPI_MOSI_PORT                            GPIOE
#define NRF_SPI_SCK_PIN                              GPIO_Pin_2
#define NRF_SPI_SCK_PORT                             GPIOE
#define NRF_SPI_CS_PIN                               GPIO_Pin_4
#define NRF_SPI_CS_PORT                              GPIOE

#define NRF_SPI_REMAP()                              {GPIO_PinAFConfig(NRF_SPI_MISO_PORT, GPIO_PinSource5, GPIO_AF6_SPI5);  GPIO_PinAFConfig(NRF_SPI_MOSI_PORT, GPIO_PinSource6, GPIO_AF6_SPI5);  GPIO_PinAFConfig(NRF_SPI_SCK_PORT, GPIO_PinSource2, GPIO_AF6_SPI5);}
#define NRF_SPI_CLOCK(ENABLE_OR_DISABLE)             RCC_APB2PeriphClockCmd(RCC_APB2Periph_SPI5, ENABLE_OR_DISABLE)         

#define NRF_IRQ_PIN                                  GPIO_Pin_3
#define NRF_IRQ_PORT                                 GPIOE
#define NRF_IRQ_EXTI_LINE                            EXTI_Line3
#define NRF_IRQ_EXTI_PORT_SOURCE                     EXTI_PortSourceGPIOE
#define NRF_IRQ_EXTI_PIN_SOURCE                      EXTI_PinSource3
#define NRF_IRQ_EXTI_IRQn                            EXTI3_IRQn
#define NRF_IRQ_IRQHandler                           EXTI3_IRQHandler
#define NRF_IRQ_EXTI_PRIORITY                        14//highest-x priority with use FreeRTOS API

//#define IS_NRF_SPI_IT_MODE
#if defined(IS_NRF_SPI_IT_MODE)
#define NRF_SPI_IRQn                                 SPI5_IRQn
#define NRF_SPI_IRQHandler                           SPI5_IRQHandler   
#define NRF_SPI_IRQn_PRIORITY                        15
#endif //IS_NRF_SPI_IT_MODE

#define BSP_NRF_SETTINGS_SECTOR_NUMBER              (NRF_SETTINGS_SECTOR_NUMBER)
#define BSP_NRF_SETTINGS_SECTOR_ADDR                (NRF_SETTINGS_SECTOR_ADDR)
#define BSP_NRF_SETTINGS_SECTOR_SIZE                (NRF_SETTINGS_SECTOR_SIZE)
  
  
void nrf_bsp_init( void (*nrf_irq)(void) );
void nrf_bsp_deinit(void);

void nrf_bsp_delay_ms(uint32_t ms);
void nrf_bsp_delay_us(uint32_t us);
uint32_t nrf_bsp_get_ms(void);
void nrf_bsp_get_unique_id(uint32_t* unique_id);
uint32_t nrf_bsp_crc(uint8_t* buff, uint32_t len);

void nrf_chip_enable(void);
void nrf_chip_disable(void);
void spi_write_block_nRF(uint8_t addr, uint8_t* data, uint8_t length);
uint8_t spi_write_com_nRF(uint8_t command);
void spi_read_block_nRF(uint8_t addr, uint8_t* data, uint8_t length);
uint8_t spi_read_byte_nRF(uint8_t addr);
void spi_write_byte_nRF(uint8_t addr, uint8_t data);

extern void bb_lock_unlock(uint8_t is_lock);
extern void LOG(const char* string, ...);

#ifdef __cplusplus
}
#endif  

#endif // __NRF_BSP_H
