/**
******************************************************************************
* File Name          : nvic_exti_driver.h
* Description        :  NVIC   EXTI
*
*
******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __NVIC_EXTI_DRIVER_H
#define __NVIC_EXTI_DRIVER_H
#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
/* Defines -------------------------------------------------------------------*/

//-   LIS_IRQ  AFIO_EXTI 
#define LIS_IRQ_GPIO_Port        GPIOG
#define LIS_IRQ_Pin              GPIO_Pin_2
#define __LIS_SPI_EXTI_LINE_CONFIG()	(SYSCFG_EXTILineConfig(EXTI_PortSourceGPIOG, GPIO_PinSource2))

//- LIS_IRQn EXTI 
#define LIS_IRQ_EXTI_LINEx      EXTI_Line2
#define LIS_NVIC_IRQn		EXTI2_IRQn
#define __LIS_IRQ_NVIC_Init()   (NVIC_EXTI2_Init())

#define __LIS_IRQ_EXTI_ENABLE()		(EXTI->IMR|=EXTI_IMR_MR2)	// SPL - %@$&@!!!
#define __LIS_IRQ_EXTI_DISNABLE()	(EXTI->IMR&=~EXTI_IMR_MR2)

/* Extern functions ----------------------------------------------------------*/
void LIS_IRQ_Handler(void);

/* Public functions ----------------------------------------------------------*/
void LIS_IRQ_Init(void);
void NVIC_EXTI2_Init(void);

#ifdef __cplusplus
}
#endif
#endif // __NVIC_EXTI_DRIVER_H
