/**
******************************************************************************
* File Name          :
* Description        :
*                      
*                      
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include <string.h>
#include "rng_driver.h"

//    !

inline void rng_init(void)
{
  RCC_AHB2PeriphClockCmd(RCC_AHB2Periph_RNG, ENABLE);
  
  RNG_Cmd(ENABLE);
}

inline void rng_deinit(void)
{
  RNG_Cmd(DISABLE);
}

inline uint32_t get_rng(void)
{
  while(RNG_GetFlagStatus(RNG_FLAG_DRDY)== RESET);
  
  return RNG_GetRandomNumber();
}

void randmemset(void* const dst, const uint16_t size)
{
  uint32_t rng;
  uint16_t offset;
  
  for(offset=0; offset<((size/sizeof(rng))*sizeof(rng)); offset+=sizeof(rng))
  {
    rng=get_rng();
    memcpy((uint8_t*)dst+offset, &rng, sizeof(rng));
  }
  
  if(size%sizeof(rng))
  {
    rng=get_rng();
    memcpy((uint8_t*)dst+offset, &rng, size%sizeof(rng));
  }
}