/**
******************************************************************************
* File Name          : rs485_driver.h
* Description        : RS485 driver   
*                      
*                      
******************************************************************************
*/
#ifndef __RS485_DRIVER_H
#define __RS485_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes -----------------------------------------------------------------*/
#include <stdint.h>

#define RS485_UART                         USART1
#define RS485_UART_IRQn                    USART1_IRQn
#define RS485_UART_IRQHandler              USART1_IRQHandler
#define RS485_UART_IRQn_PRIO               12 //highest-1 priority with use FreeRTOS API

#define RS485_UART_TX_PORT                 GPIOB
#define RS485_UART_TX_PIN                  GPIO_Pin_6
#define RS485_UART_TX_PIN_OTYPE            GPIO_OType_PP

#define RS485_UART_RX_PORT                 GPIOB
#define RS485_UART_RX_PIN                  GPIO_Pin_7
#define RS485_UART_RX_PIN_PUPD             GPIO_PuPd_UP

#define RS485_UART_RE_PORT                 GPIOB
#define RS485_UART_RE_PIN                  GPIO_Pin_3

#define RS485_UART_DE_PORT                 GPIOB
#define RS485_UART_DE_PIN                  GPIO_Pin_4
#define RS485_UART_DE_OUT_WAIT             10

#define __RS485_UART_CLOCK_ENABLE()        {RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, ENABLE);}
#define __RS485_UART_CLOCK_DISABLE()       {RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1, DISABLE);}

#define __RS485_UART_REMAP()	           {GPIO_PinAFConfig(RS485_UART_TX_PORT, GPIO_PinSource6, GPIO_AF_USART1); \
                                            GPIO_PinAFConfig(RS485_UART_RE_PORT, GPIO_PinSource7, GPIO_AF_USART1);}

USART_TypeDef* RS485_Get_Pherph(void);
void RS485_Init(void);
void RS485_DeInit(void);
void RS485_SetParam(int baudrate, int timeout, const char* param_string);
void RS485_SetExtParam(int baudrate, int timeout, const char* param_string, bool (*data_recv_it_callback)(const uint8_t* data, const uint16_t len));
uint16_t RS485_TxRx(const uint8_t* sbuf, uint16_t slen, uint8_t* rbuf, uint16_t rlen);

extern void RS485_Grab(void);
extern bool RS485_Trying_Grab(void);
extern void RS485_Release(void);

#ifdef __cplusplus
}
#endif

#endif /* ___RS485_DRIVER_H */
