/**
******************************************************************************
* File Name          : rsuart_driver.c
* Description        : RS-UART driver    
**                       ST32F10x
*                      
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include <stdbool.h>
#include "ll_rs_driver.h"
#include "rsuart_driver.h"

#if defined(RS_UART_PRESENT)

static void remap(void)
{
  __RS_UART_REMAP();
}

static void clock(const bool enable)
{
  if(enable) {__RS_UART_CLOCK_ENABLE();}
  else       {__RS_UART_CLOCK_DISABLE();}
}

static const ll_uart_hw_t hw =
{
  .uart_pherph = RS_UART,
  
  .irqn = RS_UART_IRQn,
  .irq_prio = RS_UART_IRQn_PRIO,
  .remap = remap,
  .clock = clock,
  
  .tx_port = RS_UART_TX_PORT,
  .tx_pin = RS_UART_TX_PIN,
  .tx_pin_otype = RS_UART_TX_PIN_OTYPE,
  
  .rx_port = RS_UART_RX_PORT,
  .rx_pin = RS_UART_RX_PIN,
  .rx_pin_pupd = RS_UART_RX_PIN_PUPD,
  
  .re_port = RS_UART_RE_PORT,
  .re_pin = RS_UART_RE_PIN,
  
  .de_port = RS_UART_DE_PORT,
  .de_pin = RS_UART_DE_PIN,
  .de_out_wait = RS_UART_DE_OUT_WAIT,
};

static ll_uart_driver_t driver =
{
  .txrx_end_sem = NULL,
  .uart_state = IDLE,
  .data_recv_it_callback = NULL,
  .hw = &hw,
};

USART_TypeDef* RSUART_Get_Pherph(void) {return driver.hw->uart_pherph;}
void RSUART_Init(void){ll_rs_init(&driver);}
void RSUART_DeInit(void){ll_rs_deinit(&driver);}
void RSUART_SetParam(int baudrate, int timeout, const char* param_string){ll_rs_set_param(&driver, baudrate, timeout, param_string);}
void RSUART_SetExtParam(int baudrate, int timeout, const char* param_string, bool (*data_recv_it_callback)(const uint8_t* data, const uint16_t len)){ll_rs_set_ext_param(&driver, baudrate, timeout, param_string, data_recv_it_callback);}
uint16_t RSUART_TxRx(const uint8_t* sbuf, uint16_t slen, uint8_t* rbuf, uint16_t rlen){return ll_rs_txrx(&driver, sbuf, slen, rbuf, rlen);}

#ifdef __cplusplus
extern "C" {
#endif

#pragma optimize=speed
void RS_UART_IRQHandler(void) {ll_rs_irq_handler(&driver);}

#ifdef __cplusplus
}
#endif

#endif //defined(RS_UART_PRESENT)
