/**
******************************************************************************
* File Name          : rsuart_driver.h
* Description        : RS-UART driver   
*                      
*                      
******************************************************************************
*/
#ifndef __RSUART_DRIVER_H
#define __RSUART_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

#define RS_UART                            UART8
#define RS_UART_IRQn                       UART8_IRQn
#define RS_UART_IRQHandler                 UART8_IRQHandler
#define RS_UART_IRQn_PRIO                  12 //highest-1 priority with use FreeRTOS API

#define RS_UART_TX_PORT                    GPIOE
#define RS_UART_TX_PIN                     GPIO_Pin_1
#define RS_UART_TX_PIN_OTYPE               GPIO_OType_PP

#define RS_UART_RX_PORT                    GPIOE
#define RS_UART_RX_PIN                     GPIO_Pin_0
#define RS_UART_RX_PIN_PUPD                GPIO_PuPd_NOPULL

#define RS_UART_RE_PORT                    NULL
#define RS_UART_RE_PIN                     0

#define RS_UART_DE_PORT                    NULL
#define RS_UART_DE_PIN                     0
#define RS_UART_DE_OUT_WAIT                10
  
#define __RS_UART_CLOCK_ENABLE()           {RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART8, ENABLE);}
#define __RS_UART_CLOCK_DISABLE()          {RCC_APB1PeriphClockCmd(RCC_APB1Periph_UART8, DISABLE);}

#define __RS_UART_REMAP()	           {GPIO_PinAFConfig(RS_UART_TX_PORT, GPIO_PinSource1, GPIO_AF_UART8); \
                                            GPIO_PinAFConfig(RS_UART_RX_PORT, GPIO_PinSource0, GPIO_AF_UART8);}

USART_TypeDef* RSUART_Get_Pherph(void);
void RSUART_Init(void);
void RSUART_DeInit(void);
void RSUART_SetParam(int baudrate, int timeout, const char* param_string);
void RSUART_SetExtParam(int baudrate, int timeout, const char* param_string, bool (*data_recv_it_callback)(const uint8_t* data, const uint16_t len));
uint16_t RSUART_TxRx(const uint8_t* sbuf, uint16_t slen, uint8_t* rbuf, uint16_t rlen);

extern void RSUART_Grab(void);
extern bool RSUART_Trying_Grab(void);
extern void RSUART_Release(void);

#ifdef __cplusplus
}
#endif

#endif /* __RSUART_DRIVER_H */
