/**
******************************************************************************
* File Name          : rtc_driver.h
* Description        : Драйвер rtc stm32f2xx
*
*
******************************************************************************
*/
#ifndef __RTC_DRIVER_H
#define __RTC_DRIVER_H

#ifdef __cplusplus
extern "C" {
#endif

  /* Includes ----------------------------------------------------------------*/
#include "stm32f4xx_rtc.h"
#include "stdint.h"
#include "stdio.h"

  /* Private define ----------------------------------------------------------*/
#if defined(BOOTLOADER)
#define RTC_LOCK_EN     0
#else
#define RTC_LOCK_EN     1
#endif

  /* Exported functions ----------------------------------------------------- */
  void RtcClockInit(void);
  void SetUnixTime(uint32_t time);
  void SetWakeupTime(uint32_t wakeup_after);
  uint32_t GetUnixTime(void);

#ifdef __cplusplus
}
#endif

#endif /* __RTC_DRIVER_H */