/**
******************************************************************************
* File Name          : freertos_hooks.c
* Description        : кэп
*                        
*                      
*                             
******************************************************************************
*/
/* Includes ------------------------------------------------------------------*/
#include "FreeRTOSConfig.h"
#include "FreeRTOS.h"
#include "task.h"
#include "stdint.h"
#include "system_config.h"

/* Extern variables ---------------------------------------------------------*/
extern void Soft_timers_handler(void);
/* Private functions ---------------------------------------------------------*/
#if ( configUSE_TICK_HOOK == 1 )
extern void usbd_cdc_SOF_timer_callback(void);

void vApplicationTickHook(void)
{
  Soft_timers_handler();
  usbd_cdc_SOF_timer_callback();
  
#if defined(STM32F2XX)
#error check add_tick_timer.c
#endif //defined(STM32F2XX)
}
#else
#error
#endif /* configUSE_TICK_HOOK */

#if ( configUSE_IDLE_HOOK == 1 )
void vApplicationIdleHook(void)
{
  
}
#endif /* configUSE_IDLE_HOOK */

#if ( configCHECK_FOR_STACK_OVERFLOW > 0 )
#include "debug_port.h"
void vApplicationStackOverflowHook(TaskHandle_t xTask, char *pcTaskName)
{
  volatile char *name;
  volatile TaskHandle_t pxT;
  volatile uint32_t timeout_tx;
    
  name = pcTaskName;
  pxT  = xTask;
  timeout_tx=0;
  for(;;)
  {
    if(!timeout_tx)
    {
#if (!defined(USE_USB_DEBUG_PORT))
      printf("StackOverflow:\nTaskName: %s, Handle: %p\n", name, pxT);
#endif
      timeout_tx=15000000;
    }
    else timeout_tx--;
  }
}
#endif /* configCHECK_FOR_STACK_OVERFLOW */


#if ( configUSE_APPLICATION_TASK_TAG == 1 )
#warning use configUSE_APPLICATION_TASK_TAG for hard debug only!!!

void TaskSwithedHook(int tag, uint8_t is_enter)
{
  //
}
#endif /* configUSE_APPLICATION_TASK_TAG == 1 */
