/**
  ******************************************************************************
  * File Name          : system_messages.h
  * Description        : Коды внутрисистемных сообщений и команд
  *
  *
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __SYSTEM_MESSAGES_H
#define __SYSTEM_MESSAGES_H

#include <stdint.h>

/* Defines  ------------------------------------------------------------------*/

// Идентификаторы менеджеров для генерации сообщений
#define SYSCOM_MANAGER                 0x01 // Администратор
#define GPS_MANAGER                    0x02 // Менеджер GPS
#define SERVER_MANAGER                 0x03 // Менеджер GSM
#define SIGNAL_MANAGER                 0x04 // Менеджер сигналов

// Идентификаторы команд и сообщений

//////////////////////ОБЩИЕ ДЛЯ ВСЕХ МЕНЕДЖЕРОВ/////////////////////////////////
//Команды
#define COMMAND_SLEEP                  0x01  // Заснуть
#define COMMAND_WAKEUP                 0x02  // Проснуться
#define COMMAND_UPDATE_SETTINGS        0x03  // Обновить настройки

#define NORMAL_SLEEP                   0x00
#define EMERGENCY_SLEEP                0x01
#define BOOT_UPD_QUASI_SLEEP           0x02

////////////////////////////GPS MANAGER/////////////////////////////////////////
//Команды
#define COMMAND_RESET_ODOMETER        0x21 //Сбросить одометр
#define COMMAND_RESET_TRIPCOUNTER     0x22 // Сбросить счетчик поездок
#define COMMAND_UPDATE_GNSS_FIMWARE   0x23 // Обновить прошивку приемника
#define COMMAND_GNSS_HW_COLD_START    0x24 // Холодный рестарт GNSS приемника
#define COMAND_UPDATE_GNSS_FREQ       0x25 // Change generate frequency GNSS flow

//Сообщения
#define MESSAGE_GPS_TRACK_DATA         0x21 // Данные трека от GPS
#define MESSAGE_GPS_POSITION_FIXED     0x22 // Определено местоположение
#define MESSAGE_GPS_POSITION_LOST      0x23 // Потеряно местоположение
#define MESSAGE_GPS_STOP_FIXED         0x24 // Зафиксирована остановка
#define MESSAGE_GPS_MOVE_FIXED         0x25 // Зафиксировано движение
#define MESSAGE_GPS_NO_SIGNAL          0x27 // Длительное отсутствие сигнала спутников
#define MESSAGE_GPS_CANT_FIX           0x28 // Невозможность определить местоположение
#define MESSAGE_GPS_JAMMED             0x29 // Обнаружено глушение
#define MESSAGE_GPS_CHECK              0x2A // Сигнал check от GPS
#define MESSAGE_GPS_RESTORE            0x2B // Восстановление
#define MESSAGE_GPS_SAVE_BASE          0x2C // Сохранить настройки

////////////////////////////SERVER MANAGER//////////////////////////////////////
//Команды
#define COMMAND_GSM_POWER               0x41 // Активировать/деактивировать модем
#define COMMAND_UP_SESSION_FORCE        0x42 // Внеочередной подъем сессии
#define COMMAND_SERVER_SEND_SMS         0x43 // В субкоде указывается порядковый номер авторизованного телефона начиная с нуля, в pPayload лежит указатель на текст СМСки,
                                             // в payload_size указан максимальный размер памяти под СМС, с учетом '\0'
#define COMMAND_SERVER_DATA_ANSWER_OK   0x44
#define COMMAND_SERVER_DATA_ANSWER_ERR  0x45
#define COMMAND_SERVER_CALL_TO_AUTH_NUM 0x46

//Сообщения
#define MESSAGE_SERVER_RECV_DATA        0x41
#define MESSAGE_SERVER_NO_SIGNAL        0x42 // Длительное отсутствие сигнала сети
#define MESSAGE_SERVER_JAMMED           0x43 // Обнаружено глушение
#define MESSAGE_SERVER_CHECK            0x44 // Через subcode передается что конкретно сломалось
#define MESSAGE_SERVER_RESTORE          0x45
#define MESSAGE_SERVER_FILE_DOWNLOADED  0x46 // сервер принял файл, в payload указатель на имя фала
#define MESSAGE_SERVER_SAVE_BASE        0x47 // Сервер получил настройки по СМС и записал их в system. Надо теперь сохранить
#define MESSAGE_SERVER_TAKE_PHOTO       0x48 // Сервер получил команду сделать фото и транслирует ее в Syscom
#define MESSAGE_SERVER_CAN_CONTROL      0x49 // Команда управления по CAN, см. subcode
#define MESSAGE_SERVER_REBOOT_GNSS      0x4A // Команда перезарзурить GNSS

////////////////////////////SIGNAL MANAGER//////////////////////////////////////
// Команды
//#define COMMAND_SIGNAL_DIGITAL_OUTPUT_SET     0x61 // Установить состояние цифрового выхода, номер передается через subcode
//#define COMMAND_SIGNAL_DIGITAL_OUTPUT_RESET   0x62 // Установить состояние цифрового выхода, номер передается через subcode
#define COMMAND_SIGNAL_PHOTO_GET              0x63 // Сделать фотку
#define COMMAND_UPDATE_CAN_FIMWARE            0x64 // Обновить прошивку can процессора
#define COMMAND_CAN_CONTROL                   0x65 // Команда управления по CAN, см. subcode
#define COMMAND_SIGNAL_START_PROD_TESTS       0x66 // Команда на старт производственных тестов
#define COMMAND_SIGNAL_LORA_SENS_ALARMS_RESET 0x67 // Команда на старт производственных тестов
#define COMMAND_SIGNAL_NRF_ADD_RELAY          0x68 // Команда на добавление реле
#define COMMAND_SIGNAL_NRF_DEL_RELAY          0x69 // Команда на удаление реле
#define COMMAND_SIGNAL_NRF_ADD_MARK           0x6A // Команда на добавление метки, id метки в subcode
#define COMMAND_SIGNAL_NRF_DEL_MARK           0x6B // Команда на удаление метки, id метки в subcode

//Субкоды для COMMAND_CAN_CONTROL и MESSAGE_DERVER_CAN_CONTROL
#define CAN_BLINKER_FLASHING_SUBCODE          0
#define CAN_HORN_SIGNALING_SUBCODE            1
#define CAN_HORN_W_BLINKER_SIGNALIG_SUBCODE   2
#define CAN_WINDOWS_CLOSING_1S_SUBCODE        3
#define CAN_WINDOWS_CLOSING_3S_SUBCODE        4
#define CAN_WINDOWS_CLOSING_5S_SUBCODE        5
#define CAN_WINDOWS_CLOSING_7S_SUBCODE        6
#define CAN_WINDOWS_CLOSING_9S_SUBCODE        7
#define CAN_WINDOWS_CLOSING_11S_SUBCODE       8
#define CAN_WINDOWS_CLOSING_13S_SUBCODE       9
#define CAN_WINDOWS_CLOSING_15S_SUBCODE       10
#define CAN_WINDOWS_CLOSING_17S_SUBCODE       11
#define CAN_WINDOWS_CLOSING_19S_SUBCODE       12
#define CAN_WINDOWS_CLOSING_21S_SUBCODE       13
#define CAN_WINDOWS_CLOSING_23S_SUBCODE       14
#define CAN_WINDOWS_CLOSING_25S_SUBCODE       15
#define CAN_WINDOWS_CLOSING_27S_SUBCODE       16
#define CAN_WINDOWS_CLOSING_29S_SUBCODE       17
#define CAN_WINDOWS_OPENING_1S_SUBCODE        18
#define CAN_WINDOWS_OPENING_3S_SUBCODE        19
#define CAN_WINDOWS_OPENING_5S_SUBCODE        20
#define CAN_WINDOWS_OPENING_7S_SUBCODE        21
#define CAN_WINDOWS_OPENING_9S_SUBCODE        22
#define CAN_WINDOWS_OPENING_11S_SUBCODE       23
#define CAN_WINDOWS_OPENING_13S_SUBCODE       24
#define CAN_WINDOWS_OPENING_15S_SUBCODE       25
#define CAN_WINDOWS_OPENING_17S_SUBCODE       26
#define CAN_WINDOWS_OPENING_19S_SUBCODE       27
#define CAN_WINDOWS_OPENING_21S_SUBCODE       28
#define CAN_WINDOWS_OPENING_23S_SUBCODE       29
#define CAN_WINDOWS_OPENING_25S_SUBCODE       30
#define CAN_WINDOWS_OPENING_27S_SUBCODE       31
#define CAN_WINDOWS_OPENING_29S_SUBCODE       32
#define CAN_ALL_DOOR_CLOSING_SUBCODE          33
#define CAN_DRIVER_DOOR_OPENING_SUBCODE       34
#define CAN_ALL_DOOR_OPENING_SUBCODE          35
#define CAN_TRUNK_DOOR_OPENING_SUBCODE        36
#define CAN_ENGINE_STOPING_SUBCODE            37
#define CAN_ENGINE_STARTING_SUBCODE           38
#define CAN_EMULATION_DRIVER_DOOR_OPENING_SUBCODE 39
#define CAN_WEBASTO_STOPPING_SUBCODE          40
#define CAN_WEBASTO_STARTING_SUBCODE          41

#define YADRIVE_WARMING_SUBCODE               42
#define YADRIVE_STOP_WARMING_SUBCODE          43
#define YADRIVE_START_OF_LEASE_SUBCODE        44
#define YADRIVE_END_OF_LEASE_SUBCODE          45
#define CAN_ALL_DOOR_CLOSING_V2_SUBCODE       46
#define YADRIVE_HOOD_UNLOCK_SUBCODE           47
#define YADRIVE_HOOD_LOCK_SUBCODE             48
#define CAN_ALL_DOOR_OPENING_V2_SUBCODE       49
#define YADRIVE_FORCED_END_OF_LEASE_SUBCODE   50
#define CAN_ENGINE_STOPING_W_CLS_CLOSE_SUBCODE 51
#define YADRIVE_PANIC_SUBCODE                 52
#define CAN_ENGINE_STOPING_W_WIRELESS_BLOCK_ON_SUBCODE 53
#define AUXILIARY_CAR_COMMANDS_SUBCODE        54
#define CAN_BLINKER_FLASHING_V2_SUBCODE       55
#define CAN_HORN_W_BLINKER_FLASHING_IN_ALARM_SUBCODE  56
#define CAN_PRESS_TRC_BUTTON_SUBCODE  57
#define YADRIVE_DTC_CLEAR_SUBCODE            58

//Additional CAN subcodes for COMMAND_CAN_CONTROL
#define CAN_OFF_AUTO_OPEN_DOORS               58
#define CAN_FIX_FUEL_VIEW                     59

//Сообщения
#define MESSAGE_SIGNAL_CHECK                  0x61 // Сигнал check от сигнального менеджера
#define MESSAGE_SIGNAL_RESTORE                0x62 // восстановление
#define MESSAGE_SIGNAL_CAN_FW_UPD_RESULT      0x63 // Резултат обновления прошивки can, subcode 0: fail, 1: done

//Субкоды
#define SUBCODE_INVALID_WAKEUP_CONFIG   0x00
#define SUBCODE_WAKEUP_BY_IGN           0x01
#define SUBCODE_WAKEUP_BY_MOVE          0x02
#define SUBCODE_WAKEUP_BY_TIME          0x03
#define SUBCODE_WAKEUP_BY_USB           0x04
#define SUBCODE_WAKEUP_BY_EXT_POWER     0x05
#define SUBCODE_WAKEUP_BY_ALARM_BUTTON  0x06
#define SUBCODE_WAKEUP_BY_TAMPER        0x07
#define SUBCODE_WAKEUP_BY_BOOT_UPD_FAIL 0x08
#define SUBCODE_WAKEUP_BY_CAN_ACTIVITY  0x09

//////////////////// Внутрисистемное сообщение//////////////////////////////////
typedef struct
{
  // Отправитель
  uint8_t source;
  // ID отправителя
  uint8_t source_id;
  // Код сообщения
  uint8_t code;
  // Код субкоманды или параметр
  uint32_t subcode;
  // Полезная нагрузка
  const void *pPayload;
  // Размер полезной нагрузки
  uint16_t payload_size;
  // Куда писать ответ
  void* pAnswer;
  // Размер буфера под ответ
  uint16_t answer_size;
  // UID команды, используется в случае передачи команды не в VEGA протоколе
  uint32_t command_uid;
  // Неповторяющееся число
  uint8_t command_nonce[8];
  // Дополнительные параметры
  uint32_t ext_args;
} T_system_message;


#endif /*SYSTEM_MESSAGES_H*/