/**
  ******************************************************************************
  * @file           : Accel_sensors_config.h
  * @brief          : Header for config Accelerometer.
  ******************************************************************************
  * COPYRIGHT(c) 2016
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __ACCEL_SENSORS_CONFIG_H
#define __ACCEL_SENSORS_CONFIG_H

#include "FreeRTOS.h"
#include "task.h"

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/   
/* Exported types ------------------------------------------------------------*/  

/* Defines -------------------------------------------------------------------*/
//-  MEMS 
#define ACCEL_MEMS_TYPE_LIS3DH	// _LIS3DH // _LIS331DLH

#define LIS_Delay(ms)                           (vTaskDelay(ms))

#define ACCEL_FRAME_RATE_kHZ                    (400)

#define DEF_ACCEL_MOVE_DELAY_TO_STOP		(60*ACCEL_FRAME_RATE_kHZ) // 20*400 = 20s * 400kHz
#define DEF_ACCEL_TILT_DELAY_TO_STOP		(60*ACCEL_FRAME_RATE_kHZ) // 30*400 = 30s * 400kHz

#define DISABLE_ACCEL_TILT
//#define DISABLE_ACCEL_MOVE

/* Global variables-----------------------------------------------------------*/
/* Exported function prototypes ----------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif // __ACCEL_SENSORS_CONFIG_H
