/**
  ******************************************************************************
  * @file    SPL_platform_config.h
  *
  * @brief   STM32L1 stm32F1 STM32F3 specific configuration file.
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __SPL_PLATFORM_CONFIG_H
#define __SPL_PLATFORM_CONFIG_H

/* Includes ------------------------------------------------------------------*/
#if defined(STM32L1XX_MD) || defined(STM32L1XX_HD)|| defined(STM32L1XX_MD_PLUS)
 #include "stm32l1xx.h"

#elif defined (STM32F10X_MD) || defined (STM32F10X_HD) || defined (STM32F10X_XL)
 #include "stm32f10x.h"

#elif defined(STM32F2XX)
 #include "stm32f2xx.h"

#elif defined(STM32F30X)
 #include "stm32f30x.h"
#elif defined(STM32F37X)
 #include "stm32f37x.h"

#else
 #error "Missing define for SPL include!!!"
#endif


#endif /* __SPL_PLATFORM_CONFIG_H */


