/**
  ******************************************************************************
  * File Name          : 
  * Description        : 
  *                      
  ******************************************************************************
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BOOT_CONF_H
#define __BOOT_CONF_H

#include "stm32f4xx.h"
#include "system_config.h"

/* Defines- ------------------------------------------------------------------*/
//// ///////////////////////////////////////////////////////////
#define BOOTLOADER_MODEL_2

#define BOARD_HW_VERSION 0

#define BOOTLOADER_VERSION_STRING       "VEGA MT-32K LTE " HW_VERSION_STRING "boot 0.4"

#define DEVICE_MARKER_MAX_SIZE          48//      ( !) 
#define DEVICE_MARKER                   DEV_TYPE_STRING   

typedef enum
{
  NORMAL_SYSTEM_START = 0,
  UPGRADE_FW_CMD,
  RES_FLASHED_OK,
  RES_IMAGE_ERR,
  RES_FLASH_DEVICE_ERR,
  RES_EXT_MEM_ERR,
  RES_CRYPT_LIB_ERR,
  RES_UNKNOWN_ERR = 254
}boot_status;

typedef struct
{
  char fname[16];
  boot_status cmd;          
}boot_cmd_t;


///BOOTLOADER///////////////////////////////////////////////////////////////////
/* Base address of the Flash sectors */
#define ADDR_FLASH_SECTOR_0     ((uint32_t)0x08000000) /* Base @ of Sector 0, 16 Kbytes */
#define ADDR_FLASH_SECTOR_1     ((uint32_t)0x08004000) /* Base @ of Sector 1, 16 Kbytes */
#define ADDR_FLASH_SECTOR_2     ((uint32_t)0x08008000) /* Base @ of Sector 2, 16 Kbytes */
#define ADDR_FLASH_SECTOR_3     ((uint32_t)0x0800C000) /* Base @ of Sector 3, 16 Kbytes */
#define ADDR_FLASH_SECTOR_4     ((uint32_t)0x08010000) /* Base @ of Sector 4, 64 Kbytes */
#define ADDR_FLASH_SECTOR_5     ((uint32_t)0x08020000) /* Base @ of Sector 5, 128 Kbytes */
#define ADDR_FLASH_SECTOR_6     ((uint32_t)0x08040000) /* Base @ of Sector 6, 128 Kbytes */
#define ADDR_FLASH_SECTOR_7     ((uint32_t)0x08060000) /* Base @ of Sector 7, 128 Kbytes */
#define ADDR_FLASH_SECTOR_8     ((uint32_t)0x08080000) /* Base @ of Sector 8, 128 Kbytes */
#define ADDR_FLASH_SECTOR_9     ((uint32_t)0x080A0000) /* Base @ of Sector 9, 128 Kbytes */
#define ADDR_FLASH_SECTOR_10    ((uint32_t)0x080C0000) /* Base @ of Sector 10, 128 Kbytes */
#define ADDR_FLASH_SECTOR_11    ((uint32_t)0x080E0000) /* Base @ of Sector 11, 128 Kbytes */

static_assert(!(FLASH_BASE!=ADDR_FLASH_SECTOR_0), "wrong ADDR_FLASH_SECTOR_0");

#define USE_BOOTLOADER
#define CHECK_PROT_BITS                 1                //   
#define DEVICE_FLASH_SIZE               (1*1024*1024)    //  Flash- 
#define DEVICE_INT_VECT_SIZE            0x1d8            //     

static_assert(!(DEVICE_FLASH_SIZE>1*1024*1024), "wrong DEVICE_FLASH_SIZE");

#define BOOT_START_ADDR                 (FLASH_BASE+DEVICE_INT_VECT_SIZE)

#ifdef USE_BOOTLOADER
  #define NRF_SETTINGS_SECTOR_NUMBER    (FLASH_Sector_2)
  #define NRF_SETTINGS_SECTOR_ADDR      (ADDR_FLASH_SECTOR_2)
  #define NRF_SETTINGS_SECTOR_SIZE      (16*1024)
  #define APP_START_ADDRESS             (ADDR_FLASH_SECTOR_3)                                                             //  
  #define APP_END_ADDRESS               (APP_START_ADDRESS + DEVICE_FLASH_SIZE - (APP_START_ADDRESS-FLASH_BASE) - 1)      //  
#else
  #define APP_START_ADDRESS             (ADDR_FLASH_SECTOR_0) 
  #define APP_END_ADDRESS               (ADDR_FLASH_SECTOR_0 + DEVICE_FLASH_SIZE-1) //  
#endif

#if (!defined(BOOTLOADER))
const char* __get_fw_version(void);
#else
const char* __get_botloader_version(void);
#endif
const char* __get_flashed_marker(void);
const char* __get_device_type_marker(void);
const uint8_t* __get_fw_key(void);
const uint32_t* __get_vega_signat_key(void);
uint8_t __get_board_hw_version(void);

#endif // __BOOT_CONF_H